/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import com.sun.image.codec.jpeg.JPEGCodec;
/*     */ import com.sun.image.codec.jpeg.JPEGImageDecoder;
/*     */ import com.sun.image.codec.jpeg.JPEGImageEncoder;
/*     */ import java.awt.Image;
/*     */ import java.awt.image.BufferedImage;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.mail.internet.ContentType;
/*     */ import javax.mail.internet.MimeMultipart;
/*     */ import javax.mail.internet.ParseException;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class MimeUtils
/*     */ {
/*  61 */   private static Map<String, Class> mime2class = new HashMap();
/*  62 */   private static Map<Class, String> class2mime = new HashMap();
/*     */ 
/*     */   public static QName convertMimeTypeToXmlType(String mimeType)
/*     */   {
/*  84 */     StringBuilder mimeName = new StringBuilder(mimeType);
/*     */ 
/*  86 */     int pos = mimeName.indexOf("/");
/*     */ 
/*  88 */     if (pos == -1) {
/*  89 */       return null;
/*     */     }
/*  91 */     mimeName.setCharAt(pos, '_');
/*     */ 
/*  93 */     return new QName("http://www.jboss.org/jbossws/attachment/mimetype", mimeName.toString());
/*     */   }
/*     */ 
/*     */   public static String getBaseMimeType(String mimeType)
/*     */   {
/* 107 */     if (mimeType == null)
/* 108 */       return null; ContentType contentType;
/*     */     try {
/* 111 */       contentType = new ContentType(mimeType);
/*     */     }
/*     */     catch (ParseException e)
/*     */     {
/* 115 */       return null;
/*     */     }
/*     */ 
/* 118 */     return contentType.getBaseType();
/*     */   }
/*     */ 
/*     */   public static boolean isMemberOf(String mimeType, Set mimeTypes)
/*     */   {
/* 133 */     if (mimeTypes.contains(mimeType)) {
/* 134 */       return true;
/*     */     }
/*     */     try
/*     */     {
/* 138 */       if (mimeTypes.contains(new ContentType(mimeType).getPrimaryType() + "/*")) {
/* 139 */         return true;
/*     */       }
/*     */     }
/*     */     catch (ParseException e)
/*     */     {
/*     */     }
/*     */ 
/* 146 */     return false;
/*     */   }
/*     */ 
/*     */   public static Class resolveClass(String mimeType)
/*     */   {
/* 154 */     Class cl = (Class)mime2class.get(mimeType);
/* 155 */     if (null == cl)
/* 156 */       cl = DataHandler.class;
/* 157 */     return cl;
/*     */   }
/*     */ 
/*     */   public static String resolveMimeType(Object obj)
/*     */   {
/* 166 */     String mimeType = (obj instanceof MimeMultipart) ? ((MimeMultipart)obj).getContentType() : resolveMimeType(obj.getClass());
/*     */ 
/* 169 */     return mimeType;
/*     */   }
/*     */ 
/*     */   public static String resolveMimeType(Class clazz) {
/* 173 */     String mimeType = "application/octet-stream";
/* 174 */     for (Class cl : class2mime.keySet())
/*     */     {
/* 176 */       if (JavaUtils.isAssignableFrom(cl, clazz))
/* 177 */         mimeType = (String)class2mime.get(cl);
/*     */     }
/* 179 */     return mimeType;
/*     */   }
/*     */ 
/*     */   public static ByteArrayConverter getConverterForJavaType(Class targetClazz)
/*     */   {
/* 184 */     ByteArrayConverter converter = null;
/* 185 */     if (JavaUtils.isAssignableFrom(Image.class, targetClazz))
/* 186 */       converter = new ImageConverter();
/* 187 */     else if (JavaUtils.isAssignableFrom(Source.class, targetClazz))
/* 188 */       converter = new SourceConverter();
/* 189 */     else if (JavaUtils.isAssignableFrom(String.class, targetClazz))
/* 190 */       converter = new StringConverter();
/* 191 */     else if (JavaUtils.isAssignableFrom(InputStream.class, targetClazz)) {
/* 192 */       converter = new StreamConverter();
/*     */     }
/* 194 */     if (null == converter) {
/* 195 */       throw new WSException("No ByteArrayConverter for class: " + targetClazz.getName());
/*     */     }
/* 197 */     return converter;
/*     */   }
/*     */ 
/*     */   public static ByteArrayConverter getConverterForContentType(String contentType)
/*     */   {
/* 202 */     ByteArrayConverter converter = null;
/*     */ 
/* 204 */     if (contentType != null)
/*     */     {
/* 206 */       if (("image/jpeg".equals(contentType)) || ("image/jpg".equals(contentType)))
/* 207 */         converter = new ImageConverter();
/* 208 */       else if (("text/xml".equals(contentType)) || ("application/xml".equals(contentType)))
/* 209 */         converter = new SourceConverter();
/* 210 */       else if ("text/plain".equals(contentType))
/* 211 */         converter = new StringConverter();
/* 212 */       else if ("application/octet-stream".equals(contentType)) {
/* 213 */         converter = new StreamConverter();
/*     */       }
/*     */     }
/* 216 */     if (null == converter) {
/* 217 */       throw new WSException("No ByteArrayConverter for content type: " + contentType);
/*     */     }
/* 219 */     return converter;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  65 */     mime2class.put("text/plain", String.class);
/*  66 */     mime2class.put("image/jpeg", Image.class);
/*  67 */     mime2class.put("text/xml", Source.class);
/*  68 */     mime2class.put("application/xml", Source.class);
/*  69 */     mime2class.put("application/octet-stream", DataHandler.class);
/*     */ 
/*  71 */     class2mime.put(Image.class, "image/jpeg");
/*  72 */     class2mime.put(Source.class, "text/xml");
/*  73 */     class2mime.put(String.class, "text/plain");
/*     */   }
/*     */ 
/*     */   public static abstract interface ByteArrayConverter
/*     */   {
/*     */     public abstract Object readFrom(InputStream paramInputStream);
/*     */ 
/*     */     public abstract void writeTo(Object paramObject, OutputStream paramOutputStream);
/*     */   }
/*     */ 
/*     */   public static class StreamConverter
/*     */     implements MimeUtils.ByteArrayConverter
/*     */   {
/*     */     public Object readFrom(InputStream in)
/*     */     {
/* 336 */       return in;
/*     */     }
/*     */ 
/*     */     public void writeTo(Object obj, OutputStream out) {
/* 340 */       if ((obj instanceof InputStream))
/*     */       {
/*     */         try
/*     */         {
/* 344 */           IOUtils.copyStream(out, (InputStream)obj);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 348 */           throw new WSException("Failed to convert " + obj.getClass());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class StringConverter
/*     */     implements MimeUtils.ByteArrayConverter
/*     */   {
/*     */     public Object readFrom(InputStream in)
/*     */     {
/* 290 */       Object converted = null;
/*     */       try
/*     */       {
/* 293 */         BufferedReader br = new BufferedReader(new InputStreamReader(in));
/* 294 */         StringBuilder sb = new StringBuilder();
/* 295 */         String line = null;
/*     */ 
/* 297 */         while ((line = br.readLine()) != null) {
/* 298 */           sb.append(line + "\n");
/*     */         }
/*     */ 
/* 301 */         br.close();
/*     */ 
/* 303 */         converted = sb.toString();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 307 */         throw new WSException("Failed to convert java.lang.String");
/*     */       }
/*     */ 
/* 310 */       return converted;
/*     */     }
/*     */ 
/*     */     public void writeTo(Object obj, OutputStream out) {
/* 314 */       if ((obj instanceof String))
/*     */       {
/* 316 */         String s = (String)obj;
/*     */         try
/*     */         {
/* 319 */           out.write(s.getBytes("UTF-8"));
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 323 */           throw new WSException("Failed to convert " + obj.getClass());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 328 */         throw new WSException("Unable to convert " + obj.getClass());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SourceConverter
/*     */     implements MimeUtils.ByteArrayConverter
/*     */   {
/*     */     public Object readFrom(InputStream in)
/*     */     {
/* 264 */       return new StreamSource(in);
/*     */     }
/*     */ 
/*     */     public void writeTo(Object obj, OutputStream out) {
/* 268 */       if ((obj instanceof StreamSource))
/*     */       {
/* 270 */         StreamSource s = (StreamSource)obj;
/*     */         try
/*     */         {
/* 273 */           IOUtils.copyStream(out, s.getInputStream());
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 277 */           throw new WSException("Failed to convert " + obj.getClass());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 282 */         throw new WSException("Unable to convert " + obj.getClass());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class ImageConverter
/*     */     implements MimeUtils.ByteArrayConverter
/*     */   {
/*     */     public Object readFrom(InputStream in)
/*     */     {
/* 224 */       Object converted = null;
/*     */       try
/*     */       {
/* 227 */         JPEGImageDecoder dec = JPEGCodec.createJPEGDecoder(in);
/* 228 */         BufferedImage bim = dec.decodeAsBufferedImage();
/* 229 */         converted = bim;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/* 236 */       return converted;
/*     */     }
/*     */ 
/*     */     public void writeTo(Object obj, OutputStream out) {
/* 240 */       if ((obj instanceof BufferedImage))
/*     */       {
/* 242 */         JPEGImageEncoder enc = JPEGCodec.createJPEGEncoder(out);
/*     */         try
/*     */         {
/* 245 */           enc.encode((BufferedImage)obj);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 249 */           throw new WSException("Failed to convert " + obj.getClass());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 254 */         throw new WSException("Unable to convert " + obj.getClass());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.MimeUtils
 * JD-Core Version:    0.6.0
 */