/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javassist.bytecode.ConstPool;
/*     */ import javassist.bytecode.FieldInfo;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.bytecode.SignatureAttribute;
/*     */ import javassist.bytecode.annotation.ArrayMemberValue;
/*     */ import javassist.bytecode.annotation.EnumMemberValue;
/*     */ import javassist.bytecode.annotation.StringMemberValue;
/*     */ 
/*     */ public class JavassistUtils
/*     */ {
/*     */   public static void addFieldAnnotation(CtField field, javassist.bytecode.annotation.Annotation annotation)
/*     */   {
/*  47 */     FieldInfo fieldInfo = field.getFieldInfo();
/*  48 */     AnnotationsAttribute attribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
/*  49 */     if (attribute == null)
/*  50 */       attribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
/*  51 */     attribute.addAnnotation(annotation);
/*  52 */     fieldInfo.addAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public static void addClassAnnotation(CtClass clazz, javassist.bytecode.annotation.Annotation annotation)
/*     */   {
/*  57 */     ClassFile classFile = clazz.getClassFile();
/*  58 */     AnnotationsAttribute attribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
/*  59 */     if (attribute == null)
/*  60 */       attribute = new AnnotationsAttribute(classFile.getConstPool(), "RuntimeVisibleAnnotations");
/*  61 */     attribute.addAnnotation(annotation);
/*  62 */     classFile.addAttribute(attribute);
/*     */   }
/*     */ 
/*     */   public static Annotation createAnnotation(Class<? extends java.lang.annotation.Annotation> annotation, ConstPool constPool)
/*     */   {
/*  67 */     return new Annotation(annotation, constPool);
/*     */   }
/*     */ 
/*     */   public static void addSignature(CtField field, String signature)
/*     */   {
/*  72 */     FieldInfo fieldInfo = field.getFieldInfo();
/*  73 */     ConstPool constPool = fieldInfo.getConstPool();
/*  74 */     SignatureAttribute signatureAttribute = new SignatureAttribute(constPool, signature);
/*  75 */     fieldInfo.addAttribute(signatureAttribute);
/*     */   }
/*     */ 
/*     */   public static void addSignature(CtMethod method, String signature)
/*     */   {
/*  80 */     MethodInfo methodInfo = method.getMethodInfo();
/*  81 */     ConstPool constPool = methodInfo.getConstPool();
/*  82 */     SignatureAttribute signatureAttribute = new SignatureAttribute(constPool, signature);
/*  83 */     methodInfo.addAttribute(signatureAttribute);
/*     */   }
/*     */ 
/*     */   public static class Annotation {
/*     */     private javassist.bytecode.annotation.Annotation annotation;
/*     */     private ConstPool constPool;
/*     */ 
/*     */     public Annotation(Class<? extends java.lang.annotation.Annotation> annotation, ConstPool constPool) {
/*  93 */       this.annotation = new javassist.bytecode.annotation.Annotation(annotation.getName(), constPool);
/*  94 */       this.constPool = constPool;
/*     */     }
/*     */ 
/*     */     public void addParameter(String name, String value)
/*     */     {
/*  99 */       this.annotation.addMemberValue(name, new StringMemberValue(value, this.constPool));
/*     */     }
/*     */ 
/*     */     public void addParameter(String name, Enum value)
/*     */     {
/* 104 */       EnumMemberValue enumValue = new EnumMemberValue(this.constPool);
/* 105 */       enumValue.setType(value.getClass().getName());
/* 106 */       enumValue.setValue(value.name());
/* 107 */       this.annotation.addMemberValue(name, enumValue);
/*     */     }
/*     */ 
/*     */     public void addParameter(String name, String[] values)
/*     */     {
/* 112 */       ArrayMemberValue member = new ArrayMemberValue(this.constPool);
/* 113 */       StringMemberValue[] members = new StringMemberValue[values.length];
/* 114 */       for (int i = 0; i < values.length; i++)
/* 115 */         members[i] = new StringMemberValue(values[i], this.constPool);
/* 116 */       member.setValue(members);
/* 117 */       this.annotation.addMemberValue(name, member);
/*     */     }
/*     */ 
/*     */     public void markClass(CtClass clazz)
/*     */     {
/* 122 */       JavassistUtils.addClassAnnotation(clazz, this.annotation);
/*     */     }
/*     */ 
/*     */     public void markField(CtField field)
/*     */     {
/* 127 */       JavassistUtils.addFieldAnnotation(field, this.annotation);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.JavassistUtils
 * JD-Core Version:    0.6.0
 */