/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.util.Calendar;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.holders.BigDecimalHolder;
/*     */ import javax.xml.rpc.holders.BigIntegerHolder;
/*     */ import javax.xml.rpc.holders.BooleanHolder;
/*     */ import javax.xml.rpc.holders.BooleanWrapperHolder;
/*     */ import javax.xml.rpc.holders.ByteArrayHolder;
/*     */ import javax.xml.rpc.holders.ByteHolder;
/*     */ import javax.xml.rpc.holders.ByteWrapperHolder;
/*     */ import javax.xml.rpc.holders.CalendarHolder;
/*     */ import javax.xml.rpc.holders.DoubleHolder;
/*     */ import javax.xml.rpc.holders.DoubleWrapperHolder;
/*     */ import javax.xml.rpc.holders.FloatHolder;
/*     */ import javax.xml.rpc.holders.FloatWrapperHolder;
/*     */ import javax.xml.rpc.holders.IntHolder;
/*     */ import javax.xml.rpc.holders.IntegerWrapperHolder;
/*     */ import javax.xml.rpc.holders.LongHolder;
/*     */ import javax.xml.rpc.holders.LongWrapperHolder;
/*     */ import javax.xml.rpc.holders.ObjectHolder;
/*     */ import javax.xml.rpc.holders.QNameHolder;
/*     */ import javax.xml.rpc.holders.ShortHolder;
/*     */ import javax.xml.rpc.holders.ShortWrapperHolder;
/*     */ import javax.xml.rpc.holders.StringHolder;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class HolderUtils
/*     */ {
/* 101 */   private static final Logger log = Logger.getLogger(HolderUtils.class);
/*     */ 
/*     */   public static boolean isHolderType(Class javaType)
/*     */   {
/* 106 */     return (javax.xml.rpc.holders.Holder.class.isAssignableFrom(javaType)) || (javax.xml.ws.Holder.class.isAssignableFrom(javaType));
/*     */   }
/*     */ 
/*     */   public static boolean isHolderType(Type javaType)
/*     */   {
/* 112 */     return isHolderType(JavaUtils.erasure(javaType));
/*     */   }
/*     */ 
/*     */   public static Class getJAXRPCHolderType(Class valueType)
/*     */   {
/* 123 */     if (valueType == null) {
/* 124 */       throw new IllegalArgumentException("Illegal null parameter");
/*     */     }
/* 126 */     if (javax.xml.rpc.holders.Holder.class.isAssignableFrom(valueType)) {
/* 127 */       throw new IllegalArgumentException("Is already a holder: " + valueType.getName());
/*     */     }
/* 129 */     if (valueType == BigDecimal.class)
/* 130 */       return BigDecimalHolder.class;
/* 131 */     if (valueType == BigInteger.class)
/* 132 */       return BigIntegerHolder.class;
/* 133 */     if (valueType == Boolean.TYPE)
/* 134 */       return BooleanHolder.class;
/* 135 */     if (valueType == Boolean.class)
/* 136 */       return BooleanWrapperHolder.class;
/* 137 */     if (valueType == [B.class)
/* 138 */       return ByteArrayHolder.class;
/* 139 */     if (valueType == Byte.TYPE)
/* 140 */       return ByteHolder.class;
/* 141 */     if (valueType == Byte.class)
/* 142 */       return ByteWrapperHolder.class;
/* 143 */     if (valueType == Calendar.class)
/* 144 */       return CalendarHolder.class;
/* 145 */     if (valueType == Double.TYPE)
/* 146 */       return DoubleHolder.class;
/* 147 */     if (valueType == Double.class)
/* 148 */       return DoubleWrapperHolder.class;
/* 149 */     if (valueType == Float.TYPE)
/* 150 */       return FloatHolder.class;
/* 151 */     if (valueType == Float.class)
/* 152 */       return FloatWrapperHolder.class;
/* 153 */     if (valueType == Integer.TYPE)
/* 154 */       return IntHolder.class;
/* 155 */     if (valueType == Integer.class)
/* 156 */       return IntegerWrapperHolder.class;
/* 157 */     if (valueType == Long.TYPE)
/* 158 */       return LongHolder.class;
/* 159 */     if (valueType == Long.class)
/* 160 */       return LongWrapperHolder.class;
/* 161 */     if (valueType == QName.class)
/* 162 */       return QNameHolder.class;
/* 163 */     if (valueType == Short.TYPE)
/* 164 */       return ShortHolder.class;
/* 165 */     if (valueType == Short.class)
/* 166 */       return ShortWrapperHolder.class;
/* 167 */     if (valueType == String.class)
/* 168 */       return StringHolder.class;
/* 169 */     if (valueType == Object.class) {
/* 170 */       return ObjectHolder.class;
/*     */     }
/* 172 */     log.warn("Cannot get holder type for: " + valueType);
/*     */ 
/* 174 */     return null;
/*     */   }
/*     */ 
/*     */   public static Class getValueType(Type holderType)
/*     */   {
/* 185 */     Class holderClass = JavaUtils.erasure(holderType);
/*     */ 
/* 187 */     boolean jaxrpcHolder = javax.xml.rpc.holders.Holder.class.isAssignableFrom(holderClass);
/* 188 */     boolean jaxwsHolder = javax.xml.ws.Holder.class.isAssignableFrom(holderClass);
/* 189 */     if ((!jaxrpcHolder) && (!jaxwsHolder)) {
/* 190 */       throw new IllegalArgumentException("Is not a holder: " + holderClass.getName());
/*     */     }
/* 192 */     if (jaxwsHolder) {
/* 193 */       return JavaUtils.erasure(getGenericValueType(holderType));
/*     */     }
/*     */     Field field;
/*     */     try
/*     */     {
/* 199 */       field = holderClass.getField("value");
/*     */     }
/*     */     catch (NoSuchFieldException e)
/*     */     {
/* 203 */       throw new IllegalArgumentException("Cannot find public value field: " + holderClass);
/*     */     }
/*     */ 
/* 206 */     return field.getType();
/*     */   }
/*     */ 
/*     */   public static Class getValueType(Class holderClass)
/*     */   {
/* 219 */     boolean jaxrpcHolder = javax.xml.rpc.holders.Holder.class.isAssignableFrom(holderClass);
/* 220 */     boolean jaxwsHolder = javax.xml.ws.Holder.class.isAssignableFrom(holderClass);
/* 221 */     if ((!jaxrpcHolder) && (!jaxwsHolder)) {
/* 222 */       throw new IllegalArgumentException("Is not a holder: " + holderClass.getName());
/*     */     }
/*     */ 
/* 225 */     if (jaxwsHolder) {
/* 226 */       return Object.class;
/*     */     }
/*     */     Field field;
/*     */     try
/*     */     {
/* 232 */       field = holderClass.getField("value");
/*     */     }
/*     */     catch (NoSuchFieldException e)
/*     */     {
/* 236 */       throw new IllegalArgumentException("Cannot find public value field: " + holderClass);
/*     */     }
/*     */ 
/* 239 */     return field.getType();
/*     */   }
/*     */ 
/*     */   public static Object getHolderValue(Object holder)
/*     */   {
/* 250 */     if (holder == null) {
/* 251 */       throw new IllegalArgumentException("Illegal null parameter");
/*     */     }
/* 253 */     if ((!javax.xml.rpc.holders.Holder.class.isInstance(holder)) && (!javax.xml.ws.Holder.class.isInstance(holder))) {
/* 254 */       throw new IllegalArgumentException("Is not a holder: " + holder);
/*     */     }
/*     */     try
/*     */     {
/* 258 */       Field valueField = holder.getClass().getField("value");
/* 259 */       Object obj = valueField.get(holder);
/* 260 */       return obj;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 264 */       throw rte;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 268 */     throw new IllegalArgumentException("Cannot access public value field: " + holder);
/*     */   }
/*     */ 
/*     */   public static void setHolderValue(Object holder, Object value)
/*     */   {
/* 282 */     if (holder == null) {
/* 283 */       throw new IllegalArgumentException("Holder instance was null");
/*     */     }
/* 285 */     if ((!javax.xml.rpc.holders.Holder.class.isInstance(holder)) && (!javax.xml.ws.Holder.class.isInstance(holder))) {
/* 286 */       throw new IllegalArgumentException("Is not a holder: " + holder);
/*     */     }
/* 288 */     Class valueType = getValueType(holder.getClass());
/*     */ 
/* 290 */     if ((value != null) && (!JavaUtils.isAssignableFrom(valueType, value.getClass()))) {
/* 291 */       throw new IllegalArgumentException("Holder [" + holder.getClass().getName() + "] value not assignable: " + value);
/*     */     }
/* 293 */     if (valueType.isArray()) {
/* 294 */       value = JavaUtils.syncArray(value, valueType);
/*     */     }
/*     */     try
/*     */     {
/* 298 */       Field valueField = holder.getClass().getField("value");
/* 299 */       if ((value != null) || (!valueType.isPrimitive()))
/* 300 */         valueField.set(holder, value);
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 304 */       throw rte;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 308 */       throw new IllegalArgumentException("Cannot access public value field: " + holder);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Type getGenericValueType(Type holder)
/*     */   {
/* 323 */     if ((holder instanceof ParameterizedType)) {
/* 324 */       return ((ParameterizedType)holder).getActualTypeArguments()[0];
/*     */     }
/* 326 */     return Object.class;
/*     */   }
/*     */ 
/*     */   public static Object createHolderInstance(Object value, Class<?> holderType)
/*     */   {
/* 339 */     if (!isHolderType(holderType)) {
/* 340 */       throw new IllegalArgumentException("Not a holder type:" + holderType.getName());
/*     */     }
/*     */     Object holder;
/*     */     try
/*     */     {
/* 346 */       holder = holderType.newInstance();
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 350 */       throw rte;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 354 */       throw new IllegalArgumentException("Cannot instanciate holder: " + holderType);
/*     */     }
/*     */ 
/* 357 */     setHolderValue(holder, value);
/*     */ 
/* 359 */     return holder;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.HolderUtils
 * JD-Core Version:    0.6.0
 */