/*     */ package org.jboss.ws.core.utils;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ 
/*     */ public final class HashCodeUtil
/*     */ {
/*     */   public static final int SEED = 23;
/*     */   private static final int fODD_PRIME_NUMBER = 37;
/*     */ 
/*     */   public static int hash(int aSeed, boolean aBoolean)
/*     */   {
/*  56 */     return firstTerm(aSeed) + (aBoolean ? 1 : 0);
/*     */   }
/*     */ 
/*     */   public static int hash(int aSeed, char aChar)
/*     */   {
/*  64 */     return firstTerm(aSeed) + aChar;
/*     */   }
/*     */ 
/*     */   public static int hash(int aSeed, int aInt)
/*     */   {
/*  77 */     return firstTerm(aSeed) + aInt;
/*     */   }
/*     */ 
/*     */   public static int hash(int aSeed, long aLong)
/*     */   {
/*  85 */     return firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
/*     */   }
/*     */ 
/*     */   public static int hash(int aSeed, float aFloat)
/*     */   {
/*  93 */     return hash(aSeed, Float.floatToIntBits(aFloat));
/*     */   }
/*     */ 
/*     */   public static int hash(int aSeed, double aDouble)
/*     */   {
/* 101 */     return hash(aSeed, Double.doubleToLongBits(aDouble));
/*     */   }
/*     */ 
/*     */   public static int hash(int aSeed, Object aObject)
/*     */   {
/* 112 */     int result = aSeed;
/* 113 */     if (aObject == null)
/*     */     {
/* 115 */       result = hash(result, 0);
/*     */     }
/* 117 */     else if (!isArray(aObject))
/*     */     {
/* 119 */       result = hash(result, aObject.hashCode());
/*     */     }
/*     */     else
/*     */     {
/* 123 */       int length = Array.getLength(aObject);
/* 124 */       for (int idx = 0; idx < length; idx++)
/*     */       {
/* 126 */         Object item = Array.get(aObject, idx);
/*     */ 
/* 128 */         result = hash(result, item);
/*     */       }
/*     */     }
/* 131 */     return result;
/*     */   }
/*     */ 
/*     */   private static int firstTerm(int aSeed)
/*     */   {
/* 139 */     return 37 * aSeed;
/*     */   }
/*     */ 
/*     */   private static boolean isArray(Object aObject)
/*     */   {
/* 144 */     return aObject.getClass().isArray();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.utils.HashCodeUtil
 * JD-Core Version:    0.6.0
 */