/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.awt.datatransfer.DataFlavor;
/*     */ import java.awt.datatransfer.UnsupportedFlavorException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import javax.activation.ActivationDataFlavor;
/*     */ import javax.activation.DataContentHandler;
/*     */ import javax.activation.DataSource;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ 
/*     */ public class XmlDataContentHandler
/*     */   implements DataContentHandler
/*     */ {
/*  46 */   private DataFlavor[] flavors = { new ActivationDataFlavor(StreamSource.class, "text/xml", "XML"), new ActivationDataFlavor(StreamSource.class, "application/xml", "XML") };
/*     */ 
/*     */   public Object getContent(DataSource ds)
/*     */     throws IOException
/*     */   {
/*  61 */     return new StreamSource(ds.getInputStream());
/*     */   }
/*     */ 
/*     */   public Object getTransferData(DataFlavor df, DataSource ds)
/*     */     throws UnsupportedFlavorException, IOException
/*     */   {
/*  74 */     return getContent(ds);
/*     */   }
/*     */ 
/*     */   public DataFlavor[] getTransferDataFlavors()
/*     */   {
/*  84 */     return this.flavors;
/*     */   }
/*     */ 
/*     */   public void writeTo(Object obj, String mimeType, OutputStream os)
/*     */     throws IOException
/*     */   {
/*  97 */     if ((!mimeType.startsWith("text/xml")) && (!mimeType.startsWith("application/xml"))) {
/*  98 */       throw new IOException("Expected text/xml or application/xml, got " + mimeType);
/*     */     }
/* 100 */     if (!(obj instanceof StreamSource)) {
/* 101 */       throw new IOException("XML Content handler only supports a StreamSource content object");
/*     */     }
/*     */ 
/* 104 */     InputStream stream = ((StreamSource)obj).getInputStream();
/* 105 */     if (stream != null)
/*     */     {
/* 107 */       IOUtils.copyStream(os, stream);
/*     */     }
/*     */     else
/*     */     {
/* 111 */       IOUtils.copyReader(os, ((StreamSource)obj).getReader());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.XmlDataContentHandler
 * JD-Core Version:    0.6.0
 */