/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ 
/*     */ public class SimpleBoyerMoore
/*     */ {
/*  40 */   private int[] badMatch = new int[256];
/*     */   private byte[] pattern;
/*     */   public static final int PATTERN_NOT_FOUND = -1;
/*     */ 
/*     */   public SimpleBoyerMoore(byte[] pattern)
/*     */   {
/*  55 */     this.pattern = pattern;
/*  56 */     precomputeBadMatchTable();
/*     */   }
/*     */ 
/*     */   private void precomputeBadMatchTable()
/*     */   {
/*  61 */     Arrays.fill(this.badMatch, this.pattern.length);
/*  62 */     for (int i = 0; i < this.pattern.length - 1; i++)
/*     */     {
/*  64 */       this.badMatch[(this.pattern[i] & 0xFF)] = (this.pattern.length - i - 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int patternSearch(byte[] text, int offset, int length)
/*     */   {
/*  80 */     if (this.pattern.length > length)
/*     */     {
/*  82 */       return -1;
/*     */     }
/*     */ 
/*  85 */     int i = 0; int j = 0; int k = 0;
/*  86 */     int end = offset + length;
/*     */ 
/*  88 */     for (i = offset + this.pattern.length - 1; i < end; i += this.badMatch[(text[i] & 0xFF)])
/*     */     {
/*  90 */       j = this.pattern.length - 1; for (k = i; (j >= 0) && (text[k] == this.pattern[j]); j--)
/*     */       {
/*  92 */         k--;
/*     */       }
/*  94 */       if (j == -1)
/*     */       {
/*  96 */         return k + 1;
/*     */       }
/*     */     }
/*     */ 
/* 100 */     return -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.SimpleBoyerMoore
 * JD-Core Version:    0.6.0
 */