/*    */ package org.jboss.ws.core.soap.attachment;
/*    */ 
/*    */ import javax.mail.MessagingException;
/*    */ import javax.mail.internet.MimeBodyPart;
/*    */ import javax.mail.internet.MimeMultipart;
/*    */ import javax.mail.internet.ParameterList;
/*    */ import javax.xml.soap.SOAPEnvelope;
/*    */ import javax.xml.soap.SOAPException;
/*    */ import javax.xml.soap.SOAPPart;
/*    */ import org.jboss.ws.core.soap.SOAPElementImpl;
/*    */ import org.jboss.ws.core.soap.SOAPElementWriter;
/*    */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*    */ 
/*    */ public class MultipartRelatedXOPEncoder extends MultipartRelatedEncoder
/*    */ {
/*    */   public MultipartRelatedXOPEncoder(SOAPMessageImpl soapMessage)
/*    */     throws SOAPException
/*    */   {
/* 55 */     super(soapMessage);
/*    */   }
/*    */ 
/*    */   public void encodeMultipartRelatedMessage() throws SOAPException, MessagingException
/*    */   {
/* 60 */     ParameterList p = new ParameterList();
/* 61 */     p.set("type", "application/xop+xml");
/* 62 */     p.set("start", "<rootpart@ws.jboss.org>");
/* 63 */     p.set("start-info", "text/xml");
/*    */ 
/* 65 */     MimeMultipart multipart = new MimeMultipart("related" + p);
/* 66 */     MimeBodyPart rootPart = new MimeBodyPart();
/*    */ 
/* 74 */     SOAPEnvelope soapEnv = this.soapMessage.getSOAPPart().getEnvelope();
/* 75 */     String envStr = SOAPElementWriter.writeElement((SOAPElementImpl)soapEnv, false);
/* 76 */     rootPart.setText(envStr, "UTF-8");
/*    */ 
/* 78 */     rootPart.setContentID("<rootpart@ws.jboss.org>");
/* 79 */     rootPart.setHeader("Content-Type", "application/xop+xml; type=\"text/xml\"");
/* 80 */     rootPart.setHeader("Content-Transfer-Encoding", "8bit");
/*    */ 
/* 82 */     multipart.addBodyPart(rootPart);
/*    */ 
/* 84 */     addAttachmentParts(multipart);
/*    */ 
/* 86 */     this.multipart = multipart;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.MultipartRelatedXOPEncoder
 * JD-Core Version:    0.6.0
 */