/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PushbackInputStream;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.LinkedList;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.mail.Header;
/*     */ import javax.mail.MessagingException;
/*     */ import javax.mail.internet.ContentType;
/*     */ import javax.mail.internet.InternetHeaders;
/*     */ import javax.mail.internet.ParseException;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import org.jboss.ws.WSException;
/*     */ 
/*     */ public class MultipartRelatedDecoder
/*     */ {
/*     */   private ContentType contentType;
/*     */   private String rootType;
/*     */   private AttachmentPartImpl rootPart;
/*  59 */   private LinkedList<AttachmentPart> relatedParts = new LinkedList();
/*     */ 
/*     */   public MultipartRelatedDecoder(ContentType contentType)
/*     */     throws IOException, MessagingException
/*     */   {
/*  70 */     this.contentType = contentType;
/*  71 */     if (!"multipart/related".equalsIgnoreCase(contentType.getBaseType())) {
/*  72 */       throw new IllegalArgumentException("Multipart related decoder called with a non-multipart/related type");
/*     */     }
/*  74 */     this.rootType = contentType.getParameter("type");
/*  75 */     if (this.rootType == null)
/*  76 */       throw new IllegalArgumentException("multipart/related type is invalid, it is missing the root type parameter");
/*     */   }
/*     */ 
/*     */   private boolean isValidRootType(String type)
/*     */     throws ParseException
/*     */   {
/*  82 */     ContentType contentType = new ContentType(type);
/*  83 */     type = contentType.getBaseType();
/*     */ 
/*  85 */     return this.rootType.equals(type);
/*     */   }
/*     */ 
/*     */   public void decodeMultipartRelatedMessage(InputStream stream) throws IOException, MessagingException
/*     */   {
/*  90 */     String boundaryParameter = this.contentType.getParameter("boundary");
/*  91 */     String start = this.contentType.getParameter("start");
/*     */ 
/*  95 */     if (boundaryParameter == null)
/*  96 */       throw new IllegalArgumentException("multipart/related content type did not contain a boundary");
/*     */     byte[] boundary;
/*     */     byte[] crlf;
/*     */     try
/*     */     {
/*     */       byte[] boundary;
/* 101 */       if (start == null)
/* 102 */         boundary = ("--" + boundaryParameter).getBytes("US-ASCII");
/*     */       else {
/* 104 */         boundary = ("\r\n--" + boundaryParameter).getBytes("US-ASCII");
/*     */       }
/* 106 */       crlf = "\r\n".getBytes("US-ASCII");
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/* 110 */       throw new WSException("US-ASCII not supported, this should never happen");
/*     */     }
/*     */ 
/* 114 */     PushbackInputStream pushBackStream = new PushbackInputStream(stream, 2);
/* 115 */     pushBackStream.unread(crlf);
/*     */ 
/* 117 */     BoundaryDelimitedInputStream delimitedStream = new BoundaryDelimitedInputStream(pushBackStream, boundary);
/*     */ 
/* 120 */     byte[] buffer = new byte[256];
/* 121 */     while (delimitedStream.read(buffer) != -1);
/* 125 */     while (!delimitedStream.isOuterStreamClosed())
/*     */     {
/* 129 */       if (!advanceToHeaders(delimitedStream)) {
/*     */         continue;
/*     */       }
/* 132 */       InternetHeaders headers = new InternetHeaders(delimitedStream);
/* 133 */       String[] typeHeader = headers.getHeader("Content-Type");
/*     */ 
/* 135 */       if (typeHeader == null) {
/* 136 */         throw new IllegalArgumentException("multipart/related stream invalid, component Content-type missing.");
/*     */       }
/* 138 */       SwapableMemoryDataSource source = new SwapableMemoryDataSource(delimitedStream, typeHeader[0]);
/* 139 */       AttachmentPartImpl part = new AttachmentPartImpl(new DataHandler(source));
/*     */ 
/* 141 */       Enumeration enumeration = headers.getAllHeaders();
/*     */ 
/* 143 */       while (enumeration.hasMoreElements())
/*     */       {
/* 145 */         Header header = (Header)enumeration.nextElement();
/* 146 */         part.addMimeHeader(header.getName(), header.getValue());
/*     */       }
/*     */ 
/* 151 */       if ((this.rootPart == null) && ((start == null) || (start.equals(part.getContentId()))))
/*     */       {
/* 153 */         if (!isValidRootType(part.getContentType())) {
/* 154 */           throw new IllegalArgumentException("multipart/related type specified a root type other than the one that was found.");
/*     */         }
/* 156 */         this.rootPart = part;
/*     */       }
/*     */       else
/*     */       {
/* 160 */         this.relatedParts.add(part);
/*     */       }
/*     */     }
/* 163 */     if (this.rootPart == null)
/* 164 */       throw new IllegalArgumentException("multipart/related stream invalid, no root part was found");
/*     */   }
/*     */ 
/*     */   private boolean advanceToHeaders(InputStream stream) throws IOException
/*     */   {
/* 169 */     boolean dash = false; boolean cr = false;
/*     */     while (true)
/*     */     {
/* 172 */       int b = stream.read();
/*     */ 
/* 174 */       switch (b)
/*     */       {
/*     */       case -1:
/* 177 */         return false;
/*     */       case 13:
/* 179 */         cr = true;
/* 180 */         dash = false;
/* 181 */         break;
/*     */       case 45:
/* 183 */         if (dash == true)
/*     */         {
/* 186 */           stream.close();
/* 187 */           return false;
/*     */         }
/* 189 */         dash = true;
/* 190 */         cr = false;
/* 191 */         break;
/*     */       case 10:
/* 193 */         if (cr == true)
/* 194 */           return true;
/* 195 */         dash = false;
/* 196 */         break;
/*     */       default:
/* 198 */         dash = false;
/* 199 */         cr = false;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttachmentPart getRootPart()
/*     */   {
/* 211 */     return this.rootPart;
/*     */   }
/*     */ 
/*     */   public Collection<AttachmentPart> getRelatedParts()
/*     */   {
/* 220 */     return this.relatedParts;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.MultipartRelatedDecoder
 * JD-Core Version:    0.6.0
 */