/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import java.awt.Component;
/*     */ import java.awt.Graphics2D;
/*     */ import java.awt.Image;
/*     */ import java.awt.MediaTracker;
/*     */ import java.awt.datatransfer.DataFlavor;
/*     */ import java.awt.datatransfer.UnsupportedFlavorException;
/*     */ import java.awt.image.BufferedImage;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.activation.ActivationDataFlavor;
/*     */ import javax.activation.DataContentHandler;
/*     */ import javax.activation.DataSource;
/*     */ import javax.imageio.ImageIO;
/*     */ import javax.imageio.ImageWriter;
/*     */ import javax.imageio.stream.ImageOutputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ImageDataContentHandler extends Component
/*     */   implements DataContentHandler
/*     */ {
/*  64 */   private static Logger log = Logger.getLogger(ImageDataContentHandler.class);
/*     */   private static DataFlavor[] flavors;
/*     */ 
/*     */   private static void buildFlavors()
/*     */   {
/*  78 */     String[] mimeTypes = ImageIO.getReaderMIMETypes();
/*  79 */     if (mimeTypes == null)
/*  80 */       return;
/*  81 */     ArrayList flavs = new ArrayList();
/*     */ 
/*  84 */     for (int i = 0; i < mimeTypes.length; i++)
/*     */     {
/*     */       try
/*     */       {
/*  88 */         DataFlavor flavor = new ActivationDataFlavor(Image.class, mimeTypes[i], "Image");
/*  89 */         flavs.add(flavor);
/*     */       }
/*     */       catch (IllegalArgumentException iae)
/*     */       {
/*  94 */         log.warn("Unsupported MIME Type '" + mimeTypes[i] + "'");
/*     */       }
/*     */     }
/*  97 */     int size = flavs.size();
/*  98 */     flavors = new DataFlavor[size];
/*  99 */     for (int i = 0; i < size; i++)
/*     */     {
/* 101 */       flavors[i] = ((ActivationDataFlavor)flavs.get(i));
/*     */     }
/*     */   }
/*     */ 
/*     */   private static ImageWriter getImageWriter(String mimeType) {
/* 106 */     Iterator i = ImageIO.getImageWritersByMIMEType(mimeType);
/* 107 */     if (!i.hasNext()) {
/* 108 */       return null;
/*     */     }
/* 110 */     return (ImageWriter)i.next();
/*     */   }
/*     */ 
/*     */   private BufferedImage getBufferedImage(Image image) throws IOException
/*     */   {
/* 115 */     if ((image instanceof BufferedImage)) {
/* 116 */       return (BufferedImage)image;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 122 */       MediaTracker tracker = new MediaTracker(this);
/* 123 */       tracker.addImage(image, 0);
/* 124 */       tracker.waitForAll();
/* 125 */       BufferedImage buffered = new BufferedImage(image.getHeight(null), image.getWidth(null), 1);
/* 126 */       Graphics2D gfx = buffered.createGraphics();
/* 127 */       gfx.drawImage(image, 0, 0, null);
/* 128 */       return buffered;
/*     */     }
/*     */     catch (InterruptedException e) {
/*     */     }
/* 132 */     throw new IOException("Could not convert image " + e.getMessage());
/*     */   }
/*     */ 
/*     */   public Object getContent(DataSource ds)
/*     */     throws IOException
/*     */   {
/* 145 */     return ImageIO.read(ds.getInputStream());
/*     */   }
/*     */ 
/*     */   public Object getTransferData(DataFlavor df, DataSource ds)
/*     */     throws UnsupportedFlavorException, IOException
/*     */   {
/* 159 */     return getContent(ds);
/*     */   }
/*     */ 
/*     */   public DataFlavor[] getTransferDataFlavors()
/*     */   {
/* 169 */     return flavors;
/*     */   }
/*     */ 
/*     */   public void writeTo(Object obj, String mimeType, OutputStream os)
/*     */     throws IOException
/*     */   {
/* 182 */     if (obj == null) {
/* 183 */       throw new IOException("Cannot write null source object");
/*     */     }
/* 185 */     if (!(obj instanceof Image)) {
/* 186 */       throw new IOException("Requires the source object to be a java.awt.Image but is: " + obj.getClass().getName());
/*     */     }
/* 188 */     ImageWriter writer = getImageWriter(mimeType);
/* 189 */     if (writer == null) {
/* 190 */       throw new IOException("Image encoding not available for mime type " + mimeType + " on this vm");
/*     */     }
/* 192 */     BufferedImage buffered = getBufferedImage((Image)obj);
/* 193 */     ImageOutputStream stream = ImageIO.createImageOutputStream(os);
/*     */ 
/* 195 */     writer.setOutput(stream);
/* 196 */     writer.write(buffered);
/*     */ 
/* 200 */     stream.flush();
/* 201 */     stream.close();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  70 */     buildFlavors();
/*     */ 
/*  73 */     ImageIO.setUseCache(false);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.ImageDataContentHandler
 * JD-Core Version:    0.6.0
 */