/*    */ package org.jboss.ws.core.soap.attachment;
/*    */ 
/*    */ import java.io.UnsupportedEncodingException;
/*    */ import java.net.URLEncoder;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.utils.UUIDGenerator;
/*    */ 
/*    */ public class CIDGenerator
/*    */ {
/* 41 */   private static Logger log = Logger.getLogger(CIDGenerator.class);
/*    */ 
/* 43 */   private int count = 0;
/*    */ 
/*    */   public String generateFromCount()
/*    */   {
/* 47 */     StringBuilder cid = new StringBuilder();
/* 48 */     long time = System.currentTimeMillis();
/*    */ 
/* 50 */     cid.append(this.count++).append("-").append(time).append("-").append(cid.hashCode()).append("@").append("ws.jboss.org");
/*    */ 
/* 53 */     if (log.isDebugEnabled()) log.debug("generateFromCount: " + cid);
/* 54 */     return cid.toString();
/*    */   }
/*    */ 
/*    */   public String generateFromName(String name)
/*    */   {
/*    */     try
/*    */     {
/* 64 */       name = URLEncoder.encode(name, "UTF-8");
/*    */     }
/*    */     catch (UnsupportedEncodingException ex)
/*    */     {
/* 68 */       log.error("Cannot encode name for cid: " + ex);
/*    */     }
/*    */ 
/* 71 */     String cid = name + "-" + UUIDGenerator.generateRandomUUIDString() + "@" + "ws.jboss.org";
/* 72 */     if (log.isDebugEnabled()) log.debug("generateFromName: " + cid);
/* 73 */     return cid;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.CIDGenerator
 * JD-Core Version:    0.6.0
 */