/*    */ package org.jboss.ws.core.soap.attachment;
/*    */ 
/*    */ import java.awt.datatransfer.DataFlavor;
/*    */ import java.awt.datatransfer.UnsupportedFlavorException;
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.OutputStream;
/*    */ import javax.activation.ActivationDataFlavor;
/*    */ import javax.activation.DataContentHandler;
/*    */ import javax.activation.DataHandler;
/*    */ import javax.activation.DataSource;
/*    */ import org.jboss.ws.core.utils.MimeUtils;
/*    */ import org.jboss.ws.core.utils.MimeUtils.ByteArrayConverter;
/*    */ import org.jboss.wsf.common.IOUtils;
/*    */ 
/*    */ public class ByteArrayContentHandler
/*    */   implements DataContentHandler
/*    */ {
/* 45 */   private DataFlavor[] flavors = { new ActivationDataFlavor(ByteArrayInputStream.class, "application/octet-stream", "OCTETS") };
/*    */ 
/*    */   public Object getContent(DataSource dataSource)
/*    */     throws IOException
/*    */   {
/* 51 */     return dataSource.getInputStream();
/*    */   }
/*    */ 
/*    */   public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
/* 55 */     return getContent(dataSource);
/*    */   }
/*    */ 
/*    */   public DataFlavor[] getTransferDataFlavors() {
/* 59 */     return this.flavors;
/*    */   }
/*    */ 
/*    */   public void writeTo(Object object, String string, OutputStream outputStream) throws IOException
/*    */   {
/* 64 */     if ((object instanceof byte[]))
/*    */     {
/* 66 */       outputStream.write((byte[])(byte[])object);
/*    */     }
/* 68 */     else if ((object instanceof DataHandler))
/*    */     {
/* 70 */       IOUtils.copyStream(outputStream, ((DataHandler)object).getInputStream());
/*    */     }
/*    */     else
/*    */     {
/* 74 */       MimeUtils.ByteArrayConverter converter = MimeUtils.getConverterForJavaType(object.getClass());
/* 75 */       converter.writeTo(object, outputStream);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.ByteArrayContentHandler
 * JD-Core Version:    0.6.0
 */