/*     */ package org.jboss.ws.core.soap.attachment;
/*     */ 
/*     */ import B;
/*     */ import java.io.FilterInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ 
/*     */ public class BoundaryDelimitedInputStream extends FilterInputStream
/*     */ {
/*     */   private static final int BOUNDARY_NOT_FOUND = -1;
/*     */   private byte[] boundary;
/*     */   private SimpleBoyerMoore boyerMoore;
/*     */   private byte[] leftOvers;
/*     */   private int leftOverPosition;
/*     */   private InputStream source;
/*     */   private boolean simulateEof;
/*     */   private boolean realEof;
/*     */   private boolean bufferingCompleted;
/*     */ 
/*     */   public BoundaryDelimitedInputStream(InputStream in, byte[] boundary)
/*     */   {
/*  70 */     super(in);
/*  71 */     this.source = in;
/*  72 */     this.boundary = ((byte[])(byte[])boundary.clone());
/*  73 */     this.boyerMoore = new SimpleBoyerMoore(this.boundary);
/*     */   }
/*     */ 
/*     */   private void createLeftOvers(byte[] buffer, int start, int end)
/*     */   {
/*  81 */     int length = end - start;
/*     */ 
/*  83 */     if (length <= 0) {
/*  84 */       return;
/*     */     }
/*     */ 
/*  89 */     if ((this.bufferingCompleted) && (this.leftOvers != null))
/*     */     {
/*  91 */       this.leftOverPosition -= length;
/*  92 */       return;
/*     */     }
/*     */ 
/*  95 */     int leftOverLength = this.leftOvers == null ? 0 : this.leftOvers.length - this.leftOverPosition;
/*     */ 
/*  97 */     byte[] newLeftOvers = new byte[length + leftOverLength];
/*     */ 
/*  99 */     System.arraycopy(buffer, start, newLeftOvers, 0, length);
/*     */ 
/* 101 */     if (this.leftOvers != null) {
/* 102 */       System.arraycopy(this.leftOvers, this.leftOverPosition, newLeftOvers, length, leftOverLength);
/*     */     }
/* 104 */     this.leftOvers = newLeftOvers;
/* 105 */     this.leftOverPosition = 0;
/*     */   }
/*     */ 
/*     */   private int consumeLeftOvers(byte[] buffer, int offset, int length)
/*     */   {
/* 113 */     if (this.leftOvers == null) return 0;
/*     */ 
/* 115 */     int i = 0;
/* 116 */     while ((i < length) && (this.leftOverPosition < this.leftOvers.length))
/*     */     {
/* 118 */       buffer[(offset + i++)] = this.leftOvers[(this.leftOverPosition++)];
/*     */     }
/*     */ 
/* 121 */     if (this.leftOverPosition >= this.leftOvers.length)
/*     */     {
/* 123 */       this.leftOvers = null;
/* 124 */       this.leftOverPosition = 0;
/*     */     }
/*     */ 
/* 127 */     return i;
/*     */   }
/*     */ 
/*     */   private int fullRead(byte[] buffer, int offset, int length)
/*     */     throws IOException
/*     */   {
/* 136 */     int count = 0;
/* 137 */     int read = 0;
/*     */     do
/*     */     {
/* 141 */       read = this.source.read(buffer, offset + count, length - count);
/* 142 */       if (read > 0)
/* 143 */         count += read;
/*     */     }
/* 145 */     while ((read > 0) && (count < length));
/*     */ 
/* 147 */     if (read < 0) {
/* 148 */       this.realEof = true;
/*     */     }
/* 150 */     return count;
/*     */   }
/*     */ 
/*     */   private int findBoundary(byte[] buffer, int length)
/*     */   {
/* 155 */     return this.boyerMoore.patternSearch(buffer, 0, length);
/*     */   }
/*     */ 
/*     */   private int read(byte[] b, int off, int len, boolean skip) throws IOException
/*     */   {
/* 160 */     if (len == 0) return 0;
/*     */ 
/* 162 */     if (this.simulateEof)
/*     */     {
/* 164 */       this.simulateEof = false;
/* 165 */       return -1;
/*     */     }
/*     */ 
/* 168 */     if (this.realEof)
/*     */     {
/* 170 */       if (this.leftOvers == null)
/* 171 */         return -1;
/* 172 */       if (!this.bufferingCompleted)
/*     */       {
/* 174 */         this.bufferingCompleted = true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 182 */     int bufferLength = Math.max(this.boundary.length * 2, len + this.boundary.length);
/*     */ 
/* 184 */     byte[] buffer = new byte[bufferLength];
/*     */ 
/* 186 */     int position = consumeLeftOvers(buffer, 0, bufferLength);
/* 187 */     if (position < bufferLength) {
/* 188 */       position += fullRead(buffer, position, bufferLength - position);
/*     */     }
/*     */ 
/* 191 */     if ((this.realEof) && (position == 0)) {
/* 192 */       return -1;
/*     */     }
/*     */ 
/* 196 */     int boundaryPosition = findBoundary(buffer, position);
/*     */     int returnLength;
/* 197 */     if ((boundaryPosition == -1) || (boundaryPosition >= len))
/*     */     {
/* 199 */       int returnLength = Math.min(len, position);
/* 200 */       createLeftOvers(buffer, returnLength, position);
/*     */     }
/*     */     else
/*     */     {
/* 204 */       returnLength = boundaryPosition;
/* 205 */       createLeftOvers(buffer, returnLength + this.boundary.length, position);
/*     */ 
/* 208 */       if (returnLength == 0) {
/* 209 */         return -1;
/*     */       }
/*     */ 
/* 213 */       this.simulateEof = true;
/*     */     }
/*     */ 
/* 216 */     if (!skip) {
/* 217 */       System.arraycopy(buffer, 0, b, off, returnLength);
/*     */     }
/* 219 */     return returnLength;
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 229 */     return 0;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 238 */     this.source.close();
/* 239 */     this.leftOvers = null;
/* 240 */     this.leftOverPosition = 0;
/* 241 */     this.realEof = true;
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 249 */     return false;
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException
/*     */   {
/* 261 */     byte[] b = new byte[1];
/* 262 */     if (read(b) == -1)
/* 263 */       return -1;
/* 264 */     return b[0] & 0xFF;
/*     */   }
/*     */ 
/*     */   public int read(byte[] b)
/*     */     throws IOException
/*     */   {
/* 276 */     return read(b, 0, b.length);
/*     */   }
/*     */ 
/*     */   public long skip(long n)
/*     */     throws IOException
/*     */   {
/* 288 */     return read(null, 0, (int)n, true);
/*     */   }
/*     */ 
/*     */   public int read(byte[] b, int off, int len)
/*     */     throws IOException
/*     */   {
/* 302 */     return read(b, off, len, false);
/*     */   }
/*     */ 
/*     */   public boolean isOuterStreamClosed()
/*     */   {
/* 312 */     return (this.realEof) && (this.leftOvers == null);
/*     */   }
/*     */ 
/*     */   public void printLeftOvers()
/*     */   {
/* 318 */     if (this.leftOvers != null) System.out.println("LEFT = " + new String(this.leftOvers, this.leftOverPosition, this.leftOvers.length - this.leftOverPosition));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.attachment.BoundaryDelimitedInputStream
 * JD-Core Version:    0.6.0
 */