/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Reader;
/*     */ import java.io.StringWriter;
/*     */ import java.io.Writer;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMResult;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.sax.SAXSource;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*     */ import org.jboss.ws.core.jaxrpc.binding.BufferedStreamSource;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class XMLFragment
/*     */ {
/*  66 */   private static Logger log = Logger.getLogger(XMLFragment.class);
/*     */   private Source source;
/*     */   private static final String XML_PROC = "<?xml";
/*     */   private RuntimeException streamSourceAccessMarker;
/*     */ 
/*     */   public XMLFragment(Source source)
/*     */   {
/*  78 */     this.source = source;
/*     */   }
/*     */ 
/*     */   public XMLFragment(String xmlString)
/*     */   {
/*  83 */     this.source = new BufferedStreamSource(xmlString.getBytes());
/*     */   }
/*     */ 
/*     */   public XMLFragment(Result result)
/*     */   {
/*  88 */     if ((result instanceof DOMResult))
/*     */     {
/*  90 */       DOMResult domResult = (DOMResult)result;
/*  91 */       this.source = new DOMSource(domResult.getNode());
/*     */     }
/*  93 */     else if ((result instanceof BufferedStreamResult))
/*     */     {
/*  95 */       BufferedStreamResult br = (BufferedStreamResult)result;
/*  96 */       ByteArrayOutputStream baos = (ByteArrayOutputStream)br.getOutputStream();
/*  97 */       this.source = new BufferedStreamSource(baos.toByteArray());
/*     */     }
/*     */     else
/*     */     {
/* 101 */       throw new IllegalArgumentException("Unsupported result type: " + result);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Source getSource()
/*     */   {
/* 107 */     this.source = beginSourceAccess(this.source);
/* 108 */     endSourceAccess();
/* 109 */     return this.source;
/*     */   }
/*     */ 
/*     */   public String toXMLString()
/*     */   {
/*     */     try
/*     */     {
/* 118 */       StringWriter strWriter = new StringWriter(1024);
/* 119 */       writeSourceInternal(strWriter);
/* 120 */       return strWriter.toString();
/*     */     }
/*     */     catch (IOException ex) {
/*     */     }
/* 124 */     throw new WSException(ex);
/*     */   }
/*     */ 
/*     */   public Element toElement()
/*     */   {
/* 132 */     Element retElement = null;
/*     */     try
/*     */     {
/* 135 */       this.source = beginSourceAccess(this.source);
/* 136 */       retElement = DOMUtils.sourceToElement(this.source);
/* 137 */       endSourceAccess();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 141 */       handleSourceAccessException(ex);
/*     */     }
/* 143 */     return retElement;
/*     */   }
/*     */ 
/*     */   public void writeTo(Writer writer) throws IOException
/*     */   {
/* 148 */     writeSourceInternal(writer);
/*     */   }
/*     */ 
/*     */   public void writeTo(OutputStream out) throws IOException
/*     */   {
/* 153 */     PrintWriter printWriter = new PrintWriter(out);
/* 154 */     writeSourceInternal(printWriter);
/* 155 */     printWriter.flush();
/* 156 */     printWriter.close();
/*     */   }
/*     */ 
/*     */   private void writeSourceInternal(Writer writer)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 166 */       this.source = beginSourceAccess(this.source);
/*     */ 
/* 168 */       if ((this.source instanceof DOMSource))
/*     */       {
/* 170 */         DOMSource domSource = (DOMSource)this.source;
/* 171 */         new DOMWriter(writer).print(domSource.getNode());
/*     */       }
/* 173 */       else if (((this.source instanceof StreamSource)) || ((this.source instanceof SAXSource)))
/*     */       {
/* 175 */         StreamSource streamSource = (StreamSource)this.source;
/*     */ 
/* 177 */         Reader reader = streamSource.getReader();
/*     */ 
/* 179 */         if (reader == null) {
/* 180 */           reader = new InputStreamReader(streamSource.getInputStream());
/*     */         }
/*     */ 
/* 183 */         char[] cbuf = new char[1024];
/* 184 */         int len = reader.read(cbuf);
/* 185 */         int off = 0;
/*     */ 
/* 187 */         if (len == -1) {
/* 188 */           throw new IOException("StreamSource already exhausted");
/*     */         }
/*     */ 
/* 191 */         String xmlProc = new String(cbuf, 0, "<?xml".length());
/* 192 */         if ("<?xml".equals(xmlProc))
/*     */         {
/* 194 */           off = "<?xml".length();
/* 195 */           while ((cbuf[off] != '>') && (off < len)) {
/* 196 */             off++;
/*     */           }
/* 198 */           if (cbuf[off] != '>') {
/* 199 */             throw new IllegalStateException("Cannot find end of XML processing instruction");
/*     */           }
/* 201 */           off++;
/* 202 */           len -= off;
/*     */         }
/*     */ 
/* 205 */         while (len > 0)
/*     */         {
/* 207 */           writer.write(cbuf, off, len);
/* 208 */           len = reader.read(cbuf);
/* 209 */           off = 0;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 214 */         throw new IllegalArgumentException("Unsupported source type: " + this.source);
/*     */       }
/*     */ 
/* 217 */       endSourceAccess();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 221 */       handleSourceAccessException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Source beginSourceAccess(Source source)
/*     */   {
/* 228 */     if (((source instanceof BufferedStreamSource)) || ((source instanceof DOMSource))) {
/* 229 */       return source;
/*     */     }
/*     */ 
/* 232 */     if ((source instanceof StreamSource))
/*     */     {
/* 234 */       source = new BufferedStreamSource((StreamSource)source);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 240 */         Element element = DOMUtils.sourceToElement(source);
/* 241 */         source = new DOMSource(element);
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 245 */         WSException.rethrow(ex);
/*     */       }
/*     */     }
/*     */ 
/* 249 */     return source;
/*     */   }
/*     */ 
/*     */   private void endSourceAccess()
/*     */   {
/* 255 */     if ((this.source instanceof StreamSource))
/*     */     {
/* 257 */       this.streamSourceAccessMarker = new RuntimeException();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleSourceAccessException(IOException ex)
/*     */   {
/* 263 */     if (((this.source instanceof StreamSource)) && (this.streamSourceAccessMarker != null))
/*     */     {
/* 265 */       log.error("StreamSource was previously accessed from", this.streamSourceAccessMarker);
/*     */     }
/* 267 */     WSException.rethrow(ex);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 272 */     return "[source=" + this.source + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.XMLFragment
 * JD-Core Version:    0.6.0
 */