/*    */ package org.jboss.ws.core.soap;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.rpc.ParameterMode;
/*    */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*    */ 
/*    */ public class UnboundHeader
/*    */ {
/*    */   private QName xmlName;
/*    */   private QName xmlType;
/*    */   private Class javaType;
/*    */   private ParameterMode mode;
/*    */   private Object headerValue;
/*    */ 
/*    */   public UnboundHeader(QName xmlName, QName xmlType, Class javaType, ParameterMode mode)
/*    */   {
/* 48 */     this.xmlName = xmlName;
/* 49 */     this.xmlType = xmlType;
/* 50 */     this.javaType = javaType;
/* 51 */     this.mode = mode;
/*    */   }
/*    */ 
/*    */   public QName getXmlName()
/*    */   {
/* 56 */     return this.xmlName;
/*    */   }
/*    */ 
/*    */   public QName getXmlType()
/*    */   {
/* 61 */     return this.xmlType;
/*    */   }
/*    */ 
/*    */   public Class getJavaType()
/*    */   {
/* 66 */     return this.javaType;
/*    */   }
/*    */ 
/*    */   public ParameterMode getMode()
/*    */   {
/* 71 */     return this.mode;
/*    */   }
/*    */ 
/*    */   public Object getHeaderValue()
/*    */   {
/* 76 */     return this.headerValue;
/*    */   }
/*    */ 
/*    */   public void setHeaderValue(Object headerValue)
/*    */   {
/* 81 */     this.headerValue = headerValue;
/*    */   }
/*    */ 
/*    */   public ParameterMetaData toParameterMetaData(OperationMetaData opMetaData)
/*    */   {
/* 86 */     ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, this.xmlName, this.xmlType, this.javaType.getName());
/* 87 */     paramMetaData.setInHeader(true);
/* 88 */     return paramMetaData;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 93 */     StringBuilder buffer = new StringBuilder("\nUnboundHeader:");
/* 94 */     buffer.append("\n xmlName=" + getXmlName());
/* 95 */     buffer.append("\n xmlType=" + getXmlType());
/* 96 */     buffer.append("\n javaType=" + getJavaType().getName());
/* 97 */     buffer.append("\n mode=" + getMode());
/* 98 */     return buffer.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.UnboundHeader
 * JD-Core Version:    0.6.0
 */