/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class TextImpl extends NodeImpl
/*     */   implements javax.xml.soap.Text
/*     */ {
/*     */   public TextImpl(Node node)
/*     */   {
/*  41 */     super(node);
/*     */   }
/*     */ 
/*     */   public boolean isComment()
/*     */   {
/*  48 */     return this.domNode.getNodeType() == 8;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/*  53 */     return getNodeValue();
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/*  58 */     setNodeValue(value);
/*     */   }
/*     */ 
/*     */   public void writeNode(Writer out) throws IOException
/*     */   {
/*  63 */     String nodeValue = getNodeValue();
/*  64 */     if ((isComment()) && (!nodeValue.startsWith("<!--")))
/*  65 */       out.write("<!--" + nodeValue + "-->");
/*     */     else
/*  67 */       out.write(nodeValue);
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Text splitText(int offset)
/*     */     throws DOMException
/*     */   {
/*  87 */     if ((offset < 0) || (offset > getNodeValue().length())) {
/*  88 */       throw new IllegalArgumentException("Invalid offset [" + offset + "] for '" + getNodeValue() + "'");
/*     */     }
/*  90 */     String before = getNodeValue().substring(0, offset + 1);
/*  91 */     setNodeValue(before);
/*     */ 
/*  93 */     String after = getNodeValue().substring(offset + 1);
/*  94 */     TextImpl txtNode = new TextImpl(this.domNode.getOwnerDocument().createTextNode(after));
/*     */ 
/*  96 */     Node parent = getParentNode();
/*  97 */     if (parent != null)
/*     */     {
/*  99 */       Node sibling = getNextSibling();
/* 100 */       if (sibling == null)
/* 101 */         parent.appendChild(txtNode);
/*     */       else {
/* 103 */         parent.insertBefore(txtNode, sibling);
/*     */       }
/*     */     }
/* 106 */     return txtNode;
/*     */   }
/*     */ 
/*     */   public int getLength()
/*     */   {
/* 118 */     return getNodeValue().length();
/*     */   }
/*     */ 
/*     */   public void deleteData(int offset, int count)
/*     */     throws DOMException
/*     */   {
/* 138 */     String value = getNodeValue().substring(0, offset + 1);
/* 139 */     setNodeValue(value);
/*     */   }
/*     */ 
/*     */   public String getData()
/*     */     throws DOMException
/*     */   {
/* 158 */     return getNodeValue();
/*     */   }
/*     */ 
/*     */   public String substringData(int offset, int count)
/*     */     throws DOMException
/*     */   {
/* 178 */     return getNodeValue().substring(offset, offset + count);
/*     */   }
/*     */ 
/*     */   public void replaceData(int offset, int count, String arg)
/*     */     throws DOMException
/*     */   {
/* 202 */     StringBuilder buffer = new StringBuilder(getNodeValue());
/* 203 */     buffer.replace(offset, offset + count, arg);
/* 204 */     setNodeValue(buffer.toString());
/*     */   }
/*     */ 
/*     */   public void insertData(int offset, String arg)
/*     */     throws DOMException
/*     */   {
/* 219 */     StringBuilder buffer = new StringBuilder(getNodeValue());
/* 220 */     buffer.insert(offset, arg);
/* 221 */     setNodeValue(buffer.toString());
/*     */   }
/*     */ 
/*     */   public void appendData(String arg)
/*     */     throws DOMException
/*     */   {
/* 234 */     setNodeValue(getNodeValue() + arg);
/*     */   }
/*     */ 
/*     */   public void setData(String data)
/*     */     throws DOMException
/*     */   {
/* 253 */     setNodeValue(data);
/*     */   }
/*     */ 
/*     */   public boolean isElementContentWhitespace()
/*     */   {
/* 270 */     return false;
/*     */   }
/*     */ 
/*     */   public String getWholeText()
/*     */   {
/* 285 */     return null;
/*     */   }
/*     */ 
/*     */   public org.w3c.dom.Text replaceWholeText(String content)
/*     */     throws DOMException
/*     */   {
/* 335 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.TextImpl
 * JD-Core Version:    0.6.0
 */