/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPHeaderElement;
/*     */ import javax.xml.soap.Text;
/*     */ import org.jboss.ws.core.utils.SAAJUtils;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.DocumentFragment;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class SOAPHeaderImpl extends SOAPElementImpl
/*     */   implements SOAPHeader
/*     */ {
/*     */   public SOAPHeaderImpl(String prefix, String namespace)
/*     */   {
/*  55 */     super("Header", prefix, namespace);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/*  62 */     QName qname = child.getElementQName();
/*  63 */     if ((qname == null) || (qname.getNamespaceURI().length() == 0)) {
/*  64 */       throw new SOAPException("Invalid SOAPHeaderElement name: " + qname);
/*     */     }
/*     */ 
/*  67 */     if (!(child instanceof SOAPHeaderElement)) {
/*  68 */       child = convertToHeaderElement(child);
/*     */     }
/*  70 */     return super.addChildElement(child);
/*     */   }
/*     */ 
/*     */   public SOAPElement addTextNode(String value)
/*     */     throws SOAPException
/*     */   {
/*  79 */     if ("http://www.w3.org/2003/05/soap-envelope".equals(getNamespaceURI())) {
/*  80 */       throw new SOAPException("Attaching a Text node to this SOAP 1.2 Element is not legal: " + getLocalName());
/*     */     }
/*  82 */     return super.addTextNode(value);
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElement addHeaderElement(Name name)
/*     */     throws SOAPException
/*     */   {
/*  89 */     if (name == null) {
/*  90 */       throw new SOAPException("Invalid SOAPHeaderElement name: " + name);
/*     */     }
/*  92 */     return addHeaderElement(((NameImpl)name).toQName());
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElement addHeaderElement(QName qname) throws SOAPException
/*     */   {
/*  97 */     if ((qname == null) || (qname.getNamespaceURI().length() == 0) || (qname.getPrefix().length() == 0)) {
/*  98 */       throw new SOAPException("Invalid SOAPHeaderElement name: " + qname);
/*     */     }
/* 100 */     SOAPHeaderElementImpl headerElement = new SOAPHeaderElementImpl(qname);
/* 101 */     addChildElement(headerElement);
/* 102 */     return headerElement;
/*     */   }
/*     */ 
/*     */   public Iterator examineAllHeaderElements()
/*     */   {
/* 110 */     ArrayList list = new ArrayList();
/* 111 */     Iterator it = getChildElements();
/* 112 */     while (it.hasNext())
/*     */     {
/* 114 */       SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
/* 115 */       list.add(shElement);
/*     */     }
/* 117 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator examineHeaderElements(String actor)
/*     */   {
/* 124 */     if (actor == null) {
/* 125 */       throw new IllegalArgumentException("Invalid actor: " + actor);
/*     */     }
/*     */ 
/* 128 */     ArrayList list = new ArrayList();
/* 129 */     Iterator it = getChildElements();
/* 130 */     while (it.hasNext())
/*     */     {
/* 132 */       SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
/* 133 */       if (actor.equals(shElement.getActor()))
/* 134 */         list.add(shElement);
/*     */     }
/* 136 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator examineMustUnderstandHeaderElements(String actor)
/*     */   {
/* 144 */     if (actor == null) {
/* 145 */       throw new IllegalArgumentException("Invalid actor: " + actor);
/*     */     }
/*     */ 
/* 148 */     ArrayList list = new ArrayList();
/* 149 */     Iterator it = getChildElements();
/* 150 */     while (it.hasNext())
/*     */     {
/* 152 */       SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
/* 153 */       if ((actor.equals(shElement.getActor())) && (shElement.getMustUnderstand()))
/* 154 */         list.add(shElement);
/*     */     }
/* 156 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator extractAllHeaderElements()
/*     */   {
/* 162 */     ArrayList list = new ArrayList();
/* 163 */     Iterator it = getChildElements();
/* 164 */     while (it.hasNext())
/*     */     {
/* 166 */       SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
/* 167 */       removeChild(shElement);
/* 168 */       list.add(shElement);
/*     */     }
/* 170 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator extractHeaderElements(String actor)
/*     */   {
/* 175 */     if (actor == null) {
/* 176 */       throw new IllegalArgumentException("Invalid actor: " + actor);
/*     */     }
/*     */ 
/* 179 */     ArrayList list = new ArrayList();
/* 180 */     Iterator it = getChildElements();
/* 181 */     while (it.hasNext())
/*     */     {
/* 183 */       SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
/* 184 */       if (actor.equals(shElement.getActor()))
/*     */       {
/* 186 */         removeChild(shElement);
/* 187 */         list.add(shElement);
/*     */       }
/*     */     }
/* 190 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Node appendChild(Node newChild) throws DOMException
/*     */   {
/* 195 */     if (needsConversionToHeaderElement(newChild)) {
/* 196 */       newChild = convertToHeaderElement(newChild);
/*     */     }
/* 198 */     return super.appendChild(newChild);
/*     */   }
/*     */ 
/*     */   public Node insertBefore(Node newChild, Node refChild) throws DOMException
/*     */   {
/* 203 */     if (needsConversionToHeaderElement(newChild)) {
/* 204 */       newChild = convertToHeaderElement(newChild);
/*     */     }
/* 206 */     return super.insertBefore(newChild, refChild);
/*     */   }
/*     */ 
/*     */   public Node replaceChild(Node newChild, Node oldChild) throws DOMException
/*     */   {
/* 211 */     if (needsConversionToHeaderElement(newChild)) {
/* 212 */       newChild = convertToHeaderElement(newChild);
/*     */     }
/* 214 */     return super.replaceChild(newChild, oldChild);
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElement addNotUnderstoodHeaderElement(QName qname) throws SOAPException
/*     */   {
/* 219 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 220 */       throw new UnsupportedOperationException("SOAP 1.1 Header does not support the concept of NotUnderstood");
/*     */     }
/*     */ 
/* 223 */     QName notUnderstoodName = new QName(getNamespaceURI(), "NotUnderstood", getPrefix());
/* 224 */     SOAPHeaderElement notUnderstoodElement = addHeaderElement(notUnderstoodName);
/*     */ 
/* 227 */     SAAJUtils.setQualifiedAttributeValue(notUnderstoodElement, "qname", qname);
/*     */ 
/* 229 */     return notUnderstoodElement;
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElement addUpgradeHeaderElement(Iterator supportedSoapUris) throws SOAPException
/*     */   {
/* 234 */     if (supportedSoapUris == null) {
/* 235 */       throw new SOAPException("list of supported URIs cannot be null");
/*     */     }
/* 237 */     if (!supportedSoapUris.hasNext()) {
/* 238 */       throw new SOAPException("list of supported URIs cannot be empty");
/*     */     }
/* 240 */     String namespaceURI = getNamespaceURI();
/* 241 */     String prefix = getPrefix();
/*     */ 
/* 244 */     QName upgradeName = new QName(namespaceURI, "Upgrade", prefix);
/* 245 */     SOAPHeaderElement upgradeElement = addHeaderElement(upgradeName);
/*     */ 
/* 247 */     while (supportedSoapUris.hasNext())
/*     */     {
/* 249 */       String soapUri = (String)supportedSoapUris.next();
/*     */ 
/* 251 */       SOAPElement supportedElement = upgradeElement.addChildElement("SupportedEnvelope", prefix, namespaceURI);
/* 252 */       SAAJUtils.setQualifiedAttributeValue(supportedElement, "qname", new QName(soapUri, "Envelope"));
/*     */     }
/* 254 */     return upgradeElement;
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElement addUpgradeHeaderElement(String[] supportedSoapUris) throws SOAPException
/*     */   {
/* 259 */     if (supportedSoapUris == null) {
/* 260 */       throw new SOAPException("list of supported URIs cannot be null");
/*     */     }
/* 262 */     return addUpgradeHeaderElement(Arrays.asList(supportedSoapUris).iterator());
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElement addUpgradeHeaderElement(String supportedSoapUri) throws SOAPException
/*     */   {
/* 267 */     if (supportedSoapUri == null) {
/* 268 */       throw new SOAPException("supported URI cannot be null");
/*     */     }
/* 270 */     return addUpgradeHeaderElement(Collections.singletonList(supportedSoapUri).iterator());
/*     */   }
/*     */ 
/*     */   private static boolean needsConversionToHeaderElement(Node newChild)
/*     */   {
/* 276 */     boolean validChild = newChild instanceof SOAPHeaderElementImpl;
/* 277 */     validChild = (validChild) || ((newChild instanceof DocumentFragment));
/* 278 */     validChild = (validChild) || ((newChild instanceof Text));
/* 279 */     validChild = (validChild) || ((newChild instanceof Comment));
/* 280 */     return !validChild;
/*     */   }
/*     */ 
/*     */   private static SOAPHeaderElementImpl convertToHeaderElement(Node node)
/*     */   {
/* 285 */     if (!(node instanceof SOAPElementImpl)) {
/* 286 */       throw new IllegalArgumentException("SOAPElement expected");
/*     */     }
/* 288 */     SOAPElementImpl element = (SOAPElementImpl)node;
/*     */ 
/* 291 */     element.detachNode();
/* 292 */     return new SOAPHeaderElementImpl(element);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPHeaderImpl
 * JD-Core Version:    0.6.0
 */