/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.StringWriter;
/*     */ import java.io.Writer;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPHeaderElement;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Attr;
/*     */ 
/*     */ public class SOAPHeaderElementImpl extends SOAPContentElement
/*     */   implements SOAPHeaderElement
/*     */ {
/*     */   public SOAPHeaderElementImpl(Name name)
/*     */   {
/*  56 */     super(name);
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElementImpl(QName qname)
/*     */   {
/*  61 */     super(qname);
/*     */   }
/*     */ 
/*     */   public SOAPHeaderElementImpl(SOAPElementImpl element)
/*     */   {
/*  66 */     super(element);
/*     */   }
/*     */ 
/*     */   public String getRole()
/*     */   {
/*  71 */     String headerURI = getParentElement().getNamespaceURI();
/*     */ 
/*  73 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
/*  74 */       throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
/*     */     }
/*  76 */     Attr roleAttr = getAttributeNodeNS(headerURI, "role");
/*  77 */     return roleAttr != null ? roleAttr.getValue() : null;
/*     */   }
/*     */ 
/*     */   public void setRole(String roleURI)
/*     */   {
/*  82 */     SOAPElement header = getParentElement();
/*  83 */     String headerURI = header.getNamespaceURI();
/*     */ 
/*  85 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
/*  86 */       throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
/*     */     }
/*  88 */     setAttributeNS(headerURI, header.getPrefix() + ":" + "role", roleURI);
/*     */   }
/*     */ 
/*     */   public boolean getRelay()
/*     */   {
/*  93 */     String headerURI = getParentElement().getNamespaceURI();
/*     */ 
/*  95 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
/*  96 */       throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
/*     */     }
/*  98 */     return DOMUtils.getAttributeValueAsBoolean(this, new QName(headerURI, "relay"));
/*     */   }
/*     */ 
/*     */   public void setRelay(boolean relay)
/*     */   {
/* 103 */     SOAPElement header = getParentElement();
/* 104 */     String headerURI = header.getNamespaceURI();
/*     */ 
/* 106 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
/* 107 */       throw new UnsupportedOperationException("SOAP 1.1 does not support the concept of Role");
/*     */     }
/* 109 */     setAttributeNS(headerURI, header.getPrefix() + ":" + "relay", Boolean.toString(relay));
/*     */   }
/*     */ 
/*     */   public String getActor()
/*     */   {
/* 114 */     String headerURI = getParentElement().getNamespaceURI();
/*     */ 
/* 116 */     if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI)) {
/* 117 */       return getRole();
/*     */     }
/* 119 */     Attr actorAttr = getAttributeNodeNS(headerURI, "actor");
/* 120 */     return actorAttr != null ? actorAttr.getValue() : null;
/*     */   }
/*     */ 
/*     */   public void setActor(String actorURI)
/*     */   {
/* 125 */     SOAPElement header = getParentElement();
/* 126 */     String headerURI = header.getNamespaceURI();
/*     */ 
/* 128 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(headerURI))
/* 129 */       setAttributeNS(headerURI, header.getPrefix() + ":" + "actor", actorURI);
/*     */     else
/* 131 */       setRole(actorURI);
/*     */   }
/*     */ 
/*     */   public boolean getMustUnderstand()
/*     */   {
/* 136 */     String headerURI = getParentElement().getNamespaceURI();
/*     */ 
/* 138 */     return DOMUtils.getAttributeValueAsBoolean(this, new QName(headerURI, "mustUnderstand"));
/*     */   }
/*     */ 
/*     */   public void setMustUnderstand(boolean mustUnderstand)
/*     */   {
/* 143 */     SOAPElement header = getParentElement();
/* 144 */     String headerURI = header.getNamespaceURI();
/*     */ 
/* 146 */     setAttributeNS(headerURI, header.getPrefix() + ":" + "mustUnderstand", mustUnderstand ? "1" : "0");
/*     */   }
/*     */ 
/*     */   public void setParentElement(SOAPElement parent) throws SOAPException
/*     */   {
/* 151 */     if (parent == null) {
/* 152 */       throw new SOAPException("Invalid null parent element");
/*     */     }
/* 154 */     if (!(parent instanceof SOAPHeader)) {
/* 155 */       throw new SOAPException("Invalid parent element: " + parent.getElementName());
/*     */     }
/* 157 */     super.setParentElement(parent);
/*     */   }
/*     */ 
/*     */   public void writeElement(Writer writer)
/*     */     throws IOException
/*     */   {
/* 163 */     StringWriter strwr = new StringWriter(256);
/* 164 */     super.writeElement(strwr);
/*     */ 
/* 166 */     SOAPHeader soapHeader = (SOAPHeader)getParentElement();
/* 167 */     SOAPEnvelope soapEnvelope = (SOAPEnvelope)soapHeader.getParentElement();
/*     */ 
/* 170 */     List knownNamespaces = new ArrayList();
/* 171 */     Iterator prefixes = soapEnvelope.getNamespacePrefixes();
/* 172 */     while (prefixes.hasNext())
/*     */     {
/* 174 */       String prefix = (String)prefixes.next();
/* 175 */       String nsURI = soapEnvelope.getNamespaceURI(prefix);
/* 176 */       String xmlns = " xmlns:" + prefix + "='" + nsURI + "'";
/* 177 */       knownNamespaces.add(xmlns);
/*     */     }
/* 179 */     prefixes = soapHeader.getNamespacePrefixes();
/* 180 */     while (prefixes.hasNext())
/*     */     {
/* 182 */       String prefix = (String)prefixes.next();
/* 183 */       String nsURI = soapHeader.getNamespaceURI(prefix);
/* 184 */       String xmlns = " xmlns:" + prefix + "='" + nsURI + "'";
/* 185 */       knownNamespaces.add(xmlns);
/*     */     }
/*     */ 
/* 189 */     String xmlFragment = strwr.toString();
/* 190 */     for (String xmlns : knownNamespaces)
/*     */     {
/* 192 */       int start = xmlFragment.indexOf(xmlns);
/* 193 */       while (start > 0)
/*     */       {
/* 195 */         int end = start + xmlns.length();
/* 196 */         xmlFragment = xmlFragment.substring(0, start) + xmlFragment.substring(end);
/* 197 */         start = xmlFragment.indexOf(xmlns);
/*     */       }
/*     */     }
/*     */ 
/* 201 */     writer.write(xmlFragment);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPHeaderElementImpl
 * JD-Core Version:    0.6.0
 */