/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.Writer;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Locale;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Detail;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPConstants;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.SOAPFaultElement;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.utils.SAAJUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.jboss.xb.QNameBuilder;
/*     */ import org.w3c.dom.Attr;
/*     */ 
/*     */ public class SOAPFaultImpl extends SOAPBodyElementDoc
/*     */   implements SOAPFault
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(SOAPFaultImpl.class);
/*     */   private SOAPElement faultcode;
/*     */   private SOAPElement faultstring;
/*     */   private SOAPElement faultactor;
/*     */   private SOAPElement faultnode;
/*     */   private Detail detail;
/*  77 */   public static final Set<QName> soap11FaultCodes = new HashSet();
/*     */   public static final Set<QName> soap12FaultCodes;
/*     */ 
/*     */   public SOAPFaultImpl()
/*     */     throws SOAPException
/*     */   {
/*  97 */     this("env", "http://schemas.xmlsoap.org/soap/envelope/");
/*     */   }
/*     */ 
/*     */   public SOAPFaultImpl(String prefix, String namespace) throws SOAPException
/*     */   {
/* 102 */     super(new NameImpl("Fault", prefix, namespace));
/*     */   }
/*     */ 
/*     */   public String getFaultCode()
/*     */   {
/* 109 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 111 */       if (this.faultcode == null) {
/* 112 */         findFaultCodeElement();
/*     */       }
/* 114 */       return this.faultcode.getValue();
/*     */     }
/*     */ 
/* 118 */     if (this.faultcode == null) {
/* 119 */       findCodeElement();
/*     */     }
/* 121 */     return getChildValueElement(this.faultcode).getValue();
/*     */   }
/*     */ 
/*     */   public Name getFaultCodeAsName()
/*     */   {
/* 130 */     return new NameImpl(getFaultCodeAsQName());
/*     */   }
/*     */ 
/*     */   public QName getFaultCodeAsQName()
/*     */   {
/* 135 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 137 */       if (this.faultcode == null) {
/* 138 */         findFaultCodeElement();
/*     */       }
/* 140 */       return QNameBuilder.buildQName(this.faultcode, this.faultcode.getValue());
/*     */     }
/*     */ 
/* 144 */     if (this.faultcode == null) {
/* 145 */       findCodeElement();
/*     */     }
/* 147 */     SOAPElement valueElement = getChildValueElement(this.faultcode);
/* 148 */     return QNameBuilder.buildQName(valueElement, valueElement.getValue());
/*     */   }
/*     */ 
/*     */   private void findFaultCodeElement()
/*     */   {
/* 154 */     this.faultcode = getChildElement(this, Constants.SOAP11_FAULTCODE);
/* 155 */     log.trace("findFaultCodeElement : " + this.faultcode);
/*     */   }
/*     */ 
/*     */   private void findCodeElement()
/*     */   {
/* 160 */     this.faultcode = getChildElement(this, Constants.SOAP12_CODE);
/* 161 */     log.trace("findCodeElement : " + this.faultcode);
/*     */   }
/*     */ 
/*     */   private static SOAPElement getChildValueElement(SOAPElement codeElement)
/*     */   {
/* 166 */     return getChildElement(codeElement, Constants.SOAP12_VALUE);
/*     */   }
/*     */ 
/*     */   public void setFaultCode(String faultCode)
/*     */     throws SOAPException
/*     */   {
/* 174 */     QName qname = QNameBuilder.buildQName(this, faultCode);
/* 175 */     setFaultCode(qname);
/*     */   }
/*     */ 
/*     */   public void setFaultCode(Name faultCode)
/*     */     throws SOAPException
/*     */   {
/* 182 */     setFaultCode(((NameImpl)faultCode).toQName());
/*     */   }
/*     */ 
/*     */   public void setFaultCode(QName faultCode) throws SOAPException
/*     */   {
/* 187 */     boolean isSOAP11 = "http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI());
/*     */ 
/* 189 */     String faultCodeNS = faultCode.getNamespaceURI();
/* 190 */     if (faultCodeNS.length() == 0) {
/* 191 */       throw new SOAPException("Fault code '" + faultCode + "' must be namespace qualified");
/*     */     }
/*     */ 
/* 209 */     if (isSOAP11)
/*     */     {
/* 211 */       if (this.faultcode == null)
/*     */       {
/* 213 */         findFaultCodeElement();
/* 214 */         if (this.faultcode == null)
/* 215 */           this.faultcode = addUnqualifiedFaultElement("faultcode");
/*     */       }
/* 217 */       setCode(this.faultcode, faultCode);
/*     */     }
/*     */     else
/*     */     {
/* 221 */       if (!soap12FaultCodes.contains(faultCode)) {
/* 222 */         throw new SOAPException(faultCode + " is not a standard SOAP 1.2 Code value");
/*     */       }
/* 224 */       if (this.faultcode == null)
/*     */       {
/* 226 */         findCodeElement();
/* 227 */         if (this.faultcode == null)
/*     */         {
/* 229 */           this.faultcode = addQualifiedFaultElement("Code");
/* 230 */           addChildValueElement(this.faultcode);
/*     */         }
/*     */       }
/* 233 */       setCode(getChildValueElement(this.faultcode), faultCode);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void setCode(SOAPElement codeElement, QName code) throws SOAPException
/*     */   {
/* 239 */     SAAJUtils.setQualifiedElementValue(codeElement, code);
/*     */   }
/*     */ 
/*     */   private static SOAPElement addChildValueElement(SOAPElement codeElement) throws SOAPException
/*     */   {
/* 244 */     return codeElement.addChildElement("Value", codeElement.getPrefix(), codeElement.getNamespaceURI());
/*     */   }
/*     */ 
/*     */   public Iterator getFaultSubcodes()
/*     */   {
/* 249 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 250 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Subcode");
/*     */     }
/* 252 */     ArrayList subcodes = new ArrayList();
/*     */ 
/* 254 */     SOAPElement baseCodeElement = this.faultcode;
/*     */ 
/* 256 */     for (SOAPElement subcodeElement = getChildSubcodeElement(baseCodeElement); subcodeElement != null; subcodeElement = getChildSubcodeElement(baseCodeElement))
/*     */     {
/* 258 */       SOAPElement valueElement = getChildValueElement(subcodeElement);
/* 259 */       QName subcode = QNameBuilder.buildQName(valueElement, valueElement.getValue());
/* 260 */       subcodes.add(subcode);
/*     */ 
/* 262 */       baseCodeElement = subcodeElement;
/*     */     }
/*     */ 
/* 266 */     return Collections.unmodifiableList(subcodes).iterator();
/*     */   }
/*     */ 
/*     */   private static SOAPElement getChildSubcodeElement(SOAPElement element)
/*     */   {
/* 271 */     return getChildElement(element, Constants.SOAP12_SUBCODE);
/*     */   }
/*     */ 
/*     */   public void appendFaultSubcode(QName subcode) throws SOAPException
/*     */   {
/* 276 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 277 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Subcode");
/*     */     }
/* 279 */     String nsURI = subcode.getNamespaceURI();
/* 280 */     if (nsURI.length() == 0) {
/* 281 */       throw new SOAPException("subcode must be namespace qualified: " + subcode);
/*     */     }
/* 283 */     if (this.faultcode == null) {
/* 284 */       findCodeElement();
/*     */     }
/*     */ 
/* 287 */     SOAPElement baseCodeElement = this.faultcode;
/* 288 */     for (SOAPElement subcodeElement = getChildSubcodeElement(baseCodeElement); subcodeElement != null; subcodeElement = getChildSubcodeElement(baseCodeElement)) {
/* 289 */       baseCodeElement = subcodeElement;
/*     */     }
/* 291 */     SOAPElement subcodeElement = baseCodeElement.addChildElement("Subcode", baseCodeElement.getPrefix(), baseCodeElement.getNamespaceURI());
/* 292 */     SOAPElement valueElement = addChildValueElement(subcodeElement);
/*     */ 
/* 294 */     setCode(valueElement, subcode);
/*     */   }
/*     */ 
/*     */   public void removeAllFaultSubcodes()
/*     */   {
/* 299 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 300 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Subcode");
/*     */     }
/* 302 */     if (this.faultcode == null) {
/* 303 */       findFaultCodeElement();
/*     */     }
/* 305 */     SOAPElement subcodeElement = getChildSubcodeElement(this.faultcode);
/* 306 */     if (subcodeElement != null)
/* 307 */       subcodeElement.detachNode();
/*     */   }
/*     */ 
/*     */   public String getFaultString()
/*     */   {
/* 314 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 316 */       if (this.faultstring == null)
/*     */       {
/* 318 */         findFaultStringElement();
/* 319 */         if (this.faultstring == null)
/* 320 */           return null;
/*     */       }
/* 322 */       return this.faultstring.getValue();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 328 */       return (String)getFaultReasonTexts().next();
/*     */     }
/*     */     catch (SOAPException e) {
/*     */     }
/* 332 */     return null;
/*     */   }
/*     */ 
/*     */   public Locale getFaultStringLocale()
/*     */   {
/* 341 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 343 */       if (this.faultstring == null)
/*     */       {
/* 345 */         findFaultStringElement();
/* 346 */         if (this.faultstring == null)
/* 347 */           return null;
/*     */       }
/* 349 */       return getLocale(this.faultstring);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 355 */       return (Locale)getFaultReasonLocales().next();
/*     */     }
/*     */     catch (SOAPException e) {
/*     */     }
/* 359 */     return null;
/*     */   }
/*     */ 
/*     */   private void findFaultStringElement()
/*     */   {
/* 366 */     this.faultstring = getChildElement(this, Constants.SOAP11_FAULTSTRING);
/* 367 */     log.trace("findFaultStringElement : " + this.faultstring);
/*     */   }
/*     */ 
/*     */   private static Locale getLocale(SOAPElement element)
/*     */   {
/* 372 */     Attr xmlLang = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
/* 373 */     return xmlLang != null ? toLocale(xmlLang.getValue()) : null;
/*     */   }
/*     */ 
/*     */   private static Locale toLocale(String languageTag)
/*     */   {
/* 382 */     String[] subtags = languageTag.split("-");
/*     */ 
/* 384 */     return subtags.length == 1 ? new Locale(subtags[0]) : new Locale(subtags[0], subtags[1]);
/*     */   }
/*     */ 
/*     */   public void setFaultString(String faultString)
/*     */     throws SOAPException
/*     */   {
/* 391 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 393 */       setFaultStringInternal(faultString);
/* 394 */       this.faultstring.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
/*     */     } else {
/* 396 */       addFaultReasonText(faultString, Locale.getDefault());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setFaultString(String faultString, Locale locale)
/*     */     throws SOAPException
/*     */   {
/* 403 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 405 */       setFaultStringInternal(faultString);
/* 406 */       setLocale(this.faultstring, locale);
/*     */     } else {
/* 408 */       addFaultReasonText(faultString, locale);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setFaultStringInternal(String faultString) throws SOAPException {
/* 413 */     if (this.faultstring == null)
/*     */     {
/* 415 */       findFaultStringElement();
/* 416 */       if (this.faultstring == null)
/* 417 */         this.faultstring = addUnqualifiedFaultElement("faultstring");
/*     */     }
/* 419 */     this.faultstring.setValue(faultString);
/*     */   }
/*     */ 
/*     */   private static void setLocale(SOAPElement element, Locale locale)
/*     */   {
/* 424 */     element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", toLanguageTag(locale));
/*     */   }
/*     */ 
/*     */   private static String toLanguageTag(Locale locale)
/*     */   {
/* 432 */     String languageTag = locale.getLanguage();
/*     */ 
/* 434 */     String country = locale.getCountry();
/* 435 */     if (country.length() != 0) {
/* 436 */       languageTag = languageTag + "-" + country;
/*     */     }
/* 438 */     return languageTag;
/*     */   }
/*     */ 
/*     */   public Iterator getFaultReasonTexts() throws SOAPException
/*     */   {
/* 443 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 444 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
/*     */     }
/* 446 */     if (this.faultstring == null)
/*     */     {
/* 448 */       findReasonElement();
/* 449 */       if (this.faultstring == null) {
/* 450 */         return Collections.EMPTY_LIST.iterator();
/*     */       }
/*     */     }
/* 453 */     ArrayList texts = new ArrayList();
/* 454 */     Iterator it = this.faultstring.getChildElements(Constants.SOAP12_TEXT);
/* 455 */     while (it.hasNext())
/*     */     {
/* 457 */       SOAPElement textElement = (SOAPElement)it.next();
/* 458 */       texts.add(textElement.getValue());
/*     */     }
/*     */ 
/* 461 */     if (texts.isEmpty()) {
/* 462 */       throw new SOAPException("no Text elements found inside Reason");
/*     */     }
/* 464 */     return texts.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getFaultReasonLocales() throws SOAPException
/*     */   {
/* 469 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 470 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
/*     */     }
/* 472 */     if (this.faultstring == null)
/*     */     {
/* 474 */       findReasonElement();
/* 475 */       if (this.faultstring == null) {
/* 476 */         return Collections.EMPTY_LIST.iterator();
/*     */       }
/*     */     }
/* 479 */     ArrayList locales = new ArrayList();
/* 480 */     Iterator it = this.faultstring.getChildElements(Constants.SOAP12_TEXT);
/* 481 */     while (it.hasNext())
/*     */     {
/* 483 */       SOAPElement textElement = (SOAPElement)it.next();
/* 484 */       Locale locale = getLocale(textElement);
/* 485 */       if (locale == null)
/* 486 */         throw new SOAPException("lang attribute not present on Text element");
/* 487 */       locales.add(locale);
/*     */     }
/*     */ 
/* 490 */     if (locales.isEmpty()) {
/* 491 */       throw new SOAPException("no Text elements found inside Reason");
/*     */     }
/* 493 */     return locales.iterator();
/*     */   }
/*     */ 
/*     */   public String getFaultReasonText(Locale locale) throws SOAPException
/*     */   {
/* 498 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 499 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
/*     */     }
/* 501 */     if (locale == null) {
/* 502 */       return null;
/*     */     }
/* 504 */     if (this.faultstring == null)
/*     */     {
/* 506 */       findReasonElement();
/* 507 */       if (this.faultstring == null) {
/* 508 */         return null;
/*     */       }
/*     */     }
/* 511 */     SOAPElement textElement = getTextElement(locale);
/* 512 */     return textElement != null ? textElement.getValue() : null;
/*     */   }
/*     */ 
/*     */   private void findReasonElement()
/*     */   {
/* 517 */     this.faultstring = getChildElement(this, Constants.SOAP12_REASON);
/* 518 */     log.trace("findReasonElement: " + this.faultstring);
/*     */   }
/*     */ 
/*     */   private SOAPElement getTextElement(Locale locale)
/*     */   {
/* 523 */     log.trace("getTextElement(" + locale + ")");
/* 524 */     SOAPElement textElement = null;
/*     */ 
/* 526 */     Iterator it = this.faultstring.getChildElements(Constants.SOAP12_TEXT);
/* 527 */     while (it.hasNext())
/*     */     {
/* 529 */       SOAPElement element = (SOAPElement)it.next();
/* 530 */       if (locale.equals(getLocale(element)))
/*     */       {
/* 532 */         textElement = element;
/* 533 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 537 */     log.trace("getTextElement : " + textElement);
/* 538 */     return textElement;
/*     */   }
/*     */ 
/*     */   public void addFaultReasonText(String text, Locale locale) throws SOAPException
/*     */   {
/* 543 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 544 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
/*     */     }
/* 546 */     if (locale == null) {
/* 547 */       throw new SOAPException("locale passed is null");
/*     */     }
/* 549 */     if (this.faultstring == null)
/*     */     {
/* 551 */       findReasonElement();
/* 552 */       if (this.faultstring == null) {
/* 553 */         this.faultstring = addQualifiedFaultElement("Reason");
/*     */       }
/*     */     }
/* 556 */     SOAPElement textElement = getTextElement(locale);
/* 557 */     if (textElement == null)
/*     */     {
/* 559 */       textElement = this.faultstring.addChildElement("Text", getPrefix(), getNamespaceURI());
/* 560 */       setLocale(textElement, locale);
/*     */     }
/* 562 */     textElement.setValue(text);
/*     */   }
/*     */ 
/*     */   public String getFaultActor()
/*     */   {
/* 569 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 571 */       if (this.faultactor == null)
/*     */       {
/* 573 */         findFaultActorElement();
/* 574 */         if (this.faultactor == null)
/* 575 */           return null;
/*     */       }
/* 577 */       return this.faultactor.getValue();
/*     */     }
/* 579 */     return getFaultRole();
/*     */   }
/*     */ 
/*     */   private void findFaultActorElement()
/*     */   {
/* 584 */     this.faultactor = getChildElement(this, Constants.SOAP11_FAULTACTOR);
/* 585 */     log.trace("findFaultActorElement : " + this.faultactor);
/*     */   }
/*     */ 
/*     */   public void setFaultActor(String faultActor)
/*     */     throws SOAPException
/*     */   {
/* 592 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 594 */       if (this.faultactor == null)
/*     */       {
/* 596 */         findFaultActorElement();
/* 597 */         if (this.faultactor == null)
/* 598 */           this.faultactor = addUnqualifiedFaultElement("faultactor");
/*     */       }
/* 600 */       this.faultactor.setValue(faultActor);
/*     */     } else {
/* 602 */       setFaultRole(faultActor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getFaultRole() {
/* 607 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 608 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Role");
/*     */     }
/* 610 */     if (this.faultactor == null)
/*     */     {
/* 612 */       findRoleElement();
/* 613 */       if (this.faultactor == null)
/* 614 */         return null;
/*     */     }
/* 616 */     return this.faultactor.getValue();
/*     */   }
/*     */ 
/*     */   private void findRoleElement()
/*     */   {
/* 621 */     this.faultactor = getChildElement(this, Constants.SOAP12_ROLE);
/* 622 */     log.trace("findRoleElement : " + this.faultactor);
/*     */   }
/*     */ 
/*     */   public void setFaultRole(String uri) throws SOAPException
/*     */   {
/* 627 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 628 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Role");
/*     */     }
/* 630 */     if (this.faultactor == null)
/*     */     {
/* 632 */       findRoleElement();
/* 633 */       if (this.faultactor == null)
/* 634 */         this.faultactor = addQualifiedFaultElement("Role");
/*     */     }
/* 636 */     this.faultactor.setValue(uri);
/*     */   }
/*     */ 
/*     */   public String getFaultNode()
/*     */   {
/* 641 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 642 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Node");
/*     */     }
/* 644 */     if (this.faultnode == null)
/*     */     {
/* 646 */       findNodeElement();
/* 647 */       if (this.faultnode == null)
/* 648 */         return null;
/*     */     }
/* 650 */     return this.faultnode.getValue();
/*     */   }
/*     */ 
/*     */   private void findNodeElement()
/*     */   {
/* 655 */     this.faultnode = getChildElement(this, Constants.SOAP12_NODE);
/* 656 */     log.trace("findNodeElement : " + this.faultnode);
/*     */   }
/*     */ 
/*     */   public void setFaultNode(String uri) throws SOAPException
/*     */   {
/* 661 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) {
/* 662 */       throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Node");
/*     */     }
/* 664 */     if (this.faultnode == null)
/*     */     {
/* 666 */       findNodeElement();
/* 667 */       if (this.faultnode == null)
/* 668 */         this.faultnode = addQualifiedFaultElement("Node");
/*     */     }
/* 670 */     this.faultnode.setValue(uri);
/*     */   }
/*     */ 
/*     */   public boolean hasDetail()
/*     */   {
/* 675 */     return getDetail() != null;
/*     */   }
/*     */ 
/*     */   public Detail getDetail()
/*     */   {
/* 682 */     if (this.detail == null)
/*     */     {
/* 684 */       if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/* 685 */         findSoap11DetailElement();
/* 686 */       else findSoap12DetailElement();
/*     */     }
/* 688 */     return this.detail;
/*     */   }
/*     */ 
/*     */   public Detail addDetail()
/*     */     throws SOAPException
/*     */   {
/* 695 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()))
/*     */     {
/* 697 */       if (this.detail == null) {
/* 698 */         findSoap11DetailElement();
/*     */       }
/* 700 */       if (this.detail != null) {
/* 701 */         throw new SOAPException("this fault already contains a detail element");
/*     */       }
/* 703 */       this.detail = new DetailImpl();
/*     */     }
/*     */     else
/*     */     {
/* 707 */       if (this.detail == null) {
/* 708 */         findSoap12DetailElement();
/*     */       }
/* 710 */       if (this.detail != null) {
/* 711 */         throw new SOAPException("this fault already contains a detail element");
/*     */       }
/* 713 */       this.detail = new DetailImpl(getPrefix(), getNamespaceURI());
/*     */     }
/*     */ 
/* 716 */     this.detail = ((Detail)addChildElement(this.detail));
/* 717 */     return this.detail;
/*     */   }
/*     */ 
/*     */   private void findSoap11DetailElement()
/*     */   {
/* 722 */     this.detail = ((Detail)getChildElement(this, Constants.SOAP11_DETAIL));
/* 723 */     log.trace("findSoap11DetailElement : " + this.detail);
/*     */   }
/*     */ 
/*     */   private void findSoap12DetailElement()
/*     */   {
/* 728 */     this.detail = ((Detail)getChildElement(this, Constants.SOAP12_DETAIL));
/* 729 */     log.trace("findSoap12DetailElement : " + this.detail);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/* 735 */     if (!(child instanceof SOAPFaultElement)) {
/* 736 */       child = convertToFaultElement((SOAPElementImpl)child);
/*     */     }
/* 738 */     return super.addChildElement(child);
/*     */   }
/*     */ 
/*     */   private SOAPFaultElement convertToFaultElement(SOAPElementImpl element)
/*     */   {
/* 743 */     element.detachNode();
/*     */ 
/* 745 */     QName elementName = element.getElementQName();
/*     */     SOAPFaultElement faultElement;
/*     */     SOAPFaultElement faultElement;
/* 747 */     if ("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()) ? Constants.SOAP11_DETAIL.equals(elementName) : Constants.SOAP12_DETAIL.equals(elementName))
/* 748 */       faultElement = new DetailImpl(element);
/* 749 */     else faultElement = new SOAPFaultElementImpl(element);
/*     */ 
/* 751 */     log.trace("convertToFaultElement : " + faultElement);
/* 752 */     return faultElement;
/*     */   }
/*     */ 
/*     */   QName getDefaultFaultCode()
/*     */   {
/* 757 */     return "http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI()) ? Constants.SOAP11_FAULT_CODE_SERVER : SOAPConstants.SOAP_RECEIVER_FAULT;
/*     */   }
/*     */ 
/*     */   public void writeElement(Writer writer)
/*     */   {
/* 762 */     new DOMWriter(writer).print(this);
/*     */   }
/*     */ 
/*     */   private static SOAPElement getChildElement(SOAPElement element, QName name)
/*     */   {
/* 767 */     Iterator it = element.getChildElements(name);
/* 768 */     return it.hasNext() ? (SOAPElement)it.next() : null;
/*     */   }
/*     */ 
/*     */   private SOAPElement addUnqualifiedFaultElement(String localName) throws SOAPException
/*     */   {
/* 773 */     log.trace("addUnqualifiedFaultElement(" + localName + ")");
/* 774 */     return addChildElement(new SOAPFaultElementImpl(localName));
/*     */   }
/*     */ 
/*     */   private SOAPElement addQualifiedFaultElement(String localName) throws SOAPException
/*     */   {
/* 779 */     log.trace("addQualifiedFaultElement(" + localName + ")");
/* 780 */     return addChildElement(new SOAPFaultElementImpl(localName, getPrefix(), getNamespaceURI()));
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  80 */     soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_CLIENT);
/*  81 */     soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_SERVER);
/*  82 */     soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH);
/*  83 */     soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND);
/*     */ 
/*  85 */     soap12FaultCodes = new HashSet();
/*     */ 
/*  88 */     soap12FaultCodes.add(SOAPConstants.SOAP_VERSIONMISMATCH_FAULT);
/*  89 */     soap12FaultCodes.add(SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT);
/*  90 */     soap12FaultCodes.add(SOAPConstants.SOAP_DATAENCODINGUNKNOWN_FAULT);
/*  91 */     soap12FaultCodes.add(SOAPConstants.SOAP_SENDER_FAULT);
/*  92 */     soap12FaultCodes.add(SOAPConstants.SOAP_RECEIVER_FAULT);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPFaultImpl
 * JD-Core Version:    0.6.0
 */