/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Detail;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFactory;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class SOAPFactoryImpl extends SOAPFactory
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(SOAPFactoryImpl.class);
/*     */   private String envNamespace;
/*     */ 
/*     */   public SOAPFactoryImpl()
/*     */   {
/*  57 */     this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
/*     */   }
/*     */ 
/*     */   public SOAPFactoryImpl(String protocol) throws SOAPException
/*     */   {
/*  62 */     if ("SOAP 1.2 Protocol".equals(protocol))
/*  63 */       this.envNamespace = "http://www.w3.org/2003/05/soap-envelope";
/*  64 */     else if ("SOAP 1.1 Protocol".equals(protocol))
/*  65 */       this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
/*  66 */     else if ("Dynamic Protocol".equals(protocol)) {
/*  67 */       this.envNamespace = null;
/*     */     }
/*     */     else
/*     */     {
/*  71 */       throw new SOAPException("Unknown protocol: " + protocol);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SOAPElement createElement(Name name) throws SOAPException
/*     */   {
/*  77 */     return new SOAPElementImpl(name);
/*     */   }
/*     */ 
/*     */   public SOAPElement createElement(QName qname)
/*     */     throws SOAPException
/*     */   {
/*  83 */     return createElement(new NameImpl(qname));
/*     */   }
/*     */ 
/*     */   public SOAPElement createElement(String localName)
/*     */     throws SOAPException
/*     */   {
/*  89 */     return new SOAPElementImpl(localName);
/*     */   }
/*     */ 
/*     */   public SOAPElement createElement(String localName, String prefix, String uri)
/*     */     throws SOAPException
/*     */   {
/*  95 */     return new SOAPElementImpl(localName, prefix, uri);
/*     */   }
/*     */ 
/*     */   public SOAPElement createElement(Element domElement)
/*     */     throws SOAPException
/*     */   {
/* 101 */     return createElement(domElement, true);
/*     */   }
/*     */ 
/*     */   public SOAPElement createElement(Element domElement, boolean deep)
/*     */     throws SOAPException
/*     */   {
/* 110 */     if (domElement == null) {
/* 111 */       throw new IllegalArgumentException("Source node cannot be null");
/*     */     }
/*     */ 
/* 114 */     if (((domElement instanceof SOAPElement)) && (deep == true)) {
/* 115 */       return (SOAPElement)domElement;
/*     */     }
/* 117 */     String localName = domElement.getLocalName();
/* 118 */     String prefix = domElement.getPrefix() != null ? domElement.getPrefix() : "";
/* 119 */     String nsURI = domElement.getNamespaceURI() != null ? domElement.getNamespaceURI() : "";
/*     */ 
/* 121 */     SOAPFactory factory = SOAPFactory.newInstance();
/* 122 */     SOAPElement soapElement = factory.createElement(localName, prefix, nsURI);
/*     */ 
/* 124 */     if ((domElement instanceof Element)) {
/* 125 */       DOMUtils.copyAttributes(soapElement, domElement);
/*     */     }
/* 127 */     if (deep)
/*     */     {
/* 130 */       NodeList nlist = domElement.getChildNodes();
/* 131 */       for (int i = 0; i < nlist.getLength(); i++)
/*     */       {
/* 133 */         Node child = nlist.item(i);
/* 134 */         short nodeType = child.getNodeType();
/* 135 */         if (nodeType == 1)
/*     */         {
/* 137 */           SOAPElement soapChild = createElement((Element)child);
/* 138 */           soapElement.addChildElement(soapChild);
/*     */         }
/* 140 */         else if (nodeType == 3)
/*     */         {
/* 142 */           String nodeValue = child.getNodeValue();
/* 143 */           soapElement.addTextNode(nodeValue);
/*     */         }
/* 145 */         else if (nodeType == 4)
/*     */         {
/* 147 */           String nodeValue = child.getNodeValue();
/* 148 */           soapElement.addTextNode(nodeValue);
/*     */         }
/*     */         else
/*     */         {
/* 152 */           log.trace("Ignore child type: " + nodeType);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 157 */     return soapElement;
/*     */   }
/*     */ 
/*     */   public Detail createDetail()
/*     */     throws SOAPException
/*     */   {
/* 163 */     assertEnvNamespace();
/*     */ 
/* 165 */     return "http://schemas.xmlsoap.org/soap/envelope/".equals(this.envNamespace) ? new DetailImpl() : new DetailImpl("env", this.envNamespace);
/*     */   }
/*     */ 
/*     */   public Name createName(String localName, String prefix, String uri)
/*     */     throws SOAPException
/*     */   {
/* 172 */     return new NameImpl(localName, prefix, uri);
/*     */   }
/*     */ 
/*     */   public Name createName(String localName)
/*     */     throws SOAPException
/*     */   {
/* 178 */     return new NameImpl(localName);
/*     */   }
/*     */ 
/*     */   public SOAPFault createFault(String reasonText, QName faultCode)
/*     */     throws SOAPException
/*     */   {
/* 184 */     assertEnvNamespace();
/*     */ 
/* 186 */     SOAPFaultImpl soapFault = new SOAPFaultImpl("env", this.envNamespace);
/* 187 */     soapFault.setFaultCode(faultCode);
/* 188 */     soapFault.setFaultString(reasonText);
/* 189 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public SOAPFault createFault()
/*     */     throws SOAPException
/*     */   {
/* 195 */     assertEnvNamespace();
/*     */ 
/* 197 */     SOAPFaultImpl soapFault = new SOAPFaultImpl("env", this.envNamespace);
/* 198 */     soapFault.setFaultCode(soapFault.getDefaultFaultCode());
/* 199 */     return soapFault;
/*     */   }
/*     */ 
/*     */   private void assertEnvNamespace()
/*     */   {
/* 204 */     if (this.envNamespace == null)
/* 205 */       throw new UnsupportedOperationException("Envelope namespace not specified, use one of the SOAP protocols");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPFactoryImpl
 * JD-Core Version:    0.6.0
 */