/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.io.Writer;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ 
/*     */ public class SOAPElementWriter
/*     */ {
/*     */   private PrintWriter out;
/*     */   private boolean writeXMLDeclaration;
/*     */   private String charsetName;
/*     */ 
/*     */   public SOAPElementWriter(Writer w)
/*     */   {
/*  59 */     this.out = new PrintWriter(w);
/*     */   }
/*     */ 
/*     */   public SOAPElementWriter(OutputStream stream)
/*     */   {
/*     */     try
/*     */     {
/*  66 */       this.out = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public SOAPElementWriter(OutputStream stream, String charsetName)
/*     */   {
/*     */     try
/*     */     {
/*  78 */       this.out = new PrintWriter(new OutputStreamWriter(stream, charsetName));
/*  79 */       this.charsetName = charsetName;
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/*  83 */       throw new IllegalArgumentException("Unsupported encoding: " + charsetName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SOAPElementWriter setWriteXMLDeclaration(boolean writeXMLDeclaration)
/*     */   {
/*  93 */     this.writeXMLDeclaration = writeXMLDeclaration;
/*  94 */     return this;
/*     */   }
/*     */ 
/*     */   public static String writeElement(SOAPElementImpl element, boolean pretty)
/*     */   {
/* 103 */     if (element == null) {
/* 104 */       return null;
/*     */     }
/* 106 */     StringWriter strw = new StringWriter();
/* 107 */     new SOAPElementWriter(strw).writeElement(element);
/* 108 */     String xmlStr = strw.toString();
/*     */ 
/* 110 */     if (pretty)
/*     */     {
/*     */       try
/*     */       {
/* 117 */         xmlStr = DOMWriter.printNode(DOMUtils.parse(xmlStr), true);
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 121 */         throw new WSException("Cannot parse xml: " + xmlStr, ex);
/*     */       }
/*     */     }
/*     */ 
/* 125 */     return xmlStr;
/*     */   }
/*     */ 
/*     */   public void writeElement(SOAPElementImpl element)
/*     */   {
/* 130 */     writeElementInternal(element);
/*     */   }
/*     */ 
/*     */   private void writeElementInternal(SOAPElementImpl element)
/*     */   {
/* 135 */     if (element != null)
/*     */     {
/*     */       try
/*     */       {
/* 139 */         if ((this.writeXMLDeclaration == true) && ((element instanceof SOAPEnvelope)))
/*     */         {
/* 141 */           this.out.print("<?xml version='1.0'");
/* 142 */           if (this.charsetName != null) {
/* 143 */             this.out.print(" encoding='" + this.charsetName + "'");
/*     */           }
/* 145 */           this.out.println("?>");
/* 146 */           this.writeXMLDeclaration = false;
/*     */         }
/*     */ 
/* 149 */         element.writeElement(this.out);
/*     */ 
/* 151 */         this.out.flush();
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 155 */         throw new WSException("Cannot write SOAP element", ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPElementWriter
 * JD-Core Version:    0.6.0
 */