/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.Text;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.TypeInfo;
/*     */ 
/*     */ public class SOAPElementImpl extends NodeImpl
/*     */   implements SOAPElement, SAAJVisitable
/*     */ {
/*  66 */   private static Logger log = Logger.getLogger(SOAPElementImpl.class);
/*     */   private Element element;
/*     */   private Name elementName;
/*     */ 
/*     */   public SOAPElementImpl(String localPart)
/*     */   {
/*  76 */     super(DOMUtils.createElement(localPart, null, null));
/*  77 */     this.element = ((Element)this.domNode);
/*  78 */     log.trace("new SOAPElementImpl: " + getElementName());
/*     */   }
/*     */ 
/*     */   public SOAPElementImpl(String localPart, String prefix, String nsURI)
/*     */   {
/*  84 */     super(DOMUtils.createElement(localPart, prefix, nsURI));
/*  85 */     this.element = ((Element)this.domNode);
/*  86 */     log.trace("new SOAPElementImpl: " + getElementName());
/*     */   }
/*     */ 
/*     */   public SOAPElementImpl(Name name)
/*     */   {
/*  92 */     this(name.getLocalName(), name.getPrefix(), name.getURI());
/*     */   }
/*     */ 
/*     */   public SOAPElementImpl(QName qname)
/*     */   {
/*  98 */     this(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
/*     */   }
/*     */ 
/*     */   protected SOAPElementImpl(SOAPElementImpl element)
/*     */   {
/* 105 */     super(element);
/* 106 */     this.element = ((Element)this.domNode);
/* 107 */     log.trace("new SOAPElementImpl: " + getElementName());
/*     */   }
/*     */ 
/*     */   public SOAPEnvelope getSOAPEnvelope()
/*     */   {
/* 113 */     SOAPElement soapElement = this;
/* 114 */     while ((soapElement != null) && (!(soapElement instanceof SOAPEnvelope))) {
/* 115 */       soapElement = soapElement.getParentElement();
/*     */     }
/* 117 */     return (SOAPEnvelope)soapElement;
/*     */   }
/*     */ 
/*     */   public QName getElementQName()
/*     */   {
/* 124 */     return ((NameImpl)getElementName()).toQName();
/*     */   }
/*     */ 
/*     */   public SOAPElement setElementQName(QName qname)
/*     */     throws SOAPException
/*     */   {
/* 139 */     if (("http://schemas.xmlsoap.org/soap/envelope/".equals(getNamespaceURI())) || ("http://www.w3.org/2003/05/soap-envelope".equals(getNamespaceURI()))) {
/* 140 */       throw new SOAPException("Changing the name of this SOAP Element is not allowed: " + getLocalName());
/*     */     }
/* 142 */     return setElementQNameInternal(qname);
/*     */   }
/*     */ 
/*     */   public SOAPElement setElementQNameInternal(QName qname) throws SOAPException
/*     */   {
/* 147 */     this.elementName = new NameImpl(qname);
/*     */ 
/* 149 */     Document owner = this.domNode.getOwnerDocument();
/* 150 */     this.domNode = owner.renameNode(this.domNode, this.elementName.getURI(), this.elementName.getQualifiedName());
/* 151 */     this.element = ((Element)this.domNode);
/*     */ 
/* 153 */     return completeNamespaceDeclaration();
/*     */   }
/*     */ 
/*     */   public SOAPElement addAttribute(Name name, String value)
/*     */     throws SOAPException
/*     */   {
/* 167 */     if ("xml".equals(name.getPrefix()))
/*     */     {
/* 169 */       setAttribute(name.getQualifiedName(), value);
/*     */     }
/*     */     else
/*     */     {
/* 173 */       setAttributeNS(name.getURI(), name.getQualifiedName(), value);
/*     */     }
/* 175 */     return this;
/*     */   }
/*     */ 
/*     */   public SOAPElement addAttribute(QName qname, String value) throws SOAPException
/*     */   {
/* 180 */     return addAttribute(new NameImpl(qname), value);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(String name)
/*     */     throws SOAPException
/*     */   {
/* 192 */     SOAPElement soapElement = new SOAPElementImpl(name);
/* 193 */     soapElement = addChildElement(soapElement);
/* 194 */     return soapElement;
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(String localName, String prefix)
/*     */     throws SOAPException
/*     */   {
/* 207 */     String nsURI = getNamespaceURI(prefix);
/* 208 */     if (nsURI == null) {
/* 209 */       throw new IllegalArgumentException("Cannot obtain namespace URI for prefix: " + prefix);
/*     */     }
/* 211 */     SOAPElement soapElement = new SOAPElementImpl(localName, prefix, nsURI);
/* 212 */     soapElement = addChildElement(soapElement);
/* 213 */     return soapElement;
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(String localName, String prefix, String uri)
/*     */     throws SOAPException
/*     */   {
/* 227 */     SOAPElement soapElement = new SOAPElementImpl(localName, prefix, uri);
/* 228 */     soapElement = addChildElement(soapElement);
/* 229 */     return soapElement;
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(Name name)
/*     */     throws SOAPException
/*     */   {
/* 241 */     SOAPElement soapElement = new SOAPElementImpl(name);
/* 242 */     soapElement = addChildElement(soapElement);
/* 243 */     return soapElement;
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(QName qname) throws SOAPException
/*     */   {
/* 248 */     return addChildElement(new NameImpl(qname));
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/* 272 */     log.trace("addChildElement: " + getElementName() + " -> " + child.getElementName());
/* 273 */     SOAPElementImpl soapElement = (SOAPElementImpl)child;
/* 274 */     soapElement = (SOAPElementImpl)appendChild(soapElement);
/* 275 */     return soapElement.completeNamespaceDeclaration();
/*     */   }
/*     */ 
/*     */   public SOAPElement addNamespaceDeclaration(String prefix, String nsURI)
/*     */   {
/* 288 */     if (nsURI == null)
/* 289 */       throw new IllegalArgumentException("Invalid 'null' namespace URI");
/* 290 */     if (nsURI.length() == 0) {
/* 291 */       throw new IllegalArgumentException("Invalid empty namespace URI");
/*     */     }
/* 293 */     String qualifiedName = "xmlns";
/* 294 */     if ((prefix != null) && (prefix.length() > 0)) {
/* 295 */       qualifiedName = qualifiedName + ":" + prefix;
/*     */     }
/* 297 */     log.trace("addNamespaceDeclaration: " + qualifiedName + "='" + nsURI + "'");
/* 298 */     this.element.setAttributeNS("http://www.w3.org/2000/xmlns/", qualifiedName, nsURI);
/* 299 */     return this;
/*     */   }
/*     */ 
/*     */   private SOAPElement completeNamespaceDeclaration()
/*     */   {
/* 305 */     String prefix = getPrefix();
/* 306 */     String nsURI = getNamespaceURI();
/* 307 */     if ((prefix != null) && (nsURI != null))
/*     */     {
/* 309 */       String prevNS = getNamespaceURI(prefix);
/* 310 */       if (!nsURI.equals(prevNS))
/* 311 */         addNamespaceDeclaration(prefix, nsURI);
/*     */     }
/* 313 */     return this;
/*     */   }
/*     */ 
/*     */   public SOAPElement addTextNode(String value)
/*     */     throws SOAPException
/*     */   {
/* 326 */     log.trace("addTextNode: " + value);
/*     */     org.w3c.dom.Node domNode;
/*     */     org.w3c.dom.Node domNode;
/* 328 */     if ((value.startsWith("<!--")) && (value.endsWith("-->")))
/*     */     {
/* 330 */       value = value.substring(4, value.length() - 3);
/* 331 */       domNode = this.element.getOwnerDocument().createComment(value);
/*     */     }
/*     */     else
/*     */     {
/* 335 */       domNode = this.element.getOwnerDocument().createTextNode(value);
/*     */     }
/* 337 */     Text soapText = new TextImpl(domNode);
/* 338 */     appendChild(soapText);
/* 339 */     return this;
/*     */   }
/*     */ 
/*     */   public Iterator getAllAttributes()
/*     */   {
/* 352 */     ArrayList list = new ArrayList();
/* 353 */     NamedNodeMap nnm = getAttributes();
/* 354 */     for (int i = 0; i < nnm.getLength(); i++)
/*     */     {
/* 356 */       org.w3c.dom.Node node = nnm.item(i);
/* 357 */       String local = node.getLocalName();
/* 358 */       String prefix = node.getPrefix();
/* 359 */       String uri = node.getNamespaceURI();
/* 360 */       if ("xmlns".equals(prefix))
/*     */         continue;
/*     */       Name name;
/*     */       Name name;
/* 363 */       if ((uri != null) && (uri.length() > 0))
/*     */       {
/* 365 */         name = new NameImpl(local, prefix, uri);
/*     */       }
/*     */       else
/*     */       {
/* 369 */         name = new NameImpl(local);
/*     */       }
/* 371 */       list.add(name);
/*     */     }
/*     */ 
/* 374 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getAllAttributesAsQNames()
/*     */   {
/* 379 */     ArrayList list = new ArrayList();
/* 380 */     NamedNodeMap nnm = getAttributes();
/* 381 */     for (int i = 0; i < nnm.getLength(); i++)
/*     */     {
/* 383 */       org.w3c.dom.Node node = nnm.item(i);
/* 384 */       String local = node.getLocalName();
/* 385 */       String prefix = node.getPrefix();
/* 386 */       String uri = node.getNamespaceURI();
/* 387 */       if ("xmlns".equals(prefix))
/*     */         continue;
/*     */       QName qname;
/*     */       QName qname;
/* 390 */       if ((uri != null) && (uri.length() > 0))
/*     */       {
/* 392 */         qname = new QName(uri, local, prefix);
/*     */       }
/*     */       else
/*     */       {
/* 396 */         qname = new QName(local);
/*     */       }
/* 398 */       list.add(qname);
/*     */     }
/*     */ 
/* 401 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public String getAttributeValue(Name name)
/*     */   {
/* 412 */     Attr attr = getAttributeNode(name);
/* 413 */     return attr != null ? attr.getValue() : null;
/*     */   }
/*     */ 
/*     */   public String getAttributeValue(QName qname)
/*     */   {
/* 418 */     return getAttributeValue(new NameImpl(qname));
/*     */   }
/*     */ 
/*     */   private Attr getAttributeNode(Name name)
/*     */   {
/* 423 */     Attr attr = null;
/* 424 */     String nsURI = name.getURI();
/* 425 */     if (nsURI.length() > 0)
/* 426 */       attr = this.element.getAttributeNodeNS(nsURI, name.getLocalName());
/* 427 */     else attr = this.element.getAttributeNode(name.getLocalName());
/*     */ 
/* 429 */     return attr;
/*     */   }
/*     */ 
/*     */   public QName createQName(String localName, String prefix)
/*     */     throws SOAPException
/*     */   {
/* 444 */     String nsURI = getNamespaceURI(prefix);
/* 445 */     if (nsURI == null) {
/* 446 */       throw new SOAPException("CAnnot obtain namespace URI for prefix: " + prefix);
/*     */     }
/* 448 */     return new QName(nsURI, localName, prefix);
/*     */   }
/*     */ 
/*     */   public Iterator getChildElements()
/*     */   {
/* 465 */     List list = new ArrayList();
/* 466 */     NodeList nodeList = getChildNodes();
/* 467 */     for (int i = 0; i < nodeList.getLength(); i++)
/*     */     {
/* 469 */       org.w3c.dom.Node node = nodeList.item(i);
/* 470 */       if ((node instanceof SAAJVisitable))
/*     */       {
/* 472 */         list.add(node);
/*     */       } else {
/* 474 */         if (!(node instanceof Text))
/*     */           continue;
/* 476 */         list.add(node);
/*     */       }
/*     */     }
/* 479 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getChildElements(Name name)
/*     */   {
/* 497 */     return getChildElements(((NameImpl)name).toQName());
/*     */   }
/*     */ 
/*     */   public Iterator getChildElements(QName qname)
/*     */   {
/* 502 */     List list = new ArrayList();
/* 503 */     Iterator it = getChildElements();
/* 504 */     while (it.hasNext())
/*     */     {
/* 506 */       Object elementOrTextNode = it.next();
/* 507 */       if ((elementOrTextNode instanceof SAAJVisitable))
/*     */       {
/* 509 */         SOAPElement el = (SAAJVisitable)elementOrTextNode;
/* 510 */         if (el.getElementQName().equals(qname))
/* 511 */           list.add(el);
/*     */       }
/*     */     }
/* 514 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Name getElementName()
/*     */   {
/* 524 */     if (this.elementName == null)
/*     */     {
/* 526 */       String nsURI = this.element.getNamespaceURI();
/* 527 */       if ((nsURI != null) && (nsURI.length() > 0))
/*     */       {
/* 529 */         String prefix = this.element.getPrefix();
/* 530 */         String localName = this.element.getLocalName();
/* 531 */         this.elementName = new NameImpl(localName, prefix, nsURI);
/*     */       }
/*     */       else
/*     */       {
/* 535 */         String nodeName = this.element.getNodeName();
/* 536 */         this.elementName = new NameImpl(nodeName);
/*     */       }
/*     */     }
/* 539 */     return this.elementName;
/*     */   }
/*     */ 
/*     */   public Iterator getNamespacePrefixes()
/*     */   {
/* 551 */     ArrayList list = getNamespacePrefixList();
/* 552 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   private ArrayList getNamespacePrefixList()
/*     */   {
/* 557 */     ArrayList list = new ArrayList();
/* 558 */     NamedNodeMap attrMap = this.element.getAttributes();
/* 559 */     for (int i = 0; i < attrMap.getLength(); i++)
/*     */     {
/* 561 */       Attr attr = (Attr)attrMap.item(i);
/* 562 */       String attrName = attr.getNodeName();
/* 563 */       if (attrName.startsWith("xmlns:"))
/* 564 */         list.add(attrName.substring(6));
/*     */     }
/* 566 */     return list;
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI(String prefix)
/*     */   {
/* 577 */     String nsURI = this.element.getAttribute("xmlns:" + prefix);
/* 578 */     if ((nsURI.length() == 0) && (getParentElement() != null)) {
/* 579 */       return getParentElement().getNamespaceURI(prefix);
/*     */     }
/* 581 */     return nsURI.length() > 0 ? nsURI : null;
/*     */   }
/*     */ 
/*     */   public Iterator getVisibleNamespacePrefixes()
/*     */   {
/* 593 */     ArrayList list = getNamespacePrefixList();
/* 594 */     SOAPElementImpl parent = (SOAPElementImpl)getParentElement();
/* 595 */     while (parent != null)
/*     */     {
/* 597 */       list.addAll(parent.getNamespacePrefixList());
/* 598 */       parent = (SOAPElementImpl)parent.getParentElement();
/*     */     }
/* 600 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public boolean removeAttribute(Name name)
/*     */   {
/* 611 */     Attr attr = getAttributeNode(name);
/* 612 */     if (attr != null)
/*     */     {
/* 614 */       this.element.removeAttributeNode(attr);
/* 615 */       return true;
/*     */     }
/* 617 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean removeAttribute(QName qname)
/*     */   {
/* 622 */     return removeAttribute(new NameImpl(qname));
/*     */   }
/*     */ 
/*     */   public void removeContents()
/*     */   {
/* 634 */     log.trace("removeContents");
/* 635 */     Iterator it = getChildElements();
/* 636 */     while (it.hasNext())
/*     */     {
/* 638 */       javax.xml.soap.Node el = (javax.xml.soap.Node)it.next();
/* 639 */       el.detachNode();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean removeNamespaceDeclaration(String prefix)
/*     */   {
/* 651 */     boolean ret = getAttributeNode("xmlns:" + prefix) != null;
/* 652 */     removeAttribute("xmlns:" + prefix);
/* 653 */     return ret;
/*     */   }
/*     */ 
/*     */   public String getEncodingStyle()
/*     */   {
/* 663 */     String encodingStyle = getAttribute("env:encodingStyle");
/* 664 */     return encodingStyle.length() > 0 ? encodingStyle : null;
/*     */   }
/*     */ 
/*     */   public void setEncodingStyle(String encodingStyle)
/*     */     throws SOAPException
/*     */   {
/* 679 */     String namespaceURI = getNamespaceURI("env");
/* 680 */     NameImpl name = new NameImpl("encodingStyle", "env", namespaceURI);
/* 681 */     addAttribute(name, encodingStyle);
/*     */   }
/*     */ 
/*     */   public String getTagName()
/*     */   {
/* 686 */     return this.element.getTagName();
/*     */   }
/*     */ 
/*     */   public void removeAttribute(String name) throws DOMException
/*     */   {
/* 691 */     this.element.removeAttribute(name);
/*     */   }
/*     */ 
/*     */   public boolean hasAttribute(String name)
/*     */   {
/* 696 */     return this.element.hasAttribute(name);
/*     */   }
/*     */ 
/*     */   public String getAttribute(String name)
/*     */   {
/* 701 */     return this.element.getAttribute(name);
/*     */   }
/*     */ 
/*     */   public void removeAttributeNS(String namespaceURI, String localName) throws DOMException
/*     */   {
/* 706 */     this.element.removeAttributeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public void setAttribute(String name, String value) throws DOMException
/*     */   {
/* 711 */     this.element.setAttribute(name, value);
/*     */   }
/*     */ 
/*     */   public boolean hasAttributeNS(String namespaceURI, String localName)
/*     */   {
/* 716 */     return this.element.hasAttributeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public Attr getAttributeNode(String name)
/*     */   {
/* 721 */     Attr attr = this.element.getAttributeNode(name);
/*     */ 
/* 723 */     return attr == null ? null : new AttrImpl(this, attr);
/*     */   }
/*     */ 
/*     */   public Attr removeAttributeNode(Attr oldAttr) throws DOMException
/*     */   {
/* 728 */     return this.element.removeAttributeNode(oldAttr);
/*     */   }
/*     */ 
/*     */   public Attr setAttributeNode(Attr newAttr) throws DOMException
/*     */   {
/* 733 */     return this.element.setAttributeNode(newAttr);
/*     */   }
/*     */ 
/*     */   public Attr setAttributeNodeNS(Attr newAttr) throws DOMException
/*     */   {
/* 738 */     return this.element.setAttributeNodeNS(newAttr);
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagName(String name)
/*     */   {
/* 743 */     return new NodeListImpl(DOMUtils.getChildElements(this, name));
/*     */   }
/*     */ 
/*     */   public String getAttributeNS(String namespaceURI, String localName)
/*     */   {
/* 748 */     return this.element.getAttributeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException
/*     */   {
/* 753 */     this.element.setAttributeNS(namespaceURI, qualifiedName, value);
/*     */   }
/*     */ 
/*     */   public Attr getAttributeNodeNS(String namespaceURI, String localName)
/*     */   {
/* 762 */     Attr attr = this.element.getAttributeNodeNS(namespaceURI, localName);
/*     */ 
/* 764 */     return attr == null ? null : new AttrImpl(this, attr);
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagNameNS(String namespaceURI, String localName)
/*     */   {
/* 769 */     return new NodeListImpl(DOMUtils.getChildElements(this, new QName(namespaceURI, localName)));
/*     */   }
/*     */ 
/*     */   public TypeInfo getSchemaTypeInfo()
/*     */   {
/* 774 */     throw new NotImplementedException("getSchemaTypeInfo");
/*     */   }
/*     */ 
/*     */   public void setIdAttribute(String name, boolean isId) throws DOMException
/*     */   {
/* 779 */     throw new NotImplementedException("setIdAttribute");
/*     */   }
/*     */ 
/*     */   public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException
/*     */   {
/* 784 */     throw new NotImplementedException("setIdAttributeNode");
/*     */   }
/*     */ 
/*     */   public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException
/*     */   {
/* 789 */     throw new NotImplementedException("setIdAttributeNS");
/*     */   }
/*     */ 
/*     */   public void accept(SAAJVisitor visitor)
/*     */   {
/* 794 */     visitor.visitSOAPElement(this);
/*     */   }
/*     */ 
/*     */   public void writeElement(Writer writer)
/*     */     throws IOException
/*     */   {
/* 803 */     String qualName = getElementName().getQualifiedName();
/* 804 */     writer.write("<" + qualName);
/*     */ 
/* 807 */     Iterator nsPrefixes = getNamespacePrefixes();
/* 808 */     while (nsPrefixes.hasNext())
/*     */     {
/* 810 */       String prefix = (String)nsPrefixes.next();
/* 811 */       writer.write(" xmlns:" + prefix + "='" + getNamespaceURI(prefix) + "'");
/*     */     }
/*     */ 
/* 815 */     Iterator attNames = getAllAttributes();
/* 816 */     while (attNames.hasNext())
/*     */     {
/* 818 */       NameImpl name = (NameImpl)attNames.next();
/* 819 */       String attPrefix = name.getPrefix() != null ? name.getPrefix() : "";
/* 820 */       String attFqn = attPrefix.length() > 0 ? attPrefix + ":" + name.getLocalName() : name.getLocalName();
/* 821 */       writer.write(" " + attFqn + "='" + getAttributeValue(name) + "'");
/*     */     }
/* 823 */     writer.write(">");
/*     */ 
/* 825 */     writeElementContent(writer);
/*     */ 
/* 827 */     writer.write("</" + qualName + ">");
/*     */   }
/*     */ 
/*     */   protected void writeElementContent(Writer out) throws IOException
/*     */   {
/* 832 */     Iterator it = getChildElements();
/* 833 */     if (it.hasNext())
/*     */     {
/* 835 */       while (it.hasNext())
/*     */       {
/* 837 */         javax.xml.soap.Node node = (javax.xml.soap.Node)it.next();
/* 838 */         if ((node instanceof SOAPElementImpl))
/*     */         {
/* 840 */           ((SOAPElementImpl)node).writeElement(out);
/*     */         }
/* 842 */         else if ((node instanceof TextImpl))
/*     */         {
/* 844 */           ((TextImpl)node).writeNode(out);
/*     */         }
/*     */         else
/*     */         {
/* 848 */           throw new WSException("Unhandled soap node: " + node.getClass().getName());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 854 */     String value = getValue();
/* 855 */     if (value != null)
/* 856 */       out.write(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPElementImpl
 * JD-Core Version:    0.6.0
 */