/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.CDATASection;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.DOMConfiguration;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.DOMImplementation;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.DocumentFragment;
/*     */ import org.w3c.dom.DocumentType;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.EntityReference;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.ProcessingInstruction;
/*     */ import org.w3c.dom.Text;
/*     */ import org.w3c.dom.UserDataHandler;
/*     */ 
/*     */ public class SOAPDocument
/*     */   implements Document
/*     */ {
/*  55 */   private Document doc = DOMUtils.getOwnerDocument();
/*     */ 
/*     */   public DocumentType getDoctype()
/*     */   {
/*  61 */     return this.doc.getDoctype();
/*     */   }
/*     */ 
/*     */   public DOMImplementation getImplementation()
/*     */   {
/*  67 */     return this.doc.getImplementation();
/*     */   }
/*     */ 
/*     */   public Element getDocumentElement()
/*     */   {
/*  73 */     return null;
/*     */   }
/*     */ 
/*     */   public Element createElement(String tagName) throws DOMException
/*     */   {
/*  78 */     return new SOAPElementImpl(tagName);
/*     */   }
/*     */ 
/*     */   public DocumentFragment createDocumentFragment()
/*     */   {
/*  83 */     return this.doc.createDocumentFragment();
/*     */   }
/*     */ 
/*     */   public Text createTextNode(String data)
/*     */   {
/*  88 */     return this.doc.createTextNode(data);
/*     */   }
/*     */ 
/*     */   public Comment createComment(String data)
/*     */   {
/*  93 */     return this.doc.createComment(data);
/*     */   }
/*     */ 
/*     */   public CDATASection createCDATASection(String data) throws DOMException
/*     */   {
/*  98 */     return this.doc.createCDATASection(data);
/*     */   }
/*     */ 
/*     */   public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException
/*     */   {
/* 103 */     return this.doc.createProcessingInstruction(target, data);
/*     */   }
/*     */ 
/*     */   public Attr createAttribute(String name) throws DOMException
/*     */   {
/* 108 */     return this.doc.createAttribute(name);
/*     */   }
/*     */ 
/*     */   public EntityReference createEntityReference(String name)
/*     */     throws DOMException
/*     */   {
/* 114 */     return null;
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagName(String tagname)
/*     */   {
/* 120 */     return null;
/*     */   }
/*     */ 
/*     */   public Node importNode(Node importedNode, boolean deep)
/*     */     throws DOMException
/*     */   {
/* 126 */     return this.doc.importNode(importedNode, deep);
/*     */   }
/*     */ 
/*     */   public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException
/*     */   {
/* 131 */     int loc = qualifiedName.indexOf(":");
/*     */ 
/* 133 */     if (loc == -1) {
/* 134 */       return new SOAPElementImpl(qualifiedName, null, namespaceURI);
/*     */     }
/* 136 */     if (loc == qualifiedName.length() - 1) {
/* 137 */       throw new IllegalArgumentException("Invalid qualified name");
/*     */     }
/* 139 */     return new SOAPElementImpl(qualifiedName.substring(loc + 1), qualifiedName.substring(0, loc), namespaceURI);
/*     */   }
/*     */ 
/*     */   public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException
/*     */   {
/* 144 */     return this.doc.createAttributeNS(namespaceURI, qualifiedName);
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagNameNS(String namespaceURI, String localName)
/*     */   {
/* 150 */     return null;
/*     */   }
/*     */ 
/*     */   public Element getElementById(String elementId)
/*     */   {
/* 156 */     return null;
/*     */   }
/*     */ 
/*     */   public String getNodeName()
/*     */   {
/* 162 */     return this.doc.getNodeName();
/*     */   }
/*     */ 
/*     */   public String getNodeValue() throws DOMException
/*     */   {
/* 167 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public void setNodeValue(String nodeValue) throws DOMException
/*     */   {
/* 172 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public short getNodeType()
/*     */   {
/* 177 */     return this.doc.getNodeType();
/*     */   }
/*     */ 
/*     */   public Node getParentNode()
/*     */   {
/* 182 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public NodeList getChildNodes()
/*     */   {
/* 187 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node getFirstChild()
/*     */   {
/* 192 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node getLastChild()
/*     */   {
/* 197 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node getPreviousSibling()
/*     */   {
/* 202 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node getNextSibling()
/*     */   {
/* 207 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public NamedNodeMap getAttributes()
/*     */   {
/* 212 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Document getOwnerDocument()
/*     */   {
/* 217 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node insertBefore(Node newChild, Node refChild) throws DOMException
/*     */   {
/* 222 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node replaceChild(Node newChild, Node oldChild) throws DOMException
/*     */   {
/* 227 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node removeChild(Node oldChild) throws DOMException
/*     */   {
/* 232 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node appendChild(Node newChild) throws DOMException
/*     */   {
/* 237 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public boolean hasChildNodes()
/*     */   {
/* 242 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public Node cloneNode(boolean deep)
/*     */   {
/* 247 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public void normalize()
/*     */   {
/* 252 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public boolean isSupported(String feature, String version)
/*     */   {
/* 257 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI()
/*     */   {
/* 262 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public String getPrefix()
/*     */   {
/* 267 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public void setPrefix(String prefix) throws DOMException
/*     */   {
/* 272 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public String getLocalName()
/*     */   {
/* 277 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public boolean hasAttributes()
/*     */   {
/* 282 */     throw new DOMException(9, "Node operations not allowed on SOAPDocument");
/*     */   }
/*     */ 
/*     */   public String getInputEncoding()
/*     */   {
/* 290 */     return null;
/*     */   }
/*     */ 
/*     */   public String getXmlEncoding()
/*     */   {
/* 296 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean getXmlStandalone()
/*     */   {
/* 302 */     return false;
/*     */   }
/*     */ 
/*     */   public void setXmlStandalone(boolean arg0)
/*     */     throws DOMException
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getXmlVersion()
/*     */   {
/* 313 */     return null;
/*     */   }
/*     */ 
/*     */   public void setXmlVersion(String arg0)
/*     */     throws DOMException
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean getStrictErrorChecking()
/*     */   {
/* 324 */     return false;
/*     */   }
/*     */ 
/*     */   public void setStrictErrorChecking(boolean arg0)
/*     */   {
/*     */   }
/*     */ 
/*     */   public String getDocumentURI()
/*     */   {
/* 336 */     return null;
/*     */   }
/*     */ 
/*     */   public void setDocumentURI(String arg0)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Node adoptNode(Node arg0)
/*     */     throws DOMException
/*     */   {
/* 348 */     return null;
/*     */   }
/*     */ 
/*     */   public DOMConfiguration getDomConfig()
/*     */   {
/* 354 */     return null;
/*     */   }
/*     */ 
/*     */   public void normalizeDocument()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Node renameNode(Node arg0, String arg1, String arg2)
/*     */     throws DOMException
/*     */   {
/* 366 */     return null;
/*     */   }
/*     */ 
/*     */   public String getBaseURI()
/*     */   {
/* 372 */     return null;
/*     */   }
/*     */ 
/*     */   public short compareDocumentPosition(Node arg0)
/*     */     throws DOMException
/*     */   {
/* 378 */     return 0;
/*     */   }
/*     */ 
/*     */   public String getTextContent()
/*     */     throws DOMException
/*     */   {
/* 384 */     return null;
/*     */   }
/*     */ 
/*     */   public void setTextContent(String arg0)
/*     */     throws DOMException
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isSameNode(Node arg0)
/*     */   {
/* 396 */     return false;
/*     */   }
/*     */ 
/*     */   public String lookupPrefix(String arg0)
/*     */   {
/* 402 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isDefaultNamespace(String arg0)
/*     */   {
/* 408 */     return false;
/*     */   }
/*     */ 
/*     */   public String lookupNamespaceURI(String arg0)
/*     */   {
/* 414 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isEqualNode(Node arg0)
/*     */   {
/* 420 */     return false;
/*     */   }
/*     */ 
/*     */   public Object getFeature(String arg0, String arg1)
/*     */   {
/* 426 */     return null;
/*     */   }
/*     */ 
/*     */   public Object setUserData(String arg0, Object arg1, UserDataHandler arg2)
/*     */   {
/* 432 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getUserData(String arg0)
/*     */   {
/* 438 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPDocument
 * JD-Core Version:    0.6.0
 */