/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.TypeInfo;
/*     */ 
/*     */ public class SOAPContentElement extends SOAPElementImpl
/*     */   implements SOAPContentAccess
/*     */ {
/*  75 */   private static Logger log = Logger.getLogger(SOAPContentElement.class);
/*     */ 
/*  77 */   public static final QName GENERIC_PARAM_NAME = new QName("genericParam");
/*  78 */   public static final QName GENERIC_RETURN_NAME = new QName("genericReturn");
/*     */   private ParameterMetaData paramMetaData;
/*     */   private SOAPContent soapContent;
/*  87 */   private boolean lockDOMExpansion = false;
/*     */ 
/*     */   public SOAPContentElement(Name name)
/*     */   {
/*  93 */     super(name);
/*  94 */     this.soapContent = new DOMContent(this);
/*     */   }
/*     */ 
/*     */   public SOAPContentElement(QName qname)
/*     */   {
/*  99 */     super(qname);
/* 100 */     this.soapContent = new DOMContent(this);
/*     */   }
/*     */ 
/*     */   public SOAPContentElement(SOAPElementImpl element)
/*     */   {
/* 105 */     super(element);
/* 106 */     this.soapContent = new DOMContent(this);
/*     */   }
/*     */ 
/*     */   public ParameterMetaData getParamMetaData()
/*     */   {
/* 111 */     if (this.paramMetaData == null) {
/* 112 */       throw new IllegalStateException("Parameter meta data not available");
/*     */     }
/* 114 */     return this.paramMetaData;
/*     */   }
/*     */ 
/*     */   public void setParamMetaData(ParameterMetaData paramMetaData)
/*     */   {
/* 119 */     this.paramMetaData = paramMetaData;
/*     */   }
/*     */ 
/*     */   public QName getXmlType()
/*     */   {
/* 124 */     return getParamMetaData().getXmlType();
/*     */   }
/*     */ 
/*     */   public Class getJavaType()
/*     */   {
/* 129 */     return getParamMetaData().getJavaType();
/*     */   }
/*     */ 
/*     */   private void transitionTo(SOAPContent.State nextState)
/*     */   {
/* 134 */     if (nextState != this.soapContent.getState())
/*     */     {
/* 136 */       log.debug("-----------------------------------");
/* 137 */       log.debug("Transitioning from " + this.soapContent.getState() + " to " + nextState);
/* 138 */       this.lockDOMExpansion = true;
/*     */ 
/* 140 */       this.soapContent = this.soapContent.transitionTo(nextState);
/*     */ 
/* 142 */       this.lockDOMExpansion = false;
/* 143 */       log.debug("-----------------------------------");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Source getPayload()
/*     */   {
/* 151 */     if (this.soapContent.getState() == SOAPContent.State.OBJECT_VALID) {
/* 152 */       transitionTo(SOAPContent.State.DOM_VALID);
/*     */     }
/* 154 */     return this.soapContent.getPayload();
/*     */   }
/*     */ 
/*     */   public XMLFragment getXMLFragment()
/*     */   {
/* 159 */     transitionTo(SOAPContent.State.XML_VALID);
/* 160 */     return this.soapContent.getXMLFragment();
/*     */   }
/*     */ 
/*     */   public void setXMLFragment(XMLFragment xmlFragment)
/*     */   {
/* 165 */     this.soapContent = new XMLContent(this);
/* 166 */     this.soapContent.setXMLFragment(xmlFragment);
/*     */   }
/*     */ 
/*     */   public Object getObjectValue()
/*     */   {
/* 171 */     transitionTo(SOAPContent.State.OBJECT_VALID);
/* 172 */     return this.soapContent.getObjectValue();
/*     */   }
/*     */ 
/*     */   public void setObjectValue(Object objValue)
/*     */   {
/* 177 */     this.soapContent = new ObjectContent(this);
/* 178 */     this.soapContent.setObjectValue(objValue);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/* 185 */     log.trace("addChildElement: " + child);
/* 186 */     expandToDOM();
/* 187 */     return super.addChildElement(child);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(String localName, String prefix) throws SOAPException
/*     */   {
/* 192 */     log.trace("addChildElement: [localName=" + localName + ",prefix=" + prefix + "]");
/* 193 */     expandToDOM();
/* 194 */     return super.addChildElement(localName, prefix);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException
/*     */   {
/* 199 */     log.trace("addChildElement: [localName=" + localName + ",prefix=" + prefix + ",uri=" + uri + "]");
/* 200 */     expandToDOM();
/* 201 */     return super.addChildElement(localName, prefix, uri);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(Name name) throws SOAPException
/*     */   {
/* 206 */     log.trace("addChildElement: [name=" + name + "]");
/* 207 */     expandToDOM();
/* 208 */     return super.addChildElement(name);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(String name) throws SOAPException
/*     */   {
/* 213 */     log.trace("addChildElement: [name=" + name + "]");
/* 214 */     expandToDOM();
/* 215 */     return super.addChildElement(name);
/*     */   }
/*     */ 
/*     */   public SOAPElement addTextNode(String value) throws SOAPException
/*     */   {
/* 220 */     log.trace("addTextNode: [value=" + value + "]");
/* 221 */     expandToDOM();
/* 222 */     return super.addTextNode(value);
/*     */   }
/*     */ 
/*     */   public Iterator getChildElements()
/*     */   {
/* 227 */     log.trace("getChildElements");
/* 228 */     expandToDOM();
/* 229 */     return super.getChildElements();
/*     */   }
/*     */ 
/*     */   public Iterator getChildElements(Name name)
/*     */   {
/* 234 */     log.trace("getChildElements: [name=" + name + "]");
/* 235 */     expandToDOM();
/* 236 */     return super.getChildElements(name);
/*     */   }
/*     */ 
/*     */   public void removeContents()
/*     */   {
/* 241 */     log.trace("removeContents");
/* 242 */     expandToDOM();
/* 243 */     super.removeContents();
/*     */   }
/*     */ 
/*     */   public Iterator getAllAttributes()
/*     */   {
/* 248 */     return super.getAllAttributes();
/*     */   }
/*     */ 
/*     */   public String getAttribute(String name)
/*     */   {
/* 253 */     return super.getAttribute(name);
/*     */   }
/*     */ 
/*     */   public Attr getAttributeNode(String name)
/*     */   {
/* 258 */     return super.getAttributeNode(name);
/*     */   }
/*     */ 
/*     */   public Attr getAttributeNodeNS(String namespaceURI, String localName)
/*     */   {
/* 263 */     return super.getAttributeNodeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public String getAttributeNS(String namespaceURI, String localName)
/*     */   {
/* 268 */     return super.getAttributeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public String getAttributeValue(Name name)
/*     */   {
/* 273 */     return super.getAttributeValue(name);
/*     */   }
/*     */ 
/*     */   public SOAPElement addAttribute(Name name, String value) throws SOAPException
/*     */   {
/* 278 */     log.trace("addAttribute: [name=" + name + ",value=" + value + "]");
/* 279 */     expandToDOM();
/* 280 */     return super.addAttribute(name, value);
/*     */   }
/*     */ 
/*     */   public SOAPElement addNamespaceDeclaration(String prefix, String nsURI)
/*     */   {
/* 285 */     log.trace("addNamespaceDeclaration: [prefix=" + prefix + ",nsURI=" + nsURI + "]");
/* 286 */     expandToDOM();
/* 287 */     return super.addNamespaceDeclaration(prefix, nsURI);
/*     */   }
/*     */ 
/*     */   public Name getElementName()
/*     */   {
/* 292 */     return super.getElementName();
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagName(String name)
/*     */   {
/* 297 */     log.trace("getElementsByTagName: [name=" + name + "]");
/* 298 */     expandToDOM();
/* 299 */     return super.getElementsByTagName(name);
/*     */   }
/*     */ 
/*     */   public NodeList getElementsByTagNameNS(String namespaceURI, String localName)
/*     */   {
/* 304 */     log.trace("getElementsByTagName: [nsURI=" + namespaceURI + ",localName=" + localName + "]");
/* 305 */     expandToDOM();
/* 306 */     return super.getElementsByTagNameNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public String getEncodingStyle()
/*     */   {
/* 311 */     return super.getEncodingStyle();
/*     */   }
/*     */ 
/*     */   public Iterator getNamespacePrefixes()
/*     */   {
/* 316 */     return super.getNamespacePrefixes();
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI(String prefix)
/*     */   {
/* 321 */     return super.getNamespaceURI(prefix);
/*     */   }
/*     */ 
/*     */   public TypeInfo getSchemaTypeInfo()
/*     */   {
/* 326 */     return super.getSchemaTypeInfo();
/*     */   }
/*     */ 
/*     */   public String getTagName()
/*     */   {
/* 331 */     return super.getTagName();
/*     */   }
/*     */ 
/*     */   public Iterator getVisibleNamespacePrefixes()
/*     */   {
/* 336 */     return super.getVisibleNamespacePrefixes();
/*     */   }
/*     */ 
/*     */   public boolean hasAttribute(String name)
/*     */   {
/* 341 */     return super.hasAttribute(name);
/*     */   }
/*     */ 
/*     */   public boolean hasAttributeNS(String namespaceURI, String localName)
/*     */   {
/* 346 */     return super.hasAttributeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public boolean removeAttribute(Name name)
/*     */   {
/* 351 */     log.trace("removeAttribute: " + name.getQualifiedName());
/* 352 */     expandToDOM();
/* 353 */     return super.removeAttribute(name);
/*     */   }
/*     */ 
/*     */   public void removeAttribute(String name) throws DOMException
/*     */   {
/* 358 */     log.trace("removeAttribute: " + name);
/* 359 */     expandToDOM();
/* 360 */     super.removeAttribute(name);
/*     */   }
/*     */ 
/*     */   public Attr removeAttributeNode(Attr oldAttr) throws DOMException
/*     */   {
/* 365 */     log.trace("removeAttribute: " + oldAttr.getNodeName());
/* 366 */     expandToDOM();
/* 367 */     return super.removeAttributeNode(oldAttr);
/*     */   }
/*     */ 
/*     */   public void removeAttributeNS(String namespaceURI, String localName) throws DOMException
/*     */   {
/* 372 */     log.trace("removeAttributeNS: {" + namespaceURI + "}" + localName);
/* 373 */     expandToDOM();
/* 374 */     super.removeAttributeNS(namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public boolean removeNamespaceDeclaration(String prefix)
/*     */   {
/* 379 */     log.trace("removeNamespaceDeclaration: " + prefix);
/* 380 */     expandToDOM();
/* 381 */     return super.removeNamespaceDeclaration(prefix);
/*     */   }
/*     */ 
/*     */   public void setAttribute(String name, String value) throws DOMException
/*     */   {
/* 386 */     log.trace("setAttribute: [name=" + name + ",value=" + value + "]");
/* 387 */     expandToDOM();
/* 388 */     super.setAttribute(name, value);
/*     */   }
/*     */ 
/*     */   public Attr setAttributeNode(Attr newAttr) throws DOMException
/*     */   {
/* 393 */     log.trace("setAttributeNode: " + newAttr);
/* 394 */     expandToDOM();
/* 395 */     return super.setAttributeNode(newAttr);
/*     */   }
/*     */ 
/*     */   public Attr setAttributeNodeNS(Attr newAttr) throws DOMException
/*     */   {
/* 400 */     log.trace("setAttributeNodeNS: " + newAttr);
/* 401 */     expandToDOM();
/* 402 */     return super.setAttributeNodeNS(newAttr);
/*     */   }
/*     */ 
/*     */   public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException
/*     */   {
/* 407 */     log.trace("setAttribute: [nsURI=" + namespaceURI + ",name=" + qualifiedName + ",value=" + value + "]");
/* 408 */     expandToDOM();
/* 409 */     super.setAttributeNS(namespaceURI, qualifiedName, value);
/*     */   }
/*     */ 
/*     */   public void setIdAttribute(String name, boolean isId) throws DOMException
/*     */   {
/* 414 */     log.trace("setIdAttribute: [name=" + name + ",value=" + isId + "]");
/* 415 */     expandToDOM();
/* 416 */     super.setIdAttribute(name, isId);
/*     */   }
/*     */ 
/*     */   public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException
/*     */   {
/* 421 */     log.trace("setIdAttributeNode: [idAttr=" + idAttr + ",value=" + isId + "]");
/* 422 */     expandToDOM();
/* 423 */     super.setIdAttributeNode(idAttr, isId);
/*     */   }
/*     */ 
/*     */   public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException
/*     */   {
/* 428 */     log.trace("setIdAttributeNS: [nsURI=" + namespaceURI + ",name=" + localName + ",value=" + isId + "]");
/* 429 */     expandToDOM();
/* 430 */     super.setIdAttributeNS(namespaceURI, localName, isId);
/*     */   }
/*     */ 
/*     */   public Node appendChild(Node newChild)
/*     */     throws DOMException
/*     */   {
/* 437 */     log.trace("appendChild: " + newChild);
/* 438 */     expandToDOM();
/* 439 */     return super.appendChild(newChild);
/*     */   }
/*     */ 
/*     */   public Node cloneNode(boolean deep)
/*     */   {
/* 444 */     log.trace("cloneNode: deep=" + deep);
/* 445 */     expandToDOM();
/* 446 */     return super.cloneNode(deep);
/*     */   }
/*     */ 
/*     */   public NodeList getChildNodes()
/*     */   {
/* 451 */     log.trace("getChildNodes");
/* 452 */     expandToDOM();
/* 453 */     return super.getChildNodes();
/*     */   }
/*     */ 
/*     */   public Node getFirstChild()
/*     */   {
/* 458 */     log.trace("getFirstChild");
/* 459 */     expandToDOM();
/* 460 */     return super.getFirstChild();
/*     */   }
/*     */ 
/*     */   public Node getLastChild()
/*     */   {
/* 465 */     log.trace("getLastChild");
/* 466 */     expandToDOM();
/* 467 */     return super.getLastChild();
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 472 */     log.trace("getValue");
/* 473 */     expandToDOM();
/* 474 */     return super.getValue();
/*     */   }
/*     */ 
/*     */   public boolean hasChildNodes()
/*     */   {
/* 479 */     log.trace("hasChildNodes");
/* 480 */     expandToDOM();
/* 481 */     return super.hasChildNodes();
/*     */   }
/*     */ 
/*     */   public Node removeChild(Node oldChild) throws DOMException
/*     */   {
/* 486 */     log.trace("removeChild: " + oldChild);
/* 487 */     expandToDOM();
/* 488 */     return super.removeChild(oldChild);
/*     */   }
/*     */ 
/*     */   public Node replaceChild(Node newChild, Node oldChild) throws DOMException
/*     */   {
/* 493 */     log.trace("replaceChild: [new=" + newChild + ",old=" + oldChild + "]");
/* 494 */     expandToDOM();
/* 495 */     return super.replaceChild(newChild, oldChild);
/*     */   }
/*     */ 
/*     */   private void expandToDOM()
/*     */   {
/* 500 */     if (!this.lockDOMExpansion)
/* 501 */       transitionTo(SOAPContent.State.DOM_VALID);
/*     */   }
/*     */ 
/*     */   public void setValue(String value)
/*     */   {
/* 506 */     log.trace("setValue: " + value);
/* 507 */     expandToDOM();
/* 508 */     super.setValue(value);
/*     */   }
/*     */ 
/*     */   public NamedNodeMap getAttributes()
/*     */   {
/* 513 */     return super.getAttributes();
/*     */   }
/*     */ 
/*     */   public boolean hasAttributes()
/*     */   {
/* 518 */     return super.hasAttributes();
/*     */   }
/*     */ 
/*     */   public void writeElement(Writer writer)
/*     */     throws IOException
/*     */   {
/* 525 */     if ((this.soapContent instanceof DOMContent))
/*     */     {
/* 527 */       new DOMWriter(writer).print(this);
/*     */     }
/*     */     else
/*     */     {
/* 531 */       transitionTo(SOAPContent.State.XML_VALID);
/* 532 */       this.soapContent.getXMLFragment().writeTo(writer);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleMTOMTransitions()
/*     */   {
/* 552 */     if (MessageContextAssociation.peekMessageContext() == null) {
/* 553 */       return;
/*     */     }
/*     */ 
/* 556 */     if (!isXOPParameter()) {
/* 557 */       return;
/*     */     }
/* 559 */     boolean domContentState = this.soapContent instanceof DOMContent;
/*     */ 
/* 561 */     if (!XOPContext.isMTOMEnabled())
/*     */     {
/* 567 */       log.debug("MTOM disabled: Force inline XOP data");
/*     */ 
/* 570 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 571 */       msgContext.put(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/* 572 */       if ((msgContext instanceof MessageContextJAXWS)) {
/* 573 */         ((MessageContextJAXWS)msgContext).setScope(CommonMessageContext.ALLOW_EXPAND_TO_DOM, MessageContext.Scope.APPLICATION);
/*     */       }
/* 575 */       expandToDOM();
/*     */     }
/* 577 */     else if ((domContentState) && (XOPContext.isMTOMEnabled()))
/*     */     {
/* 583 */       log.debug("MTOM enabled: Restore XOP data");
/* 584 */       XOPContext.restoreXOPDataDOM(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   boolean isXOPParameter()
/*     */   {
/* 590 */     return (this.paramMetaData != null) && (this.paramMetaData.isXOP());
/*     */   }
/*     */ 
/*     */   public void accept(SAAJVisitor visitor)
/*     */   {
/* 595 */     visitor.visitSOAPContentElement(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPContentElement
 * JD-Core Version:    0.6.0
 */