/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import javax.xml.soap.SOAPConnection;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.client.RemotingConnectionImpl;
/*     */ import org.jboss.ws.core.client.SOAPRemotingConnection;
/*     */ 
/*     */ public class SOAPConnectionImpl extends SOAPConnection
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(SOAPConnectionImpl.class);
/*     */   private RemotingConnectionImpl remotingConnection;
/*     */ 
/*     */   public SOAPConnectionImpl()
/*     */   {
/*  54 */     this.remotingConnection = new SOAPRemotingConnection();
/*     */   }
/*     */ 
/*     */   public SOAPMessage call(SOAPMessage reqMessage, Object endpoint)
/*     */     throws SOAPException
/*     */   {
/*  63 */     if (reqMessage == null) {
/*  64 */       throw new IllegalArgumentException("Given SOAPMessage cannot be null");
/*     */     }
/*  66 */     MessageAbstraction resMessage = callInternal(reqMessage, endpoint, false);
/*  67 */     return (SOAPMessage)resMessage;
/*     */   }
/*     */ 
/*     */   public SOAPMessage get(Object endpoint)
/*     */     throws SOAPException
/*     */   {
/*  75 */     MessageAbstraction resMessage = callInternal(null, endpoint, false);
/*  76 */     return (SOAPMessage)resMessage;
/*     */   }
/*     */ 
/*     */   public SOAPMessage callOneWay(SOAPMessage reqMessage, Object endpoint)
/*     */     throws SOAPException
/*     */   {
/*  85 */     if (reqMessage == null) {
/*  86 */       throw new IllegalArgumentException("Given SOAPMessage cannot be null");
/*     */     }
/*  88 */     MessageAbstraction resMessage = callInternal((SOAPMessageImpl)reqMessage, endpoint, true);
/*  89 */     return (SOAPMessage)resMessage;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws SOAPException
/*     */   {
/*  96 */     if (this.remotingConnection.isClosed()) {
/*  97 */       throw new SOAPException("SOAPConnection is already closed");
/*     */     }
/*  99 */     this.remotingConnection.setClosed(true);
/*     */   }
/*     */ 
/*     */   private MessageAbstraction callInternal(SOAPMessage reqMessage, Object endpoint, boolean oneway) throws SOAPException
/*     */   {
/*     */     try
/*     */     {
/* 106 */       MessageAbstraction resMessage = this.remotingConnection.invoke((SOAPMessageImpl)reqMessage, endpoint, oneway);
/* 107 */       return resMessage;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 111 */       Throwable cause = ex.getCause();
/* 112 */       if ((cause instanceof SOAPException))
/* 113 */         throw ((SOAPException)cause);
/*     */     }
/* 115 */     throw new SOAPException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPConnectionImpl
 * JD-Core Version:    0.6.0
 */