/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Locale;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.Text;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Comment;
/*     */ import org.w3c.dom.DOMException;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.DocumentFragment;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class SOAPBodyImpl extends SOAPElementImpl
/*     */   implements SOAPBody
/*     */ {
/*  60 */   private static Logger log = Logger.getLogger(SOAPBodyImpl.class);
/*     */ 
/*     */   public SOAPBodyImpl(String prefix, String namespace)
/*     */   {
/*  64 */     super("Body", prefix, namespace);
/*     */   }
/*     */ 
/*     */   public SOAPElement addChildElement(SOAPElement child)
/*     */     throws SOAPException
/*     */   {
/*  70 */     log.trace("addChildElement: " + child.getElementName());
/*     */ 
/*  72 */     if (!(child instanceof SOAPBodyElement)) {
/*  73 */       child = convertToBodyElement(child);
/*     */     }
/*  75 */     child = super.addChildElement(child);
/*  76 */     return child;
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement addBodyElement(Name name) throws SOAPException
/*     */   {
/*  81 */     log.trace("addBodyElement: " + name);
/*  82 */     SOAPBodyElement child = new SOAPBodyElementDoc(name);
/*  83 */     return (SOAPBodyElement)addChildElement(child);
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement addBodyElement(QName qname) throws SOAPException
/*     */   {
/*  88 */     log.trace("addBodyElement: " + qname);
/*  89 */     SOAPBodyElement child = new SOAPBodyElementDoc(qname);
/*  90 */     return (SOAPBodyElement)addChildElement(child);
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement addDocument(Document doc) throws SOAPException
/*     */   {
/*  95 */     log.trace("addDocument");
/*  96 */     Element rootElement = doc.getDocumentElement();
/*  97 */     SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/*  98 */     SOAPElement soapElement = soapFactory.createElement(rootElement);
/*  99 */     return (SOAPBodyElement)addChildElement(soapElement);
/*     */   }
/*     */ 
/*     */   public SOAPFault addFault() throws SOAPException
/*     */   {
/* 104 */     log.trace("addFault");
/* 105 */     if (hasFault()) {
/* 106 */       throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
/*     */     }
/* 108 */     SOAPFaultImpl soapFault = new SOAPFaultImpl(getPrefix(), getNamespaceURI());
/* 109 */     soapFault = (SOAPFaultImpl)addChildElement(soapFault);
/* 110 */     soapFault.setFaultCode(soapFault.getDefaultFaultCode());
/* 111 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public SOAPFault addFault(Name faultCode, String faultString) throws SOAPException
/*     */   {
/* 116 */     log.trace("addFault");
/* 117 */     if (hasFault()) {
/* 118 */       throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
/*     */     }
/* 120 */     SOAPFaultImpl soapFault = new SOAPFaultImpl(getPrefix(), getNamespaceURI());
/* 121 */     soapFault = (SOAPFaultImpl)addChildElement(soapFault);
/* 122 */     soapFault.setFaultCode(faultCode);
/* 123 */     soapFault.setFaultString(faultString);
/* 124 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public SOAPFault addFault(QName faultCode, String faultString) throws SOAPException
/*     */   {
/* 129 */     log.trace("addFault");
/* 130 */     if (hasFault()) {
/* 131 */       throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
/*     */     }
/* 133 */     SOAPFaultImpl soapFault = new SOAPFaultImpl(getPrefix(), getNamespaceURI());
/* 134 */     soapFault = (SOAPFaultImpl)addChildElement(soapFault);
/* 135 */     soapFault.setFaultCode(faultCode);
/* 136 */     soapFault.setFaultString(faultString);
/* 137 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public SOAPFault addFault(Name faultCode, String faultString, Locale locale) throws SOAPException
/*     */   {
/* 142 */     log.trace("addFault");
/* 143 */     if (hasFault()) {
/* 144 */       throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
/*     */     }
/* 146 */     SOAPFaultImpl soapFault = new SOAPFaultImpl(getPrefix(), getNamespaceURI());
/* 147 */     soapFault.setFaultCode(faultCode);
/* 148 */     soapFault.setFaultString(faultString, locale);
/* 149 */     addChildElement(soapFault);
/* 150 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public SOAPFault addFault(QName faultCode, String faultString, Locale locale) throws SOAPException
/*     */   {
/* 155 */     log.trace("addFault");
/* 156 */     if (hasFault()) {
/* 157 */       throw new SOAPException("A SOAPBody may contain at most one SOAPFault child element");
/*     */     }
/* 159 */     SOAPFaultImpl soapFault = new SOAPFaultImpl(getPrefix(), getNamespaceURI());
/* 160 */     soapFault.setFaultCode(faultCode);
/* 161 */     soapFault.setFaultString(faultString, locale);
/* 162 */     addChildElement(soapFault);
/* 163 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public SOAPFault getFault()
/*     */   {
/* 168 */     log.trace("getFault");
/* 169 */     Iterator it = faultIterator();
/* 170 */     SOAPFault soapFault = it.hasNext() ? (SOAPFault)it.next() : null;
/* 171 */     return soapFault;
/*     */   }
/*     */ 
/*     */   public boolean hasFault()
/*     */   {
/* 176 */     log.trace("hasFault");
/* 177 */     return faultIterator().hasNext();
/*     */   }
/*     */ 
/*     */   private Iterator faultIterator()
/*     */   {
/* 182 */     return getChildElements(new QName(getNamespaceURI(), "Fault"));
/*     */   }
/*     */ 
/*     */   public SOAPBodyElement getBodyElement()
/*     */   {
/* 187 */     SOAPBodyElement bodyElement = null;
/* 188 */     Iterator it = getChildElements();
/* 189 */     while ((bodyElement == null) && (it.hasNext()))
/*     */     {
/* 191 */       Object next = it.next();
/* 192 */       if ((next instanceof SOAPBodyElement))
/* 193 */         bodyElement = (SOAPBodyElement)next;
/*     */     }
/* 195 */     return bodyElement;
/*     */   }
/*     */ 
/*     */   public Node appendChild(Node newChild) throws DOMException
/*     */   {
/* 200 */     log.trace("appendChild: " + newChild.getNodeName());
/* 201 */     if (needsConversionToBodyElement(newChild)) {
/* 202 */       newChild = convertToBodyElement(newChild);
/*     */     }
/* 204 */     return super.appendChild(newChild);
/*     */   }
/*     */ 
/*     */   public Node insertBefore(Node newChild, Node refChild) throws DOMException
/*     */   {
/* 209 */     log.trace("insertBefore: " + newChild.getNodeName());
/* 210 */     if (needsConversionToBodyElement(newChild)) {
/* 211 */       newChild = convertToBodyElement(newChild);
/*     */     }
/* 213 */     return super.insertBefore(newChild, refChild);
/*     */   }
/*     */ 
/*     */   public Node replaceChild(Node newChild, Node oldChild) throws DOMException
/*     */   {
/* 218 */     log.trace("replaceChild: " + newChild.getNodeName());
/* 219 */     if (needsConversionToBodyElement(newChild)) {
/* 220 */       newChild = convertToBodyElement(newChild);
/*     */     }
/* 222 */     return super.replaceChild(newChild, oldChild);
/*     */   }
/*     */ 
/*     */   public SOAPElement addAttribute(Name name, String value)
/*     */     throws SOAPException
/*     */   {
/* 228 */     String envNamespace = getNamespaceURI();
/* 229 */     if (("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace)) && (name.equals(new NameImpl("encodingStyle", "env", envNamespace)))) {
/* 230 */       throw new SOAPException("Cannot set encodingStyle on: " + getElementQName());
/*     */     }
/* 232 */     return super.addAttribute(name, value);
/*     */   }
/*     */ 
/*     */   public Document extractContentAsDocument() throws SOAPException
/*     */   {
/* 237 */     log.trace("extractContentAsDocument");
/*     */ 
/* 239 */     Iterator childElements = getChildElements();
/*     */ 
/* 242 */     if (!childElements.hasNext()) {
/* 243 */       throw new SOAPException("Cannot find SOAPBodyElement");
/*     */     }
/* 245 */     SOAPElementImpl childElement = (SOAPElementImpl)childElements.next();
/*     */ 
/* 248 */     if (childElements.hasNext()) {
/* 249 */       throw new SOAPException("Multiple SOAPBodyElement");
/*     */     }
/* 251 */     if ((childElement instanceof SOAPContentElement))
/*     */     {
/* 254 */       SOAPContentElement contentElement = (SOAPContentElement)childElement;
/*     */ 
/* 256 */       contentElement.getPayload();
/*     */     }
/*     */ 
/* 260 */     childElement.detachNode();
/*     */ 
/* 264 */     Document newDocument = DOMUtils.getDocumentBuilder().newDocument();
/* 265 */     Node adoptedElement = newDocument.adoptNode(childElement.domNode);
/* 266 */     newDocument.appendChild(adoptedElement);
/*     */ 
/* 268 */     return newDocument;
/*     */   }
/*     */ 
/*     */   private static boolean needsConversionToBodyElement(Node newChild)
/*     */   {
/* 274 */     boolean validChild = newChild instanceof SOAPBodyElement;
/* 275 */     validChild = (validChild) || ((newChild instanceof DocumentFragment));
/* 276 */     validChild = (validChild) || ((newChild instanceof Text));
/* 277 */     validChild = (validChild) || ((newChild instanceof Comment));
/* 278 */     return !validChild;
/*     */   }
/*     */ 
/*     */   private static SOAPBodyElementDoc convertToBodyElement(Node node)
/*     */   {
/* 283 */     if (!(node instanceof SOAPElementImpl)) {
/* 284 */       throw new IllegalArgumentException("SOAPElement expected");
/*     */     }
/* 286 */     SOAPElementImpl element = (SOAPElementImpl)node;
/* 287 */     element.detachNode();
/* 288 */     return new SOAPBodyElementDoc(element);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.SOAPBodyImpl
 * JD-Core Version:    0.6.0
 */