/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.binding.AbstractSerializerFactory;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.SerializerSupport;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.binding.NullValueSerializer;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ObjectContent extends SOAPContent
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(ObjectContent.class);
/*     */   private Object objectValue;
/*     */ 
/*     */   protected ObjectContent(SOAPContentElement container)
/*     */   {
/*  58 */     super(container);
/*     */   }
/*     */ 
/*     */   SOAPContent.State getState()
/*     */   {
/*  63 */     return SOAPContent.State.OBJECT_VALID;
/*     */   }
/*     */ 
/*     */   SOAPContent transitionTo(SOAPContent.State nextState)
/*     */   {
/*  68 */     SOAPContent next = null;
/*     */ 
/*  70 */     if (nextState == SOAPContent.State.XML_VALID)
/*     */     {
/*  72 */       XMLFragment fragment = marshallObjectContents();
/*  73 */       XMLContent xmlValid = new XMLContent(this.container);
/*  74 */       xmlValid.setXMLFragment(fragment);
/*  75 */       next = xmlValid;
/*     */     }
/*  77 */     else if (nextState == SOAPContent.State.OBJECT_VALID)
/*     */     {
/*  79 */       next = this;
/*     */     }
/*  81 */     else if (nextState == SOAPContent.State.DOM_VALID)
/*     */     {
/*  84 */       XMLFragment fragment = marshallObjectContents();
/*  85 */       XMLContent tmp = new XMLContent(this.container);
/*  86 */       tmp.setXMLFragment(fragment);
/*     */ 
/*  89 */       next = tmp.transitionTo(SOAPContent.State.DOM_VALID);
/*     */     }
/*     */     else
/*     */     {
/*  93 */       throw new IllegalArgumentException("Illegal state requested: " + nextState);
/*     */     }
/*     */ 
/*  96 */     return next;
/*     */   }
/*     */ 
/*     */   public Source getPayload()
/*     */   {
/* 101 */     throw new IllegalStateException("Payload not available");
/*     */   }
/*     */ 
/*     */   public void setPayload(Source source)
/*     */   {
/* 106 */     throw new IllegalStateException("Payload cannot be set on object content");
/*     */   }
/*     */ 
/*     */   public XMLFragment getXMLFragment()
/*     */   {
/* 112 */     throw new IllegalStateException("XMLFragment not available");
/*     */   }
/*     */ 
/*     */   public void setXMLFragment(XMLFragment xmlFragment)
/*     */   {
/* 117 */     throw new IllegalStateException("XMLFragment not available");
/*     */   }
/*     */ 
/*     */   public Object getObjectValue()
/*     */   {
/* 122 */     return this.objectValue;
/*     */   }
/*     */ 
/*     */   public void setObjectValue(Object objValue)
/*     */   {
/* 127 */     this.objectValue = objValue;
/*     */   }
/*     */ 
/*     */   private XMLFragment marshallObjectContents()
/*     */   {
/* 132 */     QName xmlType = this.container.getXmlType();
/* 133 */     Class javaType = this.container.getJavaType();
/*     */ 
/* 135 */     log.debug("getXMLFragment from Object [xmlType=" + xmlType + ",javaType=" + javaType + "]");
/*     */ 
/* 137 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 138 */     if (msgContext == null) {
/* 139 */       throw new WSException("MessageContext not available");
/*     */     }
/* 141 */     SerializationContext serContext = msgContext.getSerializationContext();
/* 142 */     serContext.setJavaType(javaType);
/*     */ 
/* 144 */     TypeMappingImpl typeMapping = serContext.getTypeMapping();
/* 145 */     XMLFragment xmlFragment = null;
/*     */     try
/*     */     {
/*     */       SerializerSupport ser;
/*     */       SerializerSupport ser;
/* 149 */       if (this.objectValue != null)
/*     */       {
/* 151 */         AbstractSerializerFactory serializerFactory = getSerializerFactory(typeMapping, javaType, xmlType);
/* 152 */         ser = serializerFactory.getSerializer();
/*     */       }
/*     */       else
/*     */       {
/* 156 */         ser = new NullValueSerializer();
/*     */       }
/*     */ 
/* 159 */       Result result = ser.serialize(this.container, serContext);
/*     */ 
/* 161 */       xmlFragment = new XMLFragment(result);
/* 162 */       log.debug("xmlFragment: " + xmlFragment);
/*     */     }
/*     */     catch (BindingException e)
/*     */     {
/* 166 */       throw new WSException(e);
/*     */     }
/*     */ 
/* 169 */     return xmlFragment;
/*     */   }
/*     */ 
/*     */   private AbstractSerializerFactory getSerializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType)
/*     */   {
/* 177 */     AbstractSerializerFactory serializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(javaType, xmlType);
/*     */ 
/* 180 */     if ((serializerFactory == null) && (javaType.isArray()))
/*     */     {
/* 182 */       Class arrayWrapperType = typeMapping.getJavaType(xmlType);
/* 183 */       if (arrayWrapperType != null)
/*     */       {
/*     */         try
/*     */         {
/* 187 */           Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
/* 188 */           Class returnType = toArrayMethod.getReturnType();
/* 189 */           if (JavaUtils.isAssignableFrom(javaType, returnType))
/*     */           {
/* 191 */             serializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(arrayWrapperType, xmlType);
/*     */           }
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 201 */     if (serializerFactory == null) {
/* 202 */       throw new WSException("Cannot obtain serializer factory for: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
/*     */     }
/* 204 */     return serializerFactory;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.ObjectContent
 * JD-Core Version:    0.6.0
 */