/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ 
/*     */ public class NameImpl
/*     */   implements Name
/*     */ {
/*     */   private QName qname;
/*     */ 
/*     */   public NameImpl(QName qname)
/*     */   {
/*  44 */     this.qname = qname;
/*     */   }
/*     */ 
/*     */   public NameImpl(String local)
/*     */   {
/*  49 */     this.qname = new QName(local);
/*     */   }
/*     */ 
/*     */   public NameImpl(String local, String prefix, String uri)
/*     */   {
/*  54 */     if (prefix != null)
/*  55 */       this.qname = new QName(uri, local, prefix);
/*     */     else
/*  57 */       this.qname = new QName(uri, local);
/*     */   }
/*     */ 
/*     */   public String getLocalName()
/*     */   {
/*  67 */     return this.qname.getLocalPart();
/*     */   }
/*     */ 
/*     */   public String getPrefix()
/*     */   {
/*  78 */     return this.qname.getPrefix();
/*     */   }
/*     */ 
/*     */   public String getQualifiedName()
/*     */   {
/*  88 */     String prefix = getPrefix();
/*  89 */     if (prefix.length() > 0) {
/*  90 */       return prefix + ":" + this.qname.getLocalPart();
/*     */     }
/*  92 */     return this.qname.getLocalPart();
/*     */   }
/*     */ 
/*     */   public String getURI()
/*     */   {
/* 102 */     return this.qname.getNamespaceURI();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 107 */     return this.qname.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 112 */     if (!(obj instanceof NameImpl)) return false;
/* 113 */     if (obj == this) return true;
/* 114 */     NameImpl other = (NameImpl)obj;
/* 115 */     return this.qname.equals(other.qname);
/*     */   }
/*     */ 
/*     */   public QName toQName()
/*     */   {
/* 120 */     return this.qname;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 125 */     return this.qname.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.NameImpl
 * JD-Core Version:    0.6.0
 */