/*    */ package org.jboss.ws.core.soap;
/*    */ 
/*    */ import java.util.Stack;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.CommonMessageContext;
/*    */ import org.jboss.ws.core.utils.ThreadLocalAssociation;
/*    */ 
/*    */ public class MessageContextAssociation
/*    */ {
/* 41 */   private static Logger log = Logger.getLogger(MessageContextAssociation.class);
/*    */ 
/*    */   public static void pushMessageContext(CommonMessageContext msgContext)
/*    */   {
/* 46 */     if (log.isDebugEnabled()) log.debug("pushMessageContext: " + msgContext + " (Thread " + Thread.currentThread().getName() + ")");
/* 47 */     Stack stack = (Stack)ThreadLocalAssociation.localMsgContextAssoc().get();
/* 48 */     if (stack == null)
/*    */     {
/* 50 */       stack = new Stack();
/* 51 */       ThreadLocalAssociation.localMsgContextAssoc().set(stack);
/*    */     }
/* 53 */     stack.push(msgContext);
/*    */   }
/*    */ 
/*    */   public static CommonMessageContext peekMessageContext()
/*    */   {
/* 58 */     CommonMessageContext msgContext = null;
/* 59 */     Stack stack = (Stack)ThreadLocalAssociation.localMsgContextAssoc().get();
/* 60 */     if ((stack != null) && (!stack.isEmpty()))
/*    */     {
/* 62 */       msgContext = (CommonMessageContext)stack.peek();
/*    */     }
/* 64 */     return msgContext;
/*    */   }
/*    */ 
/*    */   public static CommonMessageContext popMessageContext()
/*    */   {
/* 69 */     CommonMessageContext msgContext = null;
/* 70 */     Stack stack = (Stack)ThreadLocalAssociation.localMsgContextAssoc().get();
/* 71 */     if ((stack != null) && (!stack.isEmpty()))
/*    */     {
/* 73 */       msgContext = (CommonMessageContext)stack.pop();
/*    */     }
/* 75 */     if (log.isDebugEnabled()) log.debug("popMessageContext: " + msgContext + " (Thread " + Thread.currentThread().getName() + ")");
/* 76 */     return msgContext;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.MessageContextAssociation
 * JD-Core Version:    0.6.0
 */