/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import javax.xml.soap.Node;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.Text;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ 
/*     */ public class HRefInlineHandler
/*     */ {
/*  50 */   private static Logger log = Logger.getLogger(HRefInlineHandler.class);
/*     */ 
/*  52 */   private SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/*     */   private SOAPBodyImpl soapBody;
/*     */ 
/*     */   public HRefInlineHandler(SOAPBodyImpl soapBody)
/*     */   {
/*  57 */     this.soapBody = soapBody;
/*     */   }
/*     */ 
/*     */   public void processHRefs() throws SOAPException
/*     */   {
/*  62 */     String bodyStr = DOMWriter.printNode(this.soapBody, true);
/*  63 */     log.debug("Begin processHRefs:\n" + bodyStr);
/*     */ 
/*  65 */     SOAPBodyElement soapBodyElement = this.soapBody.getBodyElement();
/*  66 */     processElement(soapBodyElement);
/*     */ 
/*  69 */     Iterator it = this.soapBody.getChildElements();
/*  70 */     while (it.hasNext())
/*     */     {
/*  72 */       Object next = it.next();
/*  73 */       if ((next instanceof SOAPElement))
/*     */       {
/*  76 */         SOAPElement soapElement = (SOAPElement)next;
/*  77 */         if (!(soapElement instanceof SOAPBodyElement)) {
/*  78 */           this.soapBody.removeChild(soapElement);
/*     */         }
/*     */       }
/*     */     }
/*  82 */     bodyStr = DOMWriter.printNode(this.soapBody, true);
/*  83 */     log.debug("End processHRefs:\n" + bodyStr);
/*     */   }
/*     */ 
/*     */   private void processElement(SOAPElement soapElement)
/*     */     throws SOAPException
/*     */   {
/*  89 */     Iterator it = soapElement.getChildElements();
/*  90 */     while (it.hasNext())
/*     */     {
/*  92 */       Node childElement = (Node)it.next();
/*  93 */       if ((childElement instanceof SOAPElement)) {
/*  94 */         processElement((SOAPElement)childElement);
/*     */       }
/*     */     }
/*  97 */     String href = soapElement.getAttribute("href");
/*  98 */     if (href.length() > 0)
/*     */     {
/* 100 */       processHRef(soapElement, href);
/* 101 */       soapElement.removeAttribute("href");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processHRef(SOAPElement hrefElement, String href) throws SOAPException
/*     */   {
/* 107 */     SOAPElement idElement = null;
/*     */ 
/* 109 */     Iterator it = this.soapBody.getChildElements();
/* 110 */     while (it.hasNext())
/*     */     {
/* 112 */       Object next = it.next();
/* 113 */       if ((next instanceof SOAPElement))
/*     */       {
/* 115 */         SOAPElement auxElement = (SOAPElement)next;
/* 116 */         if (href.equals("#" + auxElement.getAttribute("id")))
/*     */         {
/* 118 */           idElement = auxElement;
/* 119 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 124 */     if (idElement == null) {
/* 125 */       throw new IllegalStateException("Cannot get href element: " + href);
/*     */     }
/*     */ 
/* 128 */     processElement(idElement);
/*     */ 
/* 131 */     copyMostAttributes(hrefElement, idElement);
/*     */ 
/* 134 */     if (DOMUtils.hasChildElements(idElement))
/*     */     {
/* 136 */       Iterator itid = idElement.getChildElements();
/* 137 */       while (itid.hasNext())
/*     */       {
/* 139 */         Node childNode = (Node)itid.next();
/* 140 */         if ((childNode instanceof SOAPElement))
/*     */         {
/* 142 */           SOAPElement childClone = this.soapFactory.createElement((SOAPElement)childNode, true);
/* 143 */           hrefElement.addChildElement(childClone);
/*     */         }
/* 145 */         else if ((childNode instanceof Text))
/*     */         {
/* 147 */           String value = childNode.getValue();
/* 148 */           hrefElement.setValue(value);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 155 */       String value = idElement.getValue();
/* 156 */       hrefElement.setValue(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void copyMostAttributes(Element destElement, Element srcElement)
/*     */   {
/* 162 */     NamedNodeMap attribs = srcElement.getAttributes();
/* 163 */     for (int i = 0; i < attribs.getLength(); i++)
/*     */     {
/* 165 */       Attr attr = (Attr)attribs.item(i);
/* 166 */       String uri = attr.getNamespaceURI();
/* 167 */       String qname = attr.getName();
/* 168 */       String value = attr.getNodeValue();
/*     */ 
/* 171 */       if (!"id".equals(qname))
/* 172 */         destElement.setAttributeNS(uri, qname, value);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.HRefInlineHandler
 * JD-Core Version:    0.6.0
 */