/*     */ package org.jboss.ws.core.soap;
/*     */ 
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DOMContent extends SOAPContent
/*     */ {
/*  40 */   private static Logger log = Logger.getLogger(DOMContent.class);
/*     */   private Source payload;
/*     */ 
/*     */   protected DOMContent(SOAPContentElement container)
/*     */   {
/*  46 */     super(container);
/*     */   }
/*     */ 
/*     */   SOAPContent.State getState()
/*     */   {
/*  51 */     return SOAPContent.State.DOM_VALID;
/*     */   }
/*     */ 
/*     */   SOAPContent transitionTo(SOAPContent.State nextState)
/*     */   {
/*  56 */     SOAPContent next = null;
/*     */ 
/*  58 */     if (SOAPContent.State.XML_VALID == nextState)
/*     */     {
/*  60 */       log.debug("getXMLFragment from DOM");
/*  61 */       DOMSource domSource = new DOMSource(this.container);
/*  62 */       XMLFragment fragment = new XMLFragment(domSource);
/*  63 */       log.debug("xmlFragment: " + fragment);
/*     */ 
/*  65 */       SOAPContent xmlValid = new XMLContent(this.container);
/*  66 */       xmlValid.setXMLFragment(fragment);
/*  67 */       next = xmlValid;
/*     */     }
/*  69 */     else if (SOAPContent.State.OBJECT_VALID == nextState)
/*     */     {
/*  72 */       XMLFragment fragment = new XMLFragment(new DOMSource(this.container));
/*  73 */       XMLContent tmpState = new XMLContent(this.container);
/*  74 */       tmpState.setXMLFragment(fragment);
/*     */ 
/*  77 */       next = tmpState.transitionTo(SOAPContent.State.OBJECT_VALID);
/*     */     }
/*  80 */     else if (SOAPContent.State.DOM_VALID == nextState)
/*     */     {
/*  82 */       next = this;
/*     */     }
/*     */     else
/*     */     {
/*  86 */       throw new IllegalArgumentException("Illegal state requested: " + nextState);
/*     */     }
/*     */ 
/*  89 */     return next;
/*     */   }
/*     */ 
/*     */   public Source getPayload()
/*     */   {
/*  94 */     return new DOMSource(this.container);
/*     */   }
/*     */ 
/*     */   public void setPayload(Source source)
/*     */   {
/*  99 */     if (!(source instanceof DOMSource)) {
/* 100 */       throw new IllegalArgumentException("DOMSource expected, but got: " + source);
/*     */     }
/* 102 */     this.payload = source;
/*     */   }
/*     */ 
/*     */   public XMLFragment getXMLFragment()
/*     */   {
/* 107 */     throw new IllegalStateException("XMLFragment not available");
/*     */   }
/*     */ 
/*     */   public void setXMLFragment(XMLFragment xmlFragment)
/*     */   {
/* 112 */     throw new IllegalStateException("XMLFragment not available");
/*     */   }
/*     */ 
/*     */   public Object getObjectValue()
/*     */   {
/* 117 */     throw new IllegalStateException("Object value not available");
/*     */   }
/*     */ 
/*     */   public void setObjectValue(Object objValue)
/*     */   {
/* 122 */     throw new IllegalStateException("Object value not available");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.soap.DOMContent
 * JD-Core Version:    0.6.0
 */