/*     */ package org.jboss.ws.core.server;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import javax.xml.soap.MimeHeader;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ 
/*     */ public class ServletHeaderSource
/*     */   implements MimeHeaderSource
/*     */ {
/*     */   private HttpServletRequest req;
/*     */   private HttpServletResponse res;
/*     */ 
/*     */   public ServletHeaderSource(HttpServletRequest req, HttpServletResponse res)
/*     */   {
/*  52 */     this.req = req;
/*  53 */     this.res = res;
/*     */   }
/*     */ 
/*     */   public MimeHeaders getMimeHeaders()
/*     */   {
/*  58 */     Enumeration e = this.req.getHeaderNames();
/*  59 */     if (e == null) {
/*  60 */       return null;
/*     */     }
/*  62 */     MimeHeaders headers = new MimeHeaders();
/*     */ 
/*  64 */     while (e.hasMoreElements())
/*     */     {
/*  66 */       String name = (String)e.nextElement();
/*  67 */       headers.addHeader(name, this.req.getHeader(name));
/*     */     }
/*     */ 
/*  70 */     return headers;
/*     */   }
/*     */ 
/*     */   public Map<String, List<String>> getHeaderMap()
/*     */   {
/*  75 */     Map headerMap = new HashMap();
/*     */ 
/*  77 */     Enumeration e = this.req.getHeaderNames();
/*  78 */     if (e != null)
/*     */     {
/*  80 */       while (e.hasMoreElements())
/*     */       {
/*  82 */         String name = (String)e.nextElement();
/*  83 */         List values = new ArrayList();
/*  84 */         values.add(this.req.getHeader(name));
/*  85 */         headerMap.put(name, values);
/*     */       }
/*     */     }
/*     */ 
/*  89 */     return headerMap;
/*     */   }
/*     */ 
/*     */   public void setMimeHeaders(MimeHeaders headers)
/*     */   {
/*  94 */     Iterator i = headers.getAllHeaders();
/*  95 */     while (i.hasNext())
/*     */     {
/*  97 */       MimeHeader header = (MimeHeader)i.next();
/*  98 */       this.res.addHeader(header.getName(), header.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setHeaderMap(Map<String, List<String>> headers)
/*     */   {
/* 104 */     Iterator it = headers.keySet().iterator();
/*     */     String name;
/* 105 */     while (it.hasNext())
/*     */     {
/* 107 */       name = (String)it.next();
/* 108 */       List values = (List)headers.get(name);
/* 109 */       for (String value : values)
/*     */       {
/* 111 */         this.res.addHeader(name, value);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.ServletHeaderSource
 * JD-Core Version:    0.6.0
 */