/*     */ package org.jboss.ws.core.server;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.server.ServiceLifecycle;
/*     */ import javax.xml.rpc.server.ServletEndpointContext;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.ws.WebServiceContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.CommonBinding;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.CommonSOAPBinding;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.jboss.ws.core.DirectionHolder;
/*     */ import org.jboss.ws.core.DirectionHolder.Direction;
/*     */ import org.jboss.ws.core.EndpointInvocation;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.jaxrpc.ServletEndpointContextImpl;
/*     */ import org.jboss.ws.core.jaxrpc.handler.HandlerDelegateJAXRPC;
/*     */ import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
/*     */ import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
/*     */ import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
/*     */ import org.jboss.ws.core.jaxws.handler.HandlerDelegateJAXWS;
/*     */ import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
/*     */ import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.SOAPBodyImpl;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment.DeploymentType;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ import org.jboss.wsf.spi.invocation.Invocation;
/*     */ import org.jboss.wsf.spi.invocation.InvocationContext;
/*     */ import org.jboss.wsf.spi.invocation.InvocationHandler;
/*     */ import org.jboss.wsf.spi.invocation.InvocationType;
/*     */ import org.jboss.wsf.spi.invocation.WebServiceContextFactory;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class ServiceEndpointInvoker
/*     */ {
/*  89 */   private static final Logger log = Logger.getLogger(ServiceEndpointInvoker.class);
/*     */   protected Endpoint endpoint;
/*     */   protected CommonBindingProvider bindingProvider;
/*     */   protected ServerHandlerDelegate delegate;
/*     */   private WebServiceContextFactory contextFactory;
/*     */ 
/*     */   public ServiceEndpointInvoker()
/*     */   {
/*  99 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 100 */     this.contextFactory = ((WebServiceContextFactory)spiProvider.getSPI(WebServiceContextFactory.class));
/*     */   }
/*     */ 
/*     */   public void init(Endpoint endpoint)
/*     */   {
/* 106 */     this.endpoint = endpoint;
/*     */ 
/* 108 */     ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
/* 109 */     if (sepMetaData == null) {
/* 110 */       throw new IllegalStateException("Cannot obtain endpoint meta data");
/*     */     }
/* 112 */     if (sepMetaData.getType() == EndpointMetaData.Type.JAXRPC)
/*     */     {
/* 114 */       this.bindingProvider = new CommonBindingProvider(sepMetaData);
/* 115 */       this.delegate = new HandlerDelegateJAXRPC(sepMetaData);
/*     */     }
/*     */     else
/*     */     {
/* 119 */       this.bindingProvider = new BindingProviderImpl(sepMetaData);
/* 120 */       this.delegate = new HandlerDelegateJAXWS(sepMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 126 */     return this.delegate.callRequestHandlerChain(sepMetaData, type);
/*     */   }
/*     */ 
/*     */   public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 131 */     return this.delegate.callResponseHandlerChain(sepMetaData, type);
/*     */   }
/*     */ 
/*     */   public void closeHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 136 */     this.delegate.closeHandlerChain(sepMetaData, type);
/*     */   }
/*     */ 
/*     */   public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/* 141 */     return this.delegate.callFaultHandlerChain(sepMetaData, type, ex);
/*     */   }
/*     */ 
/*     */   public void invoke(InvocationContext invContext)
/*     */     throws Exception
/*     */   {
/* 147 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 148 */     ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)msgContext.getEndpointMetaData();
/* 149 */     MessageAbstraction reqMessage = msgContext.getMessageAbstraction();
/*     */ 
/* 152 */     DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.InBound);
/*     */ 
/* 155 */     UnifiedHandlerMetaData.HandlerType[] handlerType = this.delegate.getHandlerTypeOrder();
/* 156 */     UnifiedHandlerMetaData.HandlerType[] faultType = this.delegate.getHandlerTypeOrder();
/*     */ 
/* 159 */     setInboundContextProperties();
/*     */     try
/*     */     {
/* 163 */       boolean oneway = false;
/* 164 */       EndpointInvocation sepInv = null;
/* 165 */       OperationMetaData opMetaData = null;
/* 166 */       CommonBinding binding = this.bindingProvider.getCommonBinding();
/* 167 */       binding.setHeaderSource(this.delegate);
/*     */ 
/* 170 */       boolean handlersPass = callRequestHandlerChain(sepMetaData, handlerType[0]);
/*     */ 
/* 173 */       if (handlersPass)
/*     */       {
/* 176 */         opMetaData = getDispatchDestination(sepMetaData, reqMessage);
/* 177 */         msgContext.setOperationMetaData(opMetaData);
/* 178 */         oneway = opMetaData.isOneWay();
/*     */ 
/* 191 */         if ((binding instanceof CommonSOAPBinding)) {
/* 192 */           ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
/*     */         }
/*     */ 
/* 195 */         sepInv = binding.unbindRequestMessage(opMetaData, reqMessage);
/*     */       }
/*     */ 
/* 198 */       handlersPass = (handlersPass) && (callRequestHandlerChain(sepMetaData, handlerType[1]));
/* 199 */       handlersPass = (handlersPass) && (callRequestHandlerChain(sepMetaData, handlerType[2]));
/*     */ 
/* 201 */       if (handlersPass)
/*     */       {
/* 203 */         msgContext.put(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/*     */         try
/*     */         {
/* 207 */           if (msgContext.isModified())
/*     */           {
/* 209 */             log.debug("Handler modified payload, unbind message again");
/* 210 */             reqMessage = msgContext.getMessageAbstraction();
/* 211 */             sepInv = binding.unbindRequestMessage(opMetaData, reqMessage);
/*     */           }
/*     */ 
/* 215 */           Invocation inv = setupInvocation(this.endpoint, sepInv, invContext);
/* 216 */           InvocationHandler invHandler = this.endpoint.getInvocationHandler();
/*     */           try
/*     */           {
/* 220 */             invHandler.invoke(this.endpoint, inv);
/*     */           }
/*     */           catch (InvocationTargetException th)
/*     */           {
/* 225 */             Throwable targetEx = th.getTargetException();
/* 226 */             throw ((targetEx instanceof Exception) ? (Exception)targetEx : new UndeclaredThrowableException(targetEx));
/*     */           }
/*     */ 
/* 230 */           sepInv = (EndpointInvocation)inv.getInvocationContext().getAttachment(EndpointInvocation.class);
/*     */         }
/*     */         finally
/*     */         {
/* 234 */           msgContext.remove(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
/*     */         }
/*     */ 
/* 238 */         msgContext = processPivotInternal(msgContext, direction);
/*     */ 
/* 241 */         setOutboundContextProperties();
/*     */ 
/* 243 */         if ((binding instanceof CommonSOAPBinding)) {
/* 244 */           XOPContext.setMTOMEnabled(((CommonSOAPBinding)binding).isMTOMEnabled());
/*     */         }
/*     */ 
/* 247 */         MessageAbstraction resMessage = binding.bindResponseMessage(opMetaData, sepInv);
/* 248 */         msgContext.setMessageAbstraction(resMessage);
/*     */       }
/*     */       else
/*     */       {
/* 253 */         MessageAbstraction resMessage = msgContext.getMessageAbstraction();
/* 254 */         msgContext = processPivotInternal(msgContext, direction);
/* 255 */         msgContext.setMessageAbstraction(resMessage);
/*     */       }
/*     */ 
/* 258 */       if (!oneway)
/*     */       {
/* 261 */         handlersPass = callResponseHandlerChain(sepMetaData, handlerType[2]);
/* 262 */         faultType[2] = null;
/* 263 */         handlersPass = (handlersPass) && (callResponseHandlerChain(sepMetaData, handlerType[1]));
/* 264 */         faultType[1] = null;
/* 265 */         handlersPass = (handlersPass) && (callResponseHandlerChain(sepMetaData, handlerType[0]));
/* 266 */         faultType[0] = null;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (RuntimeException ex)
/*     */     {
/* 272 */       processPivotInternal(msgContext, direction);
/*     */       try
/*     */       {
/* 276 */         CommonBinding binding = this.bindingProvider.getCommonBinding();
/* 277 */         binding.bindFaultMessage(ex);
/*     */ 
/* 280 */         boolean handlersPass = true;
/* 281 */         if (faultType[2] != null)
/* 282 */           handlersPass = (handlersPass) && (callFaultHandlerChain(sepMetaData, faultType[2], ex));
/* 283 */         if (faultType[1] != null)
/* 284 */           handlersPass = (handlersPass) && (callFaultHandlerChain(sepMetaData, faultType[1], ex));
/* 285 */         if (faultType[0] != null)
/* 286 */           handlersPass = (handlersPass) && (callFaultHandlerChain(sepMetaData, faultType[0], ex));
/*     */       }
/*     */       catch (RuntimeException subEx)
/*     */       {
/* 290 */         log.warn("Exception while processing handleFault: ", ex);
/* 291 */         ex = subEx;
/*     */       }
/* 293 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 297 */       closeHandlerChain(sepMetaData, handlerType[2]);
/* 298 */       closeHandlerChain(sepMetaData, handlerType[1]);
/* 299 */       closeHandlerChain(sepMetaData, handlerType[0]);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Invocation setupInvocation(Endpoint ep, EndpointInvocation epInv, InvocationContext invContext) throws Exception
/*     */   {
/* 305 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 306 */     if ((msgContext instanceof SOAPMessageContextJAXWS))
/*     */     {
/* 308 */       if (ep.getService().getDeployment().getType() == Deployment.DeploymentType.JAXWS_JSE)
/*     */       {
/* 310 */         if (msgContext.get("javax.xml.ws.servlet.request") != null)
/*     */         {
/* 312 */           WebServiceContext wsContext = this.contextFactory.newWebServiceContext(InvocationType.JAXWS_JSE, (SOAPMessageContextJAXWS)msgContext);
/* 313 */           invContext.addAttachment(WebServiceContext.class, wsContext);
/*     */         }
/*     */         else
/*     */         {
/* 317 */           log.warn("Cannot provide WebServiceContext, since the current MessageContext does not provide a ServletRequest");
/*     */         }
/*     */       }
/* 320 */       invContext.addAttachment(javax.xml.ws.handler.MessageContext.class, msgContext);
/*     */     }
/* 322 */     if ((msgContext instanceof SOAPMessageContextJAXRPC))
/*     */     {
/* 324 */       invContext.addAttachment(javax.xml.rpc.handler.MessageContext.class, msgContext);
/*     */     }
/* 326 */     if ((ServiceLifecycle.class.isAssignableFrom(ep.getTargetBeanClass())) && ((invContext instanceof ServletRequestContext)))
/*     */     {
/* 328 */       ServletEndpointContext servletEndpointContext = new ServletEndpointContextImpl((ServletRequestContext)invContext);
/* 329 */       invContext.addAttachment(ServletEndpointContext.class, servletEndpointContext);
/*     */     }
/*     */ 
/* 332 */     invContext.addAttachment(EndpointInvocation.class, epInv);
/*     */ 
/* 334 */     Invocation wsInv = new DelegatingInvocation();
/* 335 */     wsInv.setInvocationContext(invContext);
/* 336 */     wsInv.setJavaMethod(getImplMethod(this.endpoint, epInv));
/*     */ 
/* 338 */     return wsInv;
/*     */   }
/*     */ 
/*     */   protected Method getImplMethod(Endpoint endpoint, EndpointInvocation sepInv) throws ClassNotFoundException, NoSuchMethodException
/*     */   {
/* 343 */     Class implClass = endpoint.getTargetBeanClass();
/* 344 */     Method seiMethod = sepInv.getJavaMethod();
/*     */ 
/* 346 */     String methodName = seiMethod.getName();
/* 347 */     Class[] paramTypes = seiMethod.getParameterTypes();
/* 348 */     for (int i = 0; i < paramTypes.length; i++)
/*     */     {
/* 350 */       Class paramType = paramTypes[i];
/* 351 */       if (JavaUtils.isPrimitive(paramType))
/*     */         continue;
/* 353 */       String paramTypeName = paramType.getName();
/* 354 */       paramType = JavaUtils.loadJavaType(paramTypeName);
/* 355 */       paramTypes[i] = paramType;
/*     */     }
/*     */ 
/* 359 */     Method implMethod = null;
/*     */     try
/*     */     {
/* 362 */       implMethod = implClass.getMethod(methodName, paramTypes);
/*     */     }
/*     */     catch (NoSuchMethodException ex)
/*     */     {
/* 366 */       log.error("CodeSource: " + implClass.getProtectionDomain().getCodeSource());
/* 367 */       log.error("ClassLoader: " + implClass.getClassLoader());
/* 368 */       throw ex;
/*     */     }
/* 370 */     return implMethod;
/*     */   }
/*     */ 
/*     */   protected void setInboundContextProperties()
/*     */   {
/* 375 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 376 */     if ((msgContext instanceof MessageContextJAXWS))
/*     */     {
/* 379 */       msgContext.put("javax.xml.ws.binding.attachments.inbound", new HashMap());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setOutboundContextProperties()
/*     */   {
/* 385 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 386 */     if ((msgContext instanceof MessageContextJAXWS))
/*     */     {
/* 389 */       msgContext.put("javax.xml.ws.binding.attachments.outbound", new HashMap());
/*     */     }
/*     */   }
/*     */ 
/*     */   private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction)
/*     */   {
/* 395 */     if (direction.getDirection() == DirectionHolder.Direction.InBound)
/*     */     {
/* 397 */       EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
/* 398 */       if (epMetaData.getType() == EndpointMetaData.Type.JAXRPC)
/*     */       {
/* 400 */         msgContext = MessageContextJAXRPC.processPivot(msgContext);
/*     */       }
/*     */       else
/*     */       {
/* 404 */         msgContext = MessageContextJAXWS.processPivot(msgContext);
/*     */       }
/* 406 */       direction.setDirection(DirectionHolder.Direction.OutBound);
/*     */     }
/* 408 */     return msgContext;
/*     */   }
/*     */ 
/*     */   private OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, MessageAbstraction reqMessage)
/*     */     throws SOAPException
/*     */   {
/* 415 */     String bindingID = epMetaData.getBindingId();
/*     */     OperationMetaData opMetaData;
/*     */     OperationMetaData opMetaData;
/* 416 */     if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID))
/*     */     {
/* 418 */       if (epMetaData.getOperations().size() != 1) {
/* 419 */         throw new IllegalStateException("Multiple operations not supported for HTTP binding");
/*     */       }
/* 421 */       opMetaData = (OperationMetaData)epMetaData.getOperations().get(0);
/*     */     }
/*     */     else
/*     */     {
/* 425 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)reqMessage;
/*     */ 
/* 427 */       opMetaData = soapMessage.getOperationMetaData(epMetaData);
/* 428 */       SOAPHeader soapHeader = soapMessage.getSOAPHeader();
/*     */ 
/* 431 */       if (opMetaData == null)
/*     */       {
/* 435 */         SOAPBodyImpl soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
/* 436 */         SOAPBodyElement soapBodyElement = soapBody.getBodyElement();
/*     */         String faultString;
/*     */         String faultString;
/* 437 */         if (soapBodyElement != null)
/*     */         {
/* 439 */           Name soapName = soapBodyElement.getElementName();
/* 440 */           faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for: " + soapName;
/*     */         }
/*     */         else
/*     */         {
/* 444 */           faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for empty soap body";
/*     */         }
/*     */ 
/* 449 */         if ((soapHeader != null) && (soapHeader.examineMustUnderstandHeaderElements("http://schemas.xmlsoap.org/soap/actor/next").hasNext()))
/*     */         {
/* 451 */           QName faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
/* 452 */           throw new CommonSOAPFaultException(faultCode, faultString);
/*     */         }
/*     */ 
/* 456 */         QName faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
/* 457 */         throw new CommonSOAPFaultException(faultCode, faultString);
/*     */       }
/*     */     }
/*     */ 
/* 461 */     return opMetaData;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.ServiceEndpointInvoker
 * JD-Core Version:    0.6.0
 */