/*    */ package org.jboss.ws.core.server;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*    */ import org.jboss.wsf.spi.deployment.Endpoint;
/*    */ import org.jboss.wsf.spi.management.EndpointResolver;
/*    */ 
/*    */ public class PortComponentResolver
/*    */   implements EndpointResolver
/*    */ {
/* 37 */   private static final Logger log = Logger.getLogger(PortComponentResolver.class);
/*    */   private String pcLink;
/*    */   private Endpoint result;
/*    */ 
/*    */   public PortComponentResolver(String pcref)
/*    */   {
/* 44 */     this.pcLink = pcref;
/*    */   }
/*    */ 
/*    */   public Endpoint query(Iterator<Endpoint> endpoints)
/*    */   {
/* 49 */     Endpoint endpoint = null;
/*    */ 
/* 51 */     String pcName = this.pcLink;
/* 52 */     int hashIndex = this.pcLink.indexOf("#");
/* 53 */     if (hashIndex > 0)
/*    */     {
/* 55 */       pcName = this.pcLink.substring(hashIndex + 1);
/*    */     }
/*    */ 
/* 58 */     while (endpoints.hasNext())
/*    */     {
/* 60 */       Endpoint auxEndpoint = (Endpoint)endpoints.next();
/* 61 */       ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)auxEndpoint.getAttachment(ServerEndpointMetaData.class);
/* 62 */       if (pcName.equals(sepMetaData.getPortComponentName()))
/*    */       {
/* 64 */         if (endpoint != null)
/*    */         {
/* 66 */           log.warn("Multiple service endoints found for: " + this.pcLink);
/* 67 */           endpoint = null;
/* 68 */           break;
/*    */         }
/* 70 */         endpoint = auxEndpoint;
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 75 */     return endpoint;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.PortComponentResolver
 * JD-Core Version:    0.6.0
 */