/*    */ package org.jboss.ws.core.server;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.PrintWriter;
/*    */ import javax.servlet.ServletConfig;
/*    */ import javax.servlet.ServletException;
/*    */ import javax.servlet.http.HttpServlet;
/*    */ import javax.servlet.http.HttpServletRequest;
/*    */ import javax.servlet.http.HttpServletResponse;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*    */ import org.jboss.wsf.spi.SPIProvider;
/*    */ import org.jboss.wsf.spi.SPIProviderResolver;
/*    */ import org.jboss.wsf.spi.deployment.Endpoint;
/*    */ import org.jboss.wsf.spi.management.EndpointRegistry;
/*    */ import org.jboss.wsf.spi.management.EndpointRegistryFactory;
/*    */ 
/*    */ public class PortComponentLinkServlet extends HttpServlet
/*    */ {
/* 62 */   private static final Logger log = Logger.getLogger(PortComponentLinkServlet.class);
/*    */   protected EndpointRegistry epRegistry;
/*    */ 
/*    */   public void init(ServletConfig config)
/*    */     throws ServletException
/*    */   {
/* 68 */     super.init(config);
/* 69 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 70 */     this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
/*    */   }
/*    */ 
/*    */   public void doGet(HttpServletRequest req, HttpServletResponse res)
/*    */     throws ServletException, IOException
/*    */   {
/* 78 */     String pcLink = req.getParameter("pcLink");
/* 79 */     if (pcLink == null) {
/* 80 */       throw new IllegalArgumentException("Cannot obtain request parameter 'pcLink'");
/*    */     }
/* 82 */     Endpoint endpoint = this.epRegistry.resolve(new PortComponentResolver(pcLink));
/* 83 */     if (endpoint == null) {
/* 84 */       throw new WSException("Cannot resolve port-component-link: " + pcLink);
/*    */     }
/* 86 */     res.setContentType("text/plain");
/* 87 */     PrintWriter out = res.getWriter();
/*    */ 
/* 89 */     ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
/* 90 */     String endpointAddress = sepMetaData.getEndpointAddress();
/* 91 */     out.println(endpointAddress);
/*    */ 
/* 93 */     log.debug("Resolved " + pcLink + " to: " + endpointAddress);
/* 94 */     out.close();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.server.PortComponentLinkServlet
 * JD-Core Version:    0.6.0
 */