/*     */ package org.jboss.ws.core.jaxws.spi;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.Endpoint;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.WebServiceFeature;
/*     */ import javax.xml.ws.spi.Provider21;
/*     */ import javax.xml.ws.spi.ServiceDelegate;
/*     */ import javax.xml.ws.wsaddressing.W3CEndpointReference;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ProviderImpl extends Provider21
/*     */ {
/*     */   public ServiceDelegate createServiceDelegate(URL wsdlLocation, QName serviceName, Class serviceClass)
/*     */   {
/*  63 */     ServiceDelegateImpl delegate = new ServiceDelegateImpl(wsdlLocation, serviceName, serviceClass);
/*  64 */     DOMUtils.clearThreadLocals();
/*  65 */     return delegate;
/*     */   }
/*     */ 
/*     */   public Endpoint createEndpoint(String bindingId, Object implementor)
/*     */   {
/*  71 */     EndpointImpl endpoint = new EndpointImpl(bindingId, implementor);
/*  72 */     return endpoint;
/*     */   }
/*     */ 
/*     */   public Endpoint createAndPublishEndpoint(String address, Object implementor)
/*     */   {
/*  83 */     String bindingId = getBindingFromAddress(address);
/*  84 */     EndpointImpl endpoint = (EndpointImpl)createEndpoint(bindingId, implementor);
/*  85 */     endpoint.publish(address);
/*  86 */     return endpoint;
/*     */   }
/*     */ 
/*     */   private String getBindingFromAddress(String address)
/*     */   {
/*     */     String bindingId;
/*     */     try {
/*  94 */       URL url = new URL(address);
/*  95 */       String protocol = url.getProtocol();
/*     */       String bindingId;
/*  96 */       if (protocol.startsWith("http"))
/*     */       {
/*  98 */         bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
/*     */       }
/*     */       else
/*     */       {
/* 102 */         throw new IllegalArgumentException("Unsupported protocol: " + address);
/*     */       }
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 107 */       throw new IllegalArgumentException("Invalid endpoint address: " + address);
/*     */     }
/* 109 */     return bindingId;
/*     */   }
/*     */ 
/*     */   public <T extends EndpointReference> T createEndpointReference(Class<T> clazz, QName serviceName, QName portName, Source wsdlDocumentLocation, Element[] referenceParameters)
/*     */   {
/* 115 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public W3CEndpointReference createW3CEndpointReference(String address, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters)
/*     */   {
/* 121 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature[] features)
/*     */   {
/* 127 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public EndpointReference readEndpointReference(Source eprInfoset)
/*     */   {
/* 133 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.spi.ProviderImpl
 * JD-Core Version:    0.6.0
 */