/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPHeaderElement;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.handler.soap.SOAPMessageContext;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ 
/*     */ public class SOAPMessageContextJAXWS extends MessageContextJAXWS
/*     */   implements SOAPMessageContext
/*     */ {
/*  54 */   private Set<String> roles = new HashSet();
/*     */ 
/*     */   public SOAPMessageContextJAXWS()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SOAPMessageContextJAXWS(CommonMessageContext msgContext)
/*     */   {
/*  63 */     super(msgContext);
/*     */   }
/*     */ 
/*     */   public SOAPMessage getMessage()
/*     */   {
/*  72 */     return getSOAPMessage();
/*     */   }
/*     */ 
/*     */   public void setMessage(SOAPMessage soapMessage)
/*     */   {
/*  80 */     setSOAPMessage(soapMessage);
/*     */   }
/*     */ 
/*     */   public Object[] getHeaders(QName qname, JAXBContext context, boolean allRoles)
/*     */   {
/*  89 */     List headers = new ArrayList();
/*     */ 
/*  91 */     if (getSOAPMessage() != null)
/*     */     {
/*     */       try
/*     */       {
/*  95 */         SOAPHeader soapHeader = getSOAPMessage().getSOAPHeader();
/*  96 */         Iterator headerElements = soapHeader.examineAllHeaderElements();
/*  97 */         while (headerElements.hasNext())
/*     */         {
/*  99 */           SOAPHeaderElement hElement = (SOAPHeaderElement)headerElements.next();
/* 100 */           Name hName = hElement.getElementName();
/* 101 */           if (qname.equals(new QName(hName.getURI(), hName.getLocalName())))
/*     */           {
/* 103 */             URI actor = new URI(hElement.getActor());
/* 104 */             if ((this.roles.contains(actor)) || (allRoles))
/*     */             {
/* 106 */               headers.add(hElement);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 117 */         throw rte;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 121 */         throw new WebServiceException("Cannot get headers", ex);
/*     */       }
/*     */     }
/*     */ 
/* 125 */     Object[] arr = new Object[headers.size()];
/* 126 */     headers.toArray(arr);
/* 127 */     return arr;
/*     */   }
/*     */ 
/*     */   public Set<String> getRoles()
/*     */   {
/* 138 */     return this.roles;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS
 * JD-Core Version:    0.6.0
 */