/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.ws.LogicalMessage;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.HTTPMessageImpl;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.soap.EnvelopeBuilder;
/*     */ import org.jboss.ws.core.soap.EnvelopeBuilderDOM;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.SOAPBodyImpl;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.spi.util.ServiceLoader;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class LogicalMessageImpl
/*     */   implements LogicalMessage
/*     */ {
/*  63 */   private static final Logger log = Logger.getLogger(LogicalMessageImpl.class);
/*     */   private Style style;
/*     */   private MessageAbstraction message;
/*     */ 
/*     */   public LogicalMessageImpl(MessageAbstraction message, Style style)
/*     */   {
/*  70 */     this.style = style;
/*  71 */     this.message = message;
/*     */   }
/*     */ 
/*     */   public Source getPayload()
/*     */   {
/*  76 */     Source source = null;
/*  77 */     if ((this.message instanceof SOAPMessage))
/*     */     {
/*  79 */       SOAPMessage soapMessage = (SOAPMessage)this.message;
/*  80 */       SOAPBodyImpl soapBody = getSOAPBody(soapMessage);
/*  81 */       SOAPElement bodyElement = (SOAPElement)soapBody.getFirstChild();
/*     */ 
/*  83 */       if (this.style == Style.RPC)
/*     */       {
/*  85 */         source = new DOMSource(bodyElement);
/*     */       }
/*     */       else
/*     */       {
/*  89 */         SOAPContentElement contentElement = (SOAPContentElement)bodyElement;
/*  90 */         source = contentElement.getXMLFragment().getSource();
/*     */       }
/*     */     }
/*  93 */     else if ((this.message instanceof HTTPMessageImpl))
/*     */     {
/*  95 */       HTTPMessageImpl httpMessage = (HTTPMessageImpl)this.message;
/*  96 */       source = httpMessage.getXmlFragment().getSource();
/*     */     }
/*  98 */     return source;
/*     */   }
/*     */ 
/*     */   public void setPayload(Source source)
/*     */   {
/* 103 */     if ((this.message instanceof SOAPMessage))
/*     */     {
/* 105 */       SOAPMessage soapMessage = (SOAPMessage)this.message;
/* 106 */       SOAPBodyImpl soapBody = getSOAPBody(soapMessage);
/* 107 */       SOAPElement bodyElement = (SOAPElement)soapBody.getFirstChild();
/*     */       try
/*     */       {
/* 110 */         if (this.style == Style.RPC)
/*     */         {
/*     */           try
/*     */           {
/* 114 */             soapBody.removeContents();
/* 115 */             EnvelopeBuilder envBuilder = (EnvelopeBuilder)ServiceLoader.loadService(EnvelopeBuilder.class.getName(), EnvelopeBuilderDOM.class.getName());
/* 116 */             envBuilder.setStyle(this.style);
/* 117 */             Element domBodyElement = DOMUtils.sourceToElement(source);
/* 118 */             envBuilder.buildBodyElementRpc(soapBody, domBodyElement);
/*     */           }
/*     */           catch (IOException ex)
/*     */           {
/* 122 */             WSException.rethrow(ex);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 127 */           SOAPContentElement contentElement = (SOAPContentElement)bodyElement;
/* 128 */           contentElement.setXMLFragment(new XMLFragment(source));
/*     */         }
/*     */       }
/*     */       catch (SOAPException ex)
/*     */       {
/* 133 */         throw new WebServiceException("Cannot set xml payload", ex);
/*     */       }
/*     */     }
/* 136 */     else if ((this.message instanceof HTTPMessageImpl))
/*     */     {
/* 138 */       HTTPMessageImpl httpMessage = (HTTPMessageImpl)this.message;
/* 139 */       httpMessage.setXmlFragment(new XMLFragment(source));
/*     */     }
/*     */ 
/* 142 */     MessageContextAssociation.peekMessageContext().setModified(true);
/*     */   }
/*     */ 
/*     */   public Object getPayload(JAXBContext jaxbContext)
/*     */   {
/* 148 */     Object payload = null;
/* 149 */     if ((this.message instanceof SOAPMessage))
/*     */     {
/* 151 */       SOAPMessage soapMessage = (SOAPMessage)this.message;
/* 152 */       SOAPBodyImpl soapBody = getSOAPBody(soapMessage);
/*     */ 
/* 154 */       SOAPContentElement bodyElement = (SOAPContentElement)soapBody.getFirstChild();
/* 155 */       if (bodyElement != null)
/*     */       {
/* 157 */         payload = bodyElement.getObjectValue();
/*     */       }
/*     */     }
/* 160 */     else if ((this.message instanceof HTTPMessageImpl))
/*     */     {
/* 162 */       throw new NotImplementedException();
/*     */     }
/* 164 */     return payload;
/*     */   }
/*     */ 
/*     */   public void setPayload(Object payload, JAXBContext jaxbContext)
/*     */   {
/* 169 */     if ((this.message instanceof SOAPMessage))
/*     */     {
/* 171 */       SOAPMessage soapMessage = (SOAPMessage)this.message;
/* 172 */       SOAPBodyImpl soapBody = getSOAPBody(soapMessage);
/*     */ 
/* 174 */       SOAPContentElement bodyElement = (SOAPContentElement)soapBody.getFirstChild();
/* 175 */       if (bodyElement != null)
/*     */       {
/* 177 */         bodyElement.setObjectValue(payload);
/* 178 */         MessageContextAssociation.peekMessageContext().setModified(true);
/*     */       }
/*     */     }
/* 181 */     else if ((this.message instanceof HTTPMessageImpl))
/*     */     {
/* 183 */       throw new NotImplementedException();
/*     */     }
/*     */   }
/*     */ 
/*     */   private SOAPBodyImpl getSOAPBody(SOAPMessage soapMessage)
/*     */   {
/* 189 */     SOAPBodyImpl soapBody = null;
/*     */     try
/*     */     {
/* 192 */       soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
/*     */     }
/*     */     catch (SOAPException ex)
/*     */     {
/* 196 */       WSException.rethrow(ex);
/*     */     }
/* 198 */     return soapBody;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.LogicalMessageImpl
 * JD-Core Version:    0.6.0
 */