/*     */ package org.jboss.ws.core.jaxws.handler;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.handler.LogicalHandler;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.MessageContext.Scope;
/*     */ import javax.xml.ws.handler.soap.SOAPMessageContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
/*     */ import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ 
/*     */ public class HandlerChainExecutor
/*     */ {
/*  54 */   private static Logger log = Logger.getLogger(HandlerChainExecutor.class);
/*     */   private EndpointMetaData epMetaData;
/*  59 */   protected List<Handler> handlers = new ArrayList();
/*     */ 
/*  61 */   protected List<Handler> executedHandlers = new ArrayList();
/*     */ 
/*  63 */   protected int falseIndex = -1;
/*     */   protected Boolean isOutbound;
/*     */ 
/*     */   public HandlerChainExecutor(EndpointMetaData epMetaData, List<Handler> unsortedChain)
/*     */   {
/*  69 */     this.epMetaData = epMetaData;
/*     */ 
/*  72 */     List sortedChain = new ArrayList();
/*  73 */     for (Handler handler : unsortedChain)
/*     */     {
/*  75 */       if ((handler instanceof LogicalHandler))
/*  76 */         sortedChain.add(handler);
/*     */     }
/*  78 */     for (Handler handler : unsortedChain)
/*     */     {
/*  80 */       if (!(handler instanceof LogicalHandler)) {
/*  81 */         sortedChain.add(handler);
/*     */       }
/*     */     }
/*  84 */     log.debug("Create a handler executor: " + sortedChain);
/*  85 */     for (Handler handler : sortedChain)
/*     */     {
/*  87 */       this.handlers.add(handler);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void close(MessageContext msgContext)
/*     */   {
/*  96 */     log.debug("close");
/*  97 */     MessageContextJAXWS context = (MessageContextJAXWS)msgContext;
/*  98 */     for (int index = 1; index <= this.executedHandlers.size(); index++)
/*     */     {
/* 100 */       Handler currHandler = (Handler)this.executedHandlers.get(this.executedHandlers.size() - index);
/*     */       try
/*     */       {
/* 103 */         context.setCurrentScope(MessageContext.Scope.HANDLER);
/* 104 */         currHandler.close(msgContext);
/*     */       }
/*     */       finally
/*     */       {
/* 108 */         context.setCurrentScope(MessageContext.Scope.APPLICATION);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean handleMessage(MessageContext msgContext)
/*     */   {
/* 115 */     this.isOutbound = ((Boolean)msgContext.get("javax.xml.ws.handler.message.outbound"));
/* 116 */     if (this.isOutbound == null) {
/* 117 */       throw new IllegalStateException("Cannot find property: javax.xml.ws.handler.message.outbound");
/*     */     }
/* 119 */     boolean doNext = true;
/*     */ 
/* 121 */     if (this.handlers.size() > 0)
/*     */     {
/* 123 */       log.debug("Enter: handle" + (this.isOutbound.booleanValue() ? "Out" : "In ") + "BoundMessage");
/*     */ 
/* 125 */       int index = getFirstHandler();
/* 126 */       Handler currHandler = null;
/*     */       try
/*     */       {
/* 129 */         String lastMessageTrace = null;
/* 130 */         while ((doNext) && (index >= 0))
/*     */         {
/* 132 */           currHandler = (Handler)this.handlers.get(index);
/*     */ 
/* 134 */           if ((log.isTraceEnabled()) && ((msgContext instanceof SOAPMessageContext)))
/*     */           {
/* 136 */             SOAPPart soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
/* 137 */             lastMessageTrace = traceSOAPPart("BEFORE handleRequest - " + currHandler, soapPart, lastMessageTrace);
/*     */           }
/*     */ 
/* 140 */           doNext = handleMessage(currHandler, msgContext);
/*     */ 
/* 142 */           if ((log.isTraceEnabled()) && ((msgContext instanceof SOAPMessageContext)))
/*     */           {
/* 144 */             SOAPPart soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
/* 145 */             lastMessageTrace = traceSOAPPart("AFTER handleRequest - " + currHandler, soapPart, lastMessageTrace);
/*     */           }
/*     */ 
/* 148 */           if (doNext)
/* 149 */             index = getNextIndex(index);
/*     */         }
/*     */       }
/*     */       catch (RuntimeException ex)
/*     */       {
/* 154 */         doNext = false;
/* 155 */         processHandlerFailure(ex);
/*     */       }
/*     */       finally
/*     */       {
/* 160 */         if (!doNext) {
/* 161 */           this.falseIndex = index;
/*     */         }
/* 163 */         log.debug("Exit: handle" + (this.isOutbound.booleanValue() ? "Out" : "In ") + "BoundMessage with status: " + doNext);
/*     */       }
/*     */     }
/*     */ 
/* 167 */     return doNext;
/*     */   }
/*     */ 
/*     */   public boolean handleFault(MessageContext msgContext, Exception ex)
/*     */   {
/* 172 */     this.isOutbound = ((Boolean)msgContext.get("javax.xml.ws.handler.message.outbound"));
/* 173 */     if (this.isOutbound == null) {
/* 174 */       throw new IllegalStateException("Cannot find property: javax.xml.ws.handler.message.outbound");
/*     */     }
/* 176 */     boolean doNext = true;
/*     */ 
/* 178 */     if (this.handlers.size() > 0)
/*     */     {
/* 180 */       log.debug("Enter: handle" + (this.isOutbound.booleanValue() ? "Out" : "In ") + "BoundFault");
/*     */ 
/* 182 */       if ((msgContext instanceof SOAPMessageContext))
/*     */       {
/* 184 */         SOAPMessageContext soapContext = (SOAPMessageContext)msgContext;
/* 185 */         SOAPMessage soapMessage = soapContext.getMessage();
/*     */         try
/*     */         {
/* 190 */           if ((soapMessage == null) || (soapMessage.getSOAPBody().getFault() == null))
/*     */           {
/* 192 */             soapMessage = SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
/* 193 */             soapContext.setMessage(soapMessage);
/*     */           }
/*     */         }
/*     */         catch (SOAPException se)
/*     */         {
/* 198 */           throw new WebServiceException("Cannot convert exception to fault message", ex);
/*     */         }
/*     */       }
/*     */ 
/* 202 */       int index = getFirstHandler();
/*     */ 
/* 204 */       Handler currHandler = null;
/*     */       try
/*     */       {
/* 207 */         String lastMessageTrace = null;
/* 208 */         while ((doNext) && (index >= 0))
/*     */         {
/* 210 */           currHandler = (Handler)this.handlers.get(index);
/*     */ 
/* 212 */           if ((log.isTraceEnabled()) && ((msgContext instanceof SOAPMessageContext)))
/*     */           {
/* 214 */             SOAPPart soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
/* 215 */             lastMessageTrace = traceSOAPPart("BEFORE handleFault - " + currHandler, soapPart, lastMessageTrace);
/*     */           }
/*     */ 
/* 218 */           doNext = handleFault(currHandler, msgContext);
/*     */ 
/* 220 */           if ((log.isTraceEnabled()) && ((msgContext instanceof SOAPMessageContext)))
/*     */           {
/* 222 */             SOAPPart soapPart = ((SOAPMessageContext)msgContext).getMessage().getSOAPPart();
/* 223 */             lastMessageTrace = traceSOAPPart("AFTER handleFault - " + currHandler, soapPart, lastMessageTrace);
/*     */           }
/*     */ 
/* 226 */           index = getNextIndex(index);
/*     */         }
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 231 */         doNext = false;
/* 232 */         processHandlerFailure(rte);
/*     */       }
/*     */       finally
/*     */       {
/* 236 */         log.debug("Exit: handle" + (this.isOutbound.booleanValue() ? "Out" : "In ") + "BoundFault with status: " + doNext);
/*     */       }
/*     */     }
/*     */ 
/* 240 */     return doNext;
/*     */   }
/*     */ 
/*     */   private int getFirstHandler()
/*     */   {
/*     */     int index;
/*     */     int index;
/* 246 */     if (this.falseIndex == -1)
/*     */     {
/* 248 */       index = this.isOutbound.booleanValue() ? 0 : this.handlers.size() - 1;
/*     */     }
/*     */     else
/*     */     {
/* 252 */       index = getNextIndex(this.falseIndex);
/*     */     }
/* 254 */     return index;
/*     */   }
/*     */ 
/*     */   private int getNextIndex(int prevIndex)
/*     */   {
/* 259 */     int nextIndex = this.isOutbound.booleanValue() ? prevIndex + 1 : prevIndex - 1;
/* 260 */     if (nextIndex >= this.handlers.size())
/* 261 */       nextIndex = -1;
/* 262 */     return nextIndex;
/*     */   }
/*     */ 
/*     */   private void processHandlerFailure(Exception ex)
/*     */   {
/* 271 */     log.error("Exception during handler processing", ex);
/* 272 */     if ((ex instanceof WebServiceException))
/*     */     {
/* 274 */       throw ((WebServiceException)ex);
/*     */     }
/* 276 */     throw new WebServiceException(ex);
/*     */   }
/*     */ 
/*     */   private boolean handleMessage(Handler currHandler, MessageContext msgContext)
/*     */   {
/* 281 */     CommonMessageContext context = (CommonMessageContext)msgContext;
/* 282 */     if ((currHandler instanceof LogicalHandler))
/*     */     {
/* 284 */       if ((msgContext instanceof SOAPMessageContextJAXWS)) {
/* 285 */         msgContext = new LogicalMessageContextImpl((SOAPMessageContextJAXWS)msgContext);
/*     */       }
/*     */     }
/* 288 */     if (!this.executedHandlers.contains(currHandler)) {
/* 289 */       this.executedHandlers.add(currHandler);
/*     */     }
/*     */     try
/*     */     {
/* 293 */       context.put(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/* 294 */       context.setCurrentScope(MessageContext.Scope.HANDLER);
/* 295 */       boolean bool = currHandler.handleMessage(msgContext);
/*     */       return bool;
/*     */     }
/*     */     finally
/*     */     {
/* 299 */       context.setCurrentScope(MessageContext.Scope.APPLICATION);
/* 300 */       context.remove(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM); } throw localObject;
/*     */   }
/*     */ 
/*     */   private boolean handleFault(Handler currHandler, MessageContext msgContext)
/*     */   {
/* 306 */     CommonMessageContext context = (CommonMessageContext)msgContext;
/* 307 */     if ((currHandler instanceof LogicalHandler))
/*     */     {
/* 309 */       if ((msgContext instanceof SOAPMessageContextJAXWS)) {
/* 310 */         msgContext = new LogicalMessageContextImpl((SOAPMessageContextJAXWS)msgContext);
/*     */       }
/*     */     }
/* 313 */     if (!this.executedHandlers.contains(currHandler)) {
/* 314 */       this.executedHandlers.add(currHandler);
/*     */     }
/*     */     try
/*     */     {
/* 318 */       context.put(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/* 319 */       context.setCurrentScope(MessageContext.Scope.HANDLER);
/* 320 */       boolean bool = currHandler.handleFault(msgContext);
/*     */       return bool;
/*     */     }
/*     */     finally
/*     */     {
/* 324 */       context.setCurrentScope(MessageContext.Scope.APPLICATION);
/* 325 */       context.remove(MessageContextJAXWS.ALLOW_EXPAND_TO_DOM); } throw localObject;
/*     */   }
/*     */ 
/*     */   protected String traceSOAPPart(String logMsg, SOAPPart soapPart, String lastMessageTrace)
/*     */   {
/*     */     try
/*     */     {
/* 336 */       SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)soapPart.getEnvelope();
/* 337 */       String envString = DOMWriter.printNode(soapEnv, true);
/* 338 */       if (envString.equals(lastMessageTrace))
/*     */       {
/* 340 */         log.trace(logMsg + ": unchanged");
/*     */       }
/*     */       else
/*     */       {
/* 344 */         log.trace(logMsg + "\n" + envString);
/* 345 */         lastMessageTrace = envString;
/*     */       }
/* 347 */       return lastMessageTrace;
/*     */     }
/*     */     catch (SOAPException e)
/*     */     {
/* 351 */       log.error("Cannot get SOAPEnvelope", e);
/* 352 */     }return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.HandlerChainExecutor
 * JD-Core Version:    0.6.0
 */