/*    */ package org.jboss.ws.core.jaxws.handler;
/*    */ 
/*    */ import javax.xml.ws.handler.Handler;
/*    */ import javax.xml.ws.handler.MessageContext;
/*    */ 
/*    */ public abstract class GenericHandler
/*    */   implements Handler
/*    */ {
/*    */   private String handlerName;
/*    */ 
/*    */   public String getHandlerName()
/*    */   {
/* 41 */     return this.handlerName;
/*    */   }
/*    */ 
/*    */   public void setHandlerName(String handlerName)
/*    */   {
/* 46 */     this.handlerName = handlerName;
/*    */   }
/*    */ 
/*    */   public boolean handleMessage(MessageContext msgContext)
/*    */   {
/* 51 */     Boolean outbound = (Boolean)msgContext.get("javax.xml.ws.handler.message.outbound");
/* 52 */     if (outbound == null) {
/* 53 */       throw new IllegalStateException("Cannot obtain required property: javax.xml.ws.handler.message.outbound");
/*    */     }
/* 55 */     return outbound.booleanValue() ? handleOutbound(msgContext) : handleInbound(msgContext);
/*    */   }
/*    */ 
/*    */   protected boolean handleOutbound(MessageContext msgContext)
/*    */   {
/* 60 */     return true;
/*    */   }
/*    */ 
/*    */   protected boolean handleInbound(MessageContext msgContext)
/*    */   {
/* 65 */     return true;
/*    */   }
/*    */ 
/*    */   public boolean handleFault(MessageContext messagecontext)
/*    */   {
/* 70 */     return true;
/*    */   }
/*    */ 
/*    */   public void close(MessageContext messageContext)
/*    */   {
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 79 */     return this.handlerName != null ? this.handlerName : super.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.handler.GenericHandler
 * JD-Core Version:    0.6.0
 */