/*    */ package org.jboss.ws.core.jaxws.client;
/*    */ 
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectOutputStream;
/*    */ import javax.naming.BinaryRefAddr;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.Referenceable;
/*    */ import javax.naming.StringRefAddr;
/*    */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*    */ 
/*    */ public class ServiceReferenceable
/*    */   implements Referenceable
/*    */ {
/*    */   public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
/*    */   public static final String SERVICE_IMPL_CLASS = "SERVICE_CLASS_NAME";
/*    */   public static final String TARGET_CLASS_NAME = "TARGET_CLASS_NAME";
/*    */   private String serviceImplClass;
/*    */   private String targetClassName;
/*    */   private UnifiedServiceRefMetaData serviceRef;
/*    */ 
/*    */   public ServiceReferenceable(String serviceImplClass, String targetClassName, UnifiedServiceRefMetaData serviceRef)
/*    */   {
/* 61 */     this.serviceImplClass = serviceImplClass;
/* 62 */     this.targetClassName = targetClassName;
/* 63 */     this.serviceRef = serviceRef;
/*    */   }
/*    */ 
/*    */   public Reference getReference()
/*    */     throws NamingException
/*    */   {
/* 74 */     Reference myRef = new Reference(ServiceReferenceable.class.getName(), ServiceObjectFactoryJAXWS.class.getName(), null);
/*    */ 
/* 76 */     myRef.add(new StringRefAddr("SERVICE_CLASS_NAME", this.serviceImplClass));
/* 77 */     myRef.add(new StringRefAddr("TARGET_CLASS_NAME", this.targetClassName));
/* 78 */     myRef.add(new BinaryRefAddr("SERVICE_REF_META_DATA", marshall(this.serviceRef)));
/*    */ 
/* 80 */     return myRef;
/*    */   }
/*    */ 
/*    */   private byte[] marshall(Object obj) throws NamingException
/*    */   {
/* 85 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
/*    */     try
/*    */     {
/* 88 */       ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 89 */       oos.writeObject(obj);
/* 90 */       oos.close();
/*    */     }
/*    */     catch (IOException e)
/*    */     {
/* 94 */       throw new NamingException("Cannot marshall object, cause: " + e.toString());
/*    */     }
/* 96 */     return baos.toByteArray();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.ServiceReferenceable
 * JD-Core Version:    0.6.0
 */