/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ExecutionException;
/*     */ import java.util.concurrent.Future;
/*     */ import java.util.concurrent.TimeUnit;
/*     */ import java.util.concurrent.TimeoutException;
/*     */ import javax.xml.ws.Response;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ 
/*     */ public class ResponseImpl
/*     */   implements Response
/*     */ {
/*     */   private Future delegate;
/*     */   private Object result;
/*     */   private WebServiceException exception;
/*  48 */   private Map<String, Object> context = new HashMap();
/*     */ 
/*     */   public void setException(WebServiceException ex)
/*     */   {
/*  53 */     this.exception = ex;
/*     */   }
/*     */ 
/*     */   public Future getFuture()
/*     */   {
/*  58 */     if (this.delegate == null) {
/*  59 */       throw new IllegalStateException("Future not available");
/*     */     }
/*  61 */     if (this.exception != null) {
/*  62 */       throw this.exception;
/*     */     }
/*  64 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public void setFuture(Future delegate)
/*     */   {
/*  69 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getContext()
/*     */   {
/*  74 */     return this.context;
/*     */   }
/*     */ 
/*     */   void set(Object result)
/*     */   {
/*  79 */     this.result = result;
/*     */   }
/*     */ 
/*     */   public boolean cancel(boolean mayInterruptIfRunning)
/*     */   {
/*  84 */     return getFuture().cancel(mayInterruptIfRunning);
/*     */   }
/*     */ 
/*     */   public Object get() throws InterruptedException, ExecutionException
/*     */   {
/*  89 */     if (this.result == null)
/*     */     {
/*  91 */       getFuture().get();
/*     */     }
/*     */ 
/*  94 */     if (this.exception != null) {
/*  95 */       throw new ExecutionException(this.exception);
/*     */     }
/*  97 */     return this.result;
/*     */   }
/*     */ 
/*     */   public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException
/*     */   {
/* 102 */     if (this.result == null)
/*     */     {
/* 104 */       getFuture().get(timeout, unit);
/*     */     }
/*     */ 
/* 107 */     if (this.exception != null) {
/* 108 */       throw new ExecutionException(this.exception);
/*     */     }
/* 110 */     return this.result;
/*     */   }
/*     */ 
/*     */   public boolean isCancelled()
/*     */   {
/* 115 */     return getFuture().isCancelled();
/*     */   }
/*     */ 
/*     */   public boolean isDone()
/*     */   {
/* 120 */     return getFuture().isDone();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.ResponseImpl
 * JD-Core Version:    0.6.0
 */