/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ExecutorService;
/*     */ import java.util.concurrent.Future;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFactory;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.AsyncHandler;
/*     */ import javax.xml.ws.Binding;
/*     */ import javax.xml.ws.Binding21;
/*     */ import javax.xml.ws.BindingProvider;
/*     */ import javax.xml.ws.Dispatch;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.Response;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.PortInfo;
/*     */ import javax.xml.ws.soap.SOAPFaultException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.ConfigProvider;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.client.EndpointInfo;
/*     */ import org.jboss.ws.core.client.HTTPRemotingConnection;
/*     */ import org.jboss.ws.core.client.RemotingConnection;
/*     */ import org.jboss.ws.core.client.SOAPRemotingConnection;
/*     */ import org.jboss.ws.core.jaxws.binding.BindingExt;
/*     */ import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
/*     */ import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
/*     */ import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
/*     */ import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.metadata.config.ConfigurationProvider;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class DispatchImpl<T>
/*     */   implements Dispatch<T>, ConfigProvider
/*     */ {
/*  93 */   private final Logger log = Logger.getLogger(DispatchImpl.class);
/*     */   private BindingProvider bindingProvider;
/*     */   private HandlerResolverImpl handlerResolver;
/*     */   private ClientEndpointMetaData epMetaData;
/*     */   private JAXBContext jaxbContext;
/*     */   private ExecutorService executor;
/*     */   private String securityConfig;
/*     */   private Class type;
/*     */   private Service.Mode mode;
/* 104 */   private Map<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor> executorMap = new HashMap();
/*     */ 
/*     */   public DispatchImpl(ExecutorService executor, EndpointMetaData epMetaData, Class<T> type, Service.Mode mode)
/*     */   {
/* 108 */     this.bindingProvider = new BindingProviderImpl(epMetaData);
/* 109 */     this.epMetaData = ((ClientEndpointMetaData)epMetaData);
/* 110 */     this.executor = executor;
/* 111 */     this.type = type;
/* 112 */     this.mode = mode;
/* 113 */     initDispatch();
/*     */   }
/*     */ 
/*     */   public DispatchImpl(ExecutorService executor, EndpointMetaData epMetaData, JAXBContext jbc, Service.Mode mode)
/*     */   {
/* 118 */     this.bindingProvider = new BindingProviderImpl(epMetaData);
/* 119 */     this.epMetaData = ((ClientEndpointMetaData)epMetaData);
/* 120 */     this.executor = executor;
/* 121 */     this.type = Object.class;
/* 122 */     this.jaxbContext = jbc;
/* 123 */     this.mode = mode;
/* 124 */     initDispatch();
/*     */   }
/*     */ 
/*     */   public T invoke(T obj)
/*     */   {
/* 129 */     Object retObj = null;
/*     */     try
/*     */     {
/* 132 */       retObj = invokeInternal(obj, getResponseContext());
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 136 */       handleInvokeException(ex);
/*     */     }
/* 138 */     return retObj;
/*     */   }
/*     */ 
/*     */   private Object invokeInternal(Object obj, Map<String, Object> resContext) throws Exception
/*     */   {
/* 143 */     Object retObj = null;
/*     */ 
/* 145 */     BindingExt binding = (BindingExt)this.bindingProvider.getBinding();
/*     */ 
/* 147 */     String bindingID = binding.getBindingID();
/* 148 */     if (bindingID.indexOf("soap") > 0)
/*     */     {
/* 151 */       if (this.handlerResolver == null)
/*     */       {
/* 153 */         this.handlerResolver = new HandlerResolverImpl();
/* 154 */         this.handlerResolver.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.PRE, true);
/* 155 */         this.handlerResolver.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, true);
/* 156 */         this.handlerResolver.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.POST, true);
/*     */ 
/* 158 */         PortInfo portInfo = this.epMetaData.getPortInfo();
/* 159 */         List preChain = this.handlerResolver.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.PRE);
/* 160 */         List epChain = this.handlerResolver.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 161 */         List postChain = this.handlerResolver.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.POST);
/*     */ 
/* 163 */         binding.setHandlerChain(preChain, UnifiedHandlerMetaData.HandlerType.PRE);
/* 164 */         binding.setHandlerChain(epChain, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
/* 165 */         binding.setHandlerChain(postChain, UnifiedHandlerMetaData.HandlerType.POST);
/*     */       }
/*     */ 
/* 168 */       retObj = invokeInternalSOAP(obj);
/*     */     }
/*     */     else
/*     */     {
/* 172 */       retObj = invokeInternalNonSOAP(obj);
/*     */     }
/* 174 */     return retObj;
/*     */   }
/*     */ 
/*     */   private Object invokeInternalSOAP(Object obj) throws Exception
/*     */   {
/* 179 */     Object retObj = null;
/*     */ 
/* 181 */     SOAPMessageImpl reqMsg = (SOAPMessageImpl)getRequestMessage(obj);
/* 182 */     String targetAddress = this.epMetaData.getEndpointAddress();
/*     */ 
/* 192 */     String soapAction = null;
/* 193 */     Map reqContext = getRequestContext();
/* 194 */     Boolean useSOAPAction = (Boolean)reqContext.get("javax.xml.ws.soap.http.soapaction.use");
/* 195 */     if (Boolean.TRUE.equals(useSOAPAction))
/*     */     {
/* 197 */       soapAction = (String)reqContext.get("javax.xml.ws.soap.http.soapaction.uri");
/* 198 */       if (soapAction == null)
/* 199 */         throw new IllegalStateException("Cannot obtain: javax.xml.ws.soap.http.soapaction.uri");
/*     */     }
/* 201 */     MimeHeaders mimeHeaders = reqMsg.getMimeHeaders();
/* 202 */     mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
/*     */ 
/* 205 */     UnifiedHandlerMetaData.HandlerType[] handlerType = { UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST };
/* 206 */     UnifiedHandlerMetaData.HandlerType[] faultType = { UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST };
/*     */ 
/* 209 */     CommonMessageContext msgContext = new SOAPMessageContextJAXWS();
/* 210 */     MessageContextAssociation.pushMessageContext(msgContext);
/* 211 */     msgContext.setEndpointMetaData(this.epMetaData);
/* 212 */     msgContext.setSOAPMessage(reqMsg);
/* 213 */     msgContext.putAll(reqContext);
/*     */ 
/* 218 */     msgContext.put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
/*     */ 
/* 220 */     QName portName = this.epMetaData.getPortName();
/*     */     try
/*     */     {
/* 224 */       boolean handlerPass = callRequestHandlerChain(portName, handlerType[0]);
/* 225 */       handlerPass = (handlerPass) && (callRequestHandlerChain(portName, handlerType[1]));
/* 226 */       handlerPass = (handlerPass) && (callRequestHandlerChain(portName, handlerType[2]));
/*     */ 
/* 229 */       reqMsg = (SOAPMessageImpl)msgContext.getSOAPMessage();
/*     */ 
/* 231 */       MessageAbstraction resMsg = null;
/* 232 */       if (handlerPass)
/*     */       {
/* 234 */         Map callProps = new HashMap(getRequestContext());
/* 235 */         EndpointInfo epInfo = new EndpointInfo(this.epMetaData, targetAddress, callProps);
/* 236 */         resMsg = getRemotingConnection().invoke(reqMsg, epInfo, false);
/*     */ 
/* 239 */         handlerPass = callResponseHandlerChain(portName, handlerType[2]);
/* 240 */         faultType[2] = null;
/* 241 */         handlerPass = (handlerPass) && (callResponseHandlerChain(portName, handlerType[1]));
/* 242 */         faultType[1] = null;
/* 243 */         handlerPass = (handlerPass) && (callResponseHandlerChain(portName, handlerType[0]));
/* 244 */         faultType[0] = null;
/*     */       }
/*     */ 
/* 247 */       if (handlerPass)
/*     */       {
/* 249 */         retObj = getReturnObject(resMsg);
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 254 */       if (faultType[2] != null)
/* 255 */         callFaultHandlerChain(portName, faultType[2], ex);
/* 256 */       if (faultType[1] != null)
/* 257 */         callFaultHandlerChain(portName, faultType[1], ex);
/* 258 */       if (faultType[0] != null) {
/* 259 */         callFaultHandlerChain(portName, faultType[0], ex);
/*     */       }
/* 261 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 265 */       closeHandlerChain(portName, handlerType[2]);
/* 266 */       closeHandlerChain(portName, handlerType[1]);
/* 267 */       closeHandlerChain(portName, handlerType[0]);
/*     */ 
/* 269 */       MessageContextAssociation.popMessageContext();
/*     */     }
/* 271 */     return retObj;
/*     */   }
/*     */ 
/*     */   private Object invokeInternalNonSOAP(Object obj) throws IOException
/*     */   {
/* 276 */     MessageAbstraction reqMsg = getRequestMessage(obj);
/* 277 */     String targetAddress = this.epMetaData.getEndpointAddress();
/* 278 */     MessageAbstraction resMsg = getRemotingConnection().invoke(reqMsg, targetAddress, false);
/* 279 */     Object retObj = getReturnObject(resMsg);
/* 280 */     return retObj;
/*     */   }
/*     */ 
/*     */   private RemotingConnection getRemotingConnection()
/*     */   {
/* 285 */     String bindingID = ((Binding21)this.bindingProvider.getBinding()).getBindingID();
/* 286 */     if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID))
/* 287 */       throw new IllegalStateException("Unsupported binding: " + bindingID);
/*     */     RemotingConnection remotingConnection;
/*     */     RemotingConnection remotingConnection;
/* 290 */     if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID))
/*     */     {
/* 292 */       remotingConnection = new HTTPRemotingConnection();
/*     */     }
/*     */     else
/*     */     {
/* 296 */       remotingConnection = new SOAPRemotingConnection();
/*     */     }
/* 298 */     return remotingConnection;
/*     */   }
/*     */ 
/*     */   public Response<T> invokeAsync(T msg)
/*     */   {
/* 303 */     ResponseImpl response = new ResponseImpl();
/* 304 */     Runnable task = new AsyncRunnable(response, null, msg);
/* 305 */     Future future = this.executor.submit(task);
/* 306 */     response.setFuture(future);
/* 307 */     return response;
/*     */   }
/*     */ 
/*     */   public Future invokeAsync(T obj, AsyncHandler<T> handler)
/*     */   {
/* 312 */     ResponseImpl response = new ResponseImpl();
/* 313 */     Runnable task = new AsyncRunnable(response, handler, obj);
/* 314 */     Future future = this.executor.submit(task);
/* 315 */     response.setFuture(future);
/* 316 */     return response;
/*     */   }
/*     */ 
/*     */   public void invokeOneWay(T msg)
/*     */   {
/*     */     try
/*     */     {
/* 323 */       MessageAbstraction reqMsg = getRequestMessage(msg);
/* 324 */       String targetAddress = this.epMetaData.getEndpointAddress();
/* 325 */       getRemotingConnection().invoke(reqMsg, targetAddress, true);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 329 */       handleInvokeException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleInvokeException(Exception ex)
/*     */   {
/* 342 */     if ((ex instanceof WebServiceException))
/*     */     {
/* 344 */       throw ((WebServiceException)ex);
/*     */     }
/*     */ 
/* 347 */     String msg = "Cannot dispatch message";
/* 348 */     this.log.error(msg, ex);
/* 349 */     throw new WebServiceException(msg, ex);
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getRequestContext()
/*     */   {
/* 354 */     return this.bindingProvider.getRequestContext();
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getResponseContext()
/*     */   {
/* 359 */     return this.bindingProvider.getResponseContext();
/*     */   }
/*     */ 
/*     */   public Binding getBinding()
/*     */   {
/* 364 */     return this.bindingProvider.getBinding();
/*     */   }
/*     */ 
/*     */   private void initDispatch()
/*     */   {
/* 369 */     if ((!SOAPMessage.class.isAssignableFrom(this.type)) || (this.mode != Service.Mode.MESSAGE))
/*     */     {
/* 373 */       if (!Source.class.isAssignableFrom(this.type))
/*     */       {
/* 377 */         if ((this.jaxbContext == null) || (this.mode != Service.Mode.PAYLOAD))
/*     */         {
/* 383 */           throw new WebServiceException("Illegal argument combination [type=" + (this.type != null ? this.type.getName() : null) + ",mode=" + this.mode + "]");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private MessageAbstraction getRequestMessage(Object obj) {
/* 390 */     if (obj == null)
/*     */     {
/*     */       try
/*     */       {
/* 394 */         SOAPFactory factory = SOAPFactory.newInstance();
/* 395 */         SOAPFault fault = factory.createFault("Request object cannot be null", new QName("http://org.jboss.ws", "Dispatch"));
/* 396 */         fault.setFaultActor("client");
/* 397 */         throw new SOAPFaultException(fault);
/*     */       }
/*     */       catch (SOAPException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 405 */     String bindingID = ((Binding21)this.bindingProvider.getBinding()).getBindingID();
/* 406 */     if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID))
/* 407 */       throw new IllegalStateException("Unsupported binding: " + bindingID);
/*     */     MessageAbstraction message;
/*     */     MessageAbstraction message;
/* 410 */     if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID))
/*     */     {
/* 412 */       DispatchHTTPBinding helper = new DispatchHTTPBinding(this.mode, this.type, this.jaxbContext);
/* 413 */       this.epMetaData.configure(helper);
/* 414 */       message = helper.getRequestMessage(obj);
/*     */     }
/*     */     else
/*     */     {
/* 418 */       DispatchSOAPBinding helper = new DispatchSOAPBinding(this.mode, this.type, this.jaxbContext);
/* 419 */       this.epMetaData.configure(helper);
/* 420 */       message = helper.getRequestMessage(obj);
/*     */     }
/* 422 */     return message;
/*     */   }
/*     */ 
/*     */   private Object getReturnObject(MessageAbstraction resMsg)
/*     */   {
/* 427 */     String bindingID = ((Binding21)this.bindingProvider.getBinding()).getBindingID();
/* 428 */     if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID)) {
/* 429 */       throw new IllegalStateException("Unsupported binding: " + bindingID);
/*     */     }
/* 431 */     Object retObj = null;
/* 432 */     if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID))
/*     */     {
/* 434 */       DispatchHTTPBinding helper = new DispatchHTTPBinding(this.mode, this.type, this.jaxbContext);
/* 435 */       retObj = helper.getReturnObject(resMsg);
/*     */     }
/*     */     else
/*     */     {
/* 439 */       DispatchSOAPBinding helper = new DispatchSOAPBinding(this.mode, this.type, this.jaxbContext);
/* 440 */       retObj = helper.getReturnObject(resMsg);
/*     */     }
/* 442 */     return retObj;
/*     */   }
/*     */ 
/*     */   public EndpointReference getEndpointReference()
/*     */   {
/* 507 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T extends EndpointReference> T getEndpointReference(Class<T> clazz)
/*     */   {
/* 512 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public String getConfigFile()
/*     */   {
/* 517 */     return this.epMetaData.getConfigFile();
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/* 522 */     return this.epMetaData.getConfigName();
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/* 527 */     this.epMetaData.setConfigName(configName);
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName, String configFile)
/*     */   {
/* 532 */     this.epMetaData.setConfigName(configName, configFile);
/*     */   }
/*     */ 
/*     */   public String getSecurityConfig()
/*     */   {
/* 537 */     return this.securityConfig;
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(String securityConfig)
/*     */   {
/* 542 */     this.securityConfig = securityConfig;
/*     */ 
/* 544 */     if (securityConfig != null)
/*     */     {
/* 546 */       ServiceMetaData serviceMetaData = this.epMetaData.getServiceMetaData();
/* 547 */       if (serviceMetaData.getSecurityConfiguration() == null)
/*     */       {
/*     */         try
/*     */         {
/* 551 */           WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
/* 552 */           UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
/* 553 */           WSSecurityConfiguration config = wsseConfFactory.createConfiguration(vfsRoot, securityConfig);
/* 554 */           serviceMetaData.setSecurityConfiguration(config);
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/* 558 */           WSException.rethrow("Cannot set security config", ex);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 566 */     BindingExt binding = (BindingExt)this.bindingProvider.getBinding();
/* 567 */     HandlerChainExecutor executor = new HandlerChainExecutor(this.epMetaData, binding.getHandlerChain(type));
/* 568 */     this.executorMap.put(type, executor);
/*     */ 
/* 570 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 571 */     return executor.handleMessage(msgContext);
/*     */   }
/*     */ 
/*     */   private boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 576 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 577 */     HandlerChainExecutor executor = (HandlerChainExecutor)this.executorMap.get(type);
/* 578 */     return executor != null ? executor.handleMessage(msgContext) : true;
/*     */   }
/*     */ 
/*     */   private boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/* 583 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 584 */     HandlerChainExecutor executor = (HandlerChainExecutor)this.executorMap.get(type);
/* 585 */     return executor != null ? executor.handleFault(msgContext, ex) : true;
/*     */   }
/*     */ 
/*     */   private void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 590 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 591 */     HandlerChainExecutor executor = (HandlerChainExecutor)this.executorMap.get(type);
/* 592 */     if (executor != null)
/* 593 */       executor.close(msgContext);
/*     */   }
/*     */ 
/*     */   class AsyncRunnable
/*     */     implements Runnable
/*     */   {
/*     */     private ResponseImpl response;
/*     */     private AsyncHandler handler;
/*     */     private Object payload;
/*     */ 
/*     */     public AsyncRunnable(ResponseImpl response, AsyncHandler handler, Object payload)
/*     */     {
/* 453 */       if (response == null)
/* 454 */         throw new IllegalArgumentException("Async response cannot be null");
/* 455 */       if (payload == null) {
/* 456 */         throw new IllegalArgumentException("Async payload cannot be null");
/*     */       }
/* 458 */       this.response = response;
/* 459 */       this.handler = handler;
/* 460 */       this.payload = payload;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 467 */         Map resContext = this.response.getContext();
/* 468 */         Object result = DispatchImpl.this.invokeInternal(this.payload, resContext);
/* 469 */         this.response.set(result);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 473 */         handleAsynInvokeException(ex);
/*     */       }
/*     */       finally
/*     */       {
/* 478 */         if (this.handler != null)
/* 479 */           this.handler.handleResponse(this.response);
/*     */       }
/*     */     }
/*     */ 
/*     */     private void handleAsynInvokeException(Exception ex)
/*     */     {
/* 489 */       String msg = "Cannot dispatch message";
/* 490 */       DispatchImpl.this.log.error(msg, ex);
/*     */       WebServiceException wsex;
/*     */       WebServiceException wsex;
/* 493 */       if ((ex instanceof WebServiceException))
/*     */       {
/* 495 */         wsex = (WebServiceException)ex;
/*     */       }
/*     */       else
/*     */       {
/* 499 */         wsex = new WebServiceException(msg, ex);
/*     */       }
/* 501 */       this.response.setException(wsex);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.DispatchImpl
 * JD-Core Version:    0.6.0
 */