/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.Marshaller;
/*     */ import javax.xml.bind.Unmarshaller;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.HTTPMessageImpl;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ 
/*     */ public class DispatchHTTPBinding extends DispatchBinding
/*     */ {
/*  48 */   private final Logger log = Logger.getLogger(DispatchHTTPBinding.class);
/*     */   private JAXBContext jaxbContext;
/*     */   private Class type;
/*     */   private Service.Mode mode;
/*     */ 
/*     */   public DispatchHTTPBinding(Service.Mode mode, Class type, JAXBContext jaxbContext)
/*     */   {
/*  56 */     this.mode = mode;
/*  57 */     this.type = type;
/*  58 */     this.jaxbContext = jaxbContext;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction getRequestMessage(Object obj)
/*     */   {
/*  63 */     HTTPMessageImpl reqMsg = null;
/*     */     try
/*     */     {
/*  66 */       if (Source.class.isAssignableFrom(this.type))
/*     */       {
/*  68 */         Source source = (Source)obj;
/*  69 */         reqMsg = new HTTPMessageImpl(source);
/*  70 */         if (this.validateDispatch)
/*  71 */           reqMsg.doValidate();
/*     */       }
/*  73 */       else if (this.jaxbContext != null)
/*     */       {
/*  75 */         Marshaller marshaller = this.jaxbContext.createMarshaller();
/*  76 */         marshaller.setProperty("jaxb.fragment", Boolean.valueOf(true));
/*  77 */         BufferedStreamResult result = new BufferedStreamResult();
/*  78 */         marshaller.marshal(obj, result);
/*     */ 
/*  80 */         reqMsg = new HTTPMessageImpl(result);
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/*  85 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  89 */       throw new WebServiceException("Cannot create request message", ex);
/*     */     }
/*     */ 
/*  92 */     if (reqMsg == null) {
/*  93 */       throw new WebServiceException("Cannot create request message for: " + obj);
/*     */     }
/*  95 */     return reqMsg;
/*     */   }
/*     */ 
/*     */   public Object getReturnObject(MessageAbstraction message)
/*     */   {
/* 100 */     HTTPMessageImpl resMsg = (HTTPMessageImpl)message;
/*     */ 
/* 102 */     Object retObj = null;
/*     */     try
/*     */     {
/* 105 */       if (Source.class.isAssignableFrom(this.type))
/*     */       {
/* 107 */         retObj = resMsg.getXmlFragment().getSource();
/*     */       }
/* 109 */       else if (this.jaxbContext != null)
/*     */       {
/* 111 */         Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
/* 112 */         Source source = resMsg.getXmlFragment().getSource();
/* 113 */         retObj = unmarshaller.unmarshal(source);
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 118 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 122 */       throw new WebServiceException("Cannot process response message", ex);
/*     */     }
/* 124 */     return retObj;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.DispatchHTTPBinding
 * JD-Core Version:    0.6.0
 */