/*     */ package org.jboss.ws.core.jaxws.client;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Observable;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.Binding;
/*     */ import javax.xml.ws.BindingProvider;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.handler.HandlerResolver;
/*     */ import javax.xml.ws.handler.MessageContext;
/*     */ import javax.xml.ws.handler.PortInfo;
/*     */ import javax.xml.ws.handler.soap.SOAPHandler;
/*     */ import javax.xml.ws.http.HTTPException;
/*     */ import javax.xml.ws.soap.SOAPFaultException;
/*     */ import javax.xml.ws.wsaddressing.BindingProvider21;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.core.CommonClient;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.jaxws.binding.BindingExt;
/*     */ import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
/*     */ import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
/*     */ import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
/*     */ import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
/*     */ import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.metadata.config.Configurable;
/*     */ import org.jboss.ws.metadata.config.ConfigurationProvider;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class ClientImpl extends CommonClient
/*     */   implements BindingProvider21, Configurable
/*     */ {
/*  80 */   private static Logger log = Logger.getLogger(ClientImpl.class);
/*     */   private final ClientEndpointMetaData epMetaData;
/*     */   private final HandlerResolver handlerResolver;
/*  88 */   private Map<UnifiedHandlerMetaData.HandlerType, HandlerChainExecutor> executorMap = new HashMap();
/*  89 */   private static UnifiedHandlerMetaData.HandlerType[] HANDLER_TYPES = { UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST };
/*     */ 
/*     */   public ClientImpl(EndpointMetaData epMetaData, HandlerResolver handlerResolver)
/*     */   {
/*  93 */     super(epMetaData);
/*  94 */     setTargetEndpointAddress(epMetaData.getEndpointAddress());
/*     */ 
/*  96 */     this.epMetaData = ((ClientEndpointMetaData)epMetaData);
/*  97 */     this.handlerResolver = handlerResolver;
/*     */ 
/*  99 */     initBindingHandlerChain(false);
/*     */ 
/* 104 */     epMetaData.registerConfigObserver(this);
/*     */   }
/*     */ 
/*     */   private void initBindingHandlerChain(boolean clearExistingHandlers)
/*     */   {
/* 112 */     BindingExt binding = (BindingExt)getBindingProvider().getBinding();
/*     */ 
/* 114 */     PortInfo portInfo = this.epMetaData.getPortInfo();
/*     */ 
/* 116 */     if (this.handlerResolver != null)
/*     */     {
/* 119 */       boolean jbossHandlerResolver = this.handlerResolver instanceof HandlerResolverImpl;
/*     */ 
/* 121 */       if (jbossHandlerResolver)
/*     */       {
/* 123 */         HandlerResolverImpl impl = (HandlerResolverImpl)this.handlerResolver;
/* 124 */         impl.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.PRE, clearExistingHandlers);
/* 125 */         impl.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.ENDPOINT, clearExistingHandlers);
/* 126 */         impl.initHandlerChain(this.epMetaData, UnifiedHandlerMetaData.HandlerType.POST, clearExistingHandlers);
/*     */ 
/* 128 */         List preChain = impl.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.PRE);
/* 129 */         List postChain = impl.getHandlerChain(portInfo, UnifiedHandlerMetaData.HandlerType.POST);
/*     */ 
/* 131 */         binding.setHandlerChain(postChain, UnifiedHandlerMetaData.HandlerType.POST);
/* 132 */         binding.setHandlerChain(preChain, UnifiedHandlerMetaData.HandlerType.PRE);
/*     */       }
/*     */ 
/* 136 */       List endpointChain = this.handlerResolver.getHandlerChain(portInfo);
/* 137 */       binding.setHandlerChain(endpointChain);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void update(Observable observable, Object object)
/*     */   {
/* 146 */     log.debug("Configuration change event received. Reconfigure handler chain: " + object);
/*     */ 
/* 149 */     initBindingHandlerChain(true);
/*     */   }
/*     */ 
/*     */   protected boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 155 */     BindingExt binding = (BindingExt)getBindingProvider().getBinding();
/* 156 */     HandlerChainExecutor executor = new HandlerChainExecutor(this.epMetaData, binding.getHandlerChain(type));
/* 157 */     this.executorMap.put(type, executor);
/*     */ 
/* 159 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 160 */     return executor.handleMessage(msgContext);
/*     */   }
/*     */ 
/*     */   protected boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 166 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 167 */     HandlerChainExecutor executor = (HandlerChainExecutor)this.executorMap.get(type);
/* 168 */     return executor != null ? executor.handleMessage(msgContext) : true;
/*     */   }
/*     */ 
/*     */   protected boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/* 174 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 175 */     HandlerChainExecutor executor = (HandlerChainExecutor)this.executorMap.get(type);
/* 176 */     return executor != null ? executor.handleFault(msgContext, ex) : true;
/*     */   }
/*     */ 
/*     */   protected void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 182 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/* 183 */     HandlerChainExecutor executor = (HandlerChainExecutor)this.executorMap.get(type);
/* 184 */     if (executor != null)
/* 185 */       executor.close(msgContext);
/*     */   }
/*     */ 
/*     */   protected void setInboundContextProperties()
/*     */   {
/* 191 */     MessageContext msgContext = (MessageContext)MessageContextAssociation.peekMessageContext();
/*     */ 
/* 194 */     msgContext.put("javax.xml.ws.binding.attachments.inbound", new HashMap());
/*     */ 
/* 197 */     if (msgContext.containsKey(CommonMessageContext.REMOTING_METADATA))
/*     */     {
/* 199 */       Map remotingMetadata = (Map)msgContext.get(CommonMessageContext.REMOTING_METADATA);
/*     */ 
/* 202 */       Integer resposeCode = (Integer)remotingMetadata.get("ResponseCode");
/* 203 */       if (resposeCode != null) {
/* 204 */         msgContext.put("javax.xml.ws.http.response.code", resposeCode);
/*     */       }
/*     */ 
/* 207 */       Map headers = new HashMap();
/* 208 */       for (Map.Entry en : remotingMetadata.entrySet())
/*     */       {
/* 210 */         if (((en.getKey() instanceof String)) && ((en.getValue() instanceof List)))
/* 211 */           headers.put((String)en.getKey(), (List)en.getValue());
/*     */       }
/* 213 */       msgContext.put("javax.xml.ws.http.response.headers", headers);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setOutboundContextProperties()
/*     */   {
/* 221 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 222 */     msgContext.put("javax.xml.ws.handler.message.outbound", Boolean.TRUE);
/*     */ 
/* 225 */     msgContext.put("javax.xml.ws.binding.attachments.outbound", new HashMap());
/*     */   }
/*     */ 
/*     */   public Object invoke(QName opName, Object[] args, Map<String, Object> resContext)
/*     */     throws RemoteException
/*     */   {
/* 232 */     CommonMessageContext msgContext = new SOAPMessageContextJAXWS();
/* 233 */     MessageContextAssociation.pushMessageContext(msgContext);
/*     */ 
/* 238 */     Map reqContext = getBindingProvider().getRequestContext();
/* 239 */     msgContext.putAll(reqContext);
/*     */     try
/*     */     {
/* 243 */       Object retObj = invoke(opName, args, false);
/* 244 */       Object localObject1 = retObj;
/*     */       String key;
/*     */       Object value;
/*     */       return localObject1;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 248 */       OperationMetaData opMetaData = getOperationMetaData();
/* 249 */       if (opMetaData.isOneWay())
/*     */       {
/* 251 */         handleOneWayException(opMetaData, ex);
/*     */       }
/*     */       else
/*     */       {
/* 255 */         handleRemoteException(opMetaData, ex);
/*     */       }
/* 257 */       Iterator i$ = null;
/*     */       Iterator i$;
/*     */       String key;
/*     */       Object value;
/*     */       return i$;
/*     */     }
/*     */     finally
/*     */     {
/* 262 */       msgContext = MessageContextAssociation.peekMessageContext();
/* 263 */       for (String key : msgContext.keySet())
/*     */       {
/* 265 */         Object value = msgContext.get(key);
/* 266 */         resContext.put(key, value);
/*     */       }
/*     */ 
/* 270 */       MessageContextAssociation.popMessageContext(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   protected CommonMessageContext processPivot(CommonMessageContext reqMessageContext)
/*     */   {
/* 276 */     MessageContextJAXWS resMessageContext = MessageContextJAXWS.processPivot(reqMessageContext);
/* 277 */     return resMessageContext;
/*     */   }
/*     */ 
/*     */   private void handleOneWayException(OperationMetaData opMetaData, Exception ex)
/*     */   {
/* 286 */     if ((ex instanceof WebServiceException))
/*     */     {
/* 288 */       throw ((WebServiceException)ex);
/*     */     }
/*     */ 
/* 292 */     throw new WebServiceException(ex);
/*     */   }
/*     */ 
/*     */   private void handleRemoteException(OperationMetaData opMetaData, Exception ex)
/*     */   {
/* 304 */     String bindingId = opMetaData.getEndpointMetaData().getBindingId();
/* 305 */     if ((bindingId.startsWith("http://schemas.xmlsoap.org/wsdl/soap/http")) || (bindingId.startsWith("http://www.w3.org/2003/05/soap/bindings/HTTP/")))
/*     */     {
/* 307 */       if ((ex instanceof SOAPFaultException))
/*     */       {
/* 309 */         throw ((SOAPFaultException)ex);
/*     */       }
/* 311 */       if ((ex instanceof WebServiceException))
/*     */       {
/* 313 */         throw ((WebServiceException)ex);
/*     */       }
/*     */ 
/* 317 */       throw new WebServiceException(ex);
/*     */     }
/*     */ 
/* 320 */     if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingId))
/*     */     {
/* 323 */       WebServiceException wsEx = new HTTPException(-1);
/* 324 */       wsEx.initCause(ex);
/* 325 */       throw wsEx;
/*     */     }
/*     */ 
/* 329 */     throw new WebServiceException("Unsuported binding: " + bindingId, ex);
/*     */   }
/*     */ 
/*     */   public void setTargetEndpointAddress(String endpointAddress)
/*     */   {
/* 336 */     getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
/*     */   }
/*     */ 
/*     */   public String getTargetEndpointAddress()
/*     */   {
/* 342 */     return (String)getRequestContext().get("javax.xml.ws.service.endpoint.address");
/*     */   }
/*     */ 
/*     */   protected CommonBindingProvider getCommonBindingProvider()
/*     */   {
/* 348 */     if (this.bindingProvider == null)
/*     */     {
/* 350 */       this.bindingProvider = new BindingProviderImpl(getEndpointMetaData());
/*     */     }
/* 352 */     return this.bindingProvider;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getRequestContext()
/*     */   {
/* 357 */     return getBindingProvider().getRequestContext();
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getResponseContext()
/*     */   {
/* 362 */     return getBindingProvider().getResponseContext();
/*     */   }
/*     */ 
/*     */   public Binding getBinding()
/*     */   {
/* 367 */     return getBindingProvider().getBinding();
/*     */   }
/*     */ 
/*     */   public BindingProvider getBindingProvider()
/*     */   {
/* 372 */     return (BindingProvider)getCommonBindingProvider();
/*     */   }
/*     */ 
/*     */   public EndpointReference getEndpointReference()
/*     */   {
/* 377 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T extends EndpointReference> T getEndpointReference(Class<T> clazz)
/*     */   {
/* 382 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName, String configFile)
/*     */   {
/* 387 */     ConfigurationProvider configProvider = getEndpointMetaData();
/* 388 */     configProvider.setConfigName(configName, configFile);
/*     */   }
/*     */ 
/*     */   public Set<QName> getHeaders()
/*     */   {
/* 397 */     Set headers = new HashSet();
/*     */ 
/* 399 */     BindingExt binding = (BindingExt)getBinding();
/*     */ 
/* 401 */     for (UnifiedHandlerMetaData.HandlerType type : HANDLER_TYPES)
/*     */     {
/* 403 */       for (Handler bindingHandler : binding.getHandlerChain(type))
/*     */       {
/* 405 */         if ((bindingHandler instanceof SOAPHandler)) {
/* 406 */           headers.addAll(((SOAPHandler)bindingHandler).getHeaders());
/*     */         }
/*     */       }
/*     */     }
/* 410 */     return headers;
/*     */   }
/*     */ 
/*     */   protected boolean shouldMaintainSession()
/*     */   {
/* 416 */     Object bool = getRequestContext().get("javax.xml.ws.session.maintain");
/* 417 */     return Boolean.TRUE.equals(bool);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.client.ClientImpl
 * JD-Core Version:    0.6.0
 */