/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import javax.xml.ws.soap.SOAPBinding;
/*     */ import org.jboss.ws.core.CommonSOAP11Binding;
/*     */ import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
/*     */ import org.jboss.ws.core.soap.SOAPFaultImpl;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class SOAP11BindingJAXWS extends CommonSOAP11Binding
/*     */   implements BindingExt, SOAPBinding
/*     */ {
/*  50 */   private SOAPBindingJAXWS delegate = new SOAPBindingJAXWS();
/*     */ 
/*     */   public SOAP11BindingJAXWS()
/*     */   {
/*  54 */     setMTOMEnabled(false);
/*     */   }
/*     */ 
/*     */   public SOAP11BindingJAXWS(boolean mtomEnabled)
/*     */   {
/*  59 */     setMTOMEnabled(mtomEnabled);
/*     */   }
/*     */ 
/*     */   public void setSOAPActionHeader(OperationMetaData opMetaData, SOAPMessage reqMessage)
/*     */   {
/*  64 */     this.delegate.setSOAPActionHeader(opMetaData, reqMessage);
/*     */   }
/*     */ 
/*     */   public Set<String> getRoles()
/*     */   {
/*  72 */     Set soap11Roles = new HashSet(this.delegate.getRoles());
/*  73 */     soap11Roles.add("http://schemas.xmlsoap.org/soap/actor/next");
/*  74 */     return soap11Roles;
/*     */   }
/*     */ 
/*     */   public void setRoles(Set<String> roles)
/*     */   {
/*  79 */     this.delegate.setRoles(roles);
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain()
/*     */   {
/*  84 */     return this.delegate.getHandlerChain();
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/*  89 */     return this.delegate.getHandlerChain(handlerType);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain)
/*     */   {
/*  94 */     this.delegate.setHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/*  99 */     this.delegate.setHandlerChain(handlerChain, handlerType);
/*     */   }
/*     */ 
/*     */   public SOAPMessage createFaultMessageFromException(Exception ex)
/*     */   {
/* 104 */     return SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
/*     */   }
/*     */ 
/*     */   protected void throwFaultException(SOAPFaultImpl fault) throws Exception
/*     */   {
/* 109 */     throw SOAPFaultHelperJAXWS.getSOAPFaultException(fault);
/*     */   }
/*     */ 
/*     */   public String getBindingID()
/*     */   {
/* 114 */     return isMTOMEnabled() ? "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true" : "http://schemas.xmlsoap.org/wsdl/soap/http";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.SOAP11BindingJAXWS
 * JD-Core Version:    0.6.0
 */