/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.ws.handler.Handler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonBinding;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.EndpointInvocation;
/*     */ import org.jboss.ws.core.HeaderSource;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.jaxws.SOAPFaultHelperJAXWS;
/*     */ import org.jboss.ws.core.jaxws.handler.SOAPMessageContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.UnboundHeader;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class MessageBinding
/*     */   implements CommonBinding, BindingExt
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(MessageBinding.class);
/*     */ 
/*  61 */   private BindingImpl delegate = new BindingImpl();
/*     */ 
/*     */   public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/*  66 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction reqMessage)
/*     */     throws BindingException
/*     */   {
/*  72 */     log.debug("unbindRequestMessage: " + opMetaData.getQName());
/*     */     try
/*     */     {
/*  76 */       EndpointInvocation epInv = new EndpointInvocation(opMetaData);
/*     */ 
/*  78 */       SOAPMessageContextJAXWS msgContext = (SOAPMessageContextJAXWS)MessageContextAssociation.peekMessageContext();
/*  79 */       if (msgContext == null) {
/*  80 */         throw new WSException("MessageContext not available");
/*     */       }
/*  82 */       ParameterMetaData paramMetaData = (ParameterMetaData)opMetaData.getParameters().get(0);
/*  83 */       QName xmlName = paramMetaData.getXmlName();
/*  84 */       epInv.setRequestParamValue(xmlName, reqMessage);
/*     */ 
/*  86 */       return epInv;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  90 */       handleException(e);
/*  91 */     }return null;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv)
/*     */     throws BindingException
/*     */   {
/*  98 */     log.debug("bindResponseMessage: " + opMetaData.getQName());
/*     */     try
/*     */     {
/* 101 */       SOAPMessageContextJAXWS msgContext = (SOAPMessageContextJAXWS)MessageContextAssociation.peekMessageContext();
/* 102 */       if (msgContext == null) {
/* 103 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 106 */       MessageAbstraction resMessage = (MessageAbstraction)epInv.getReturnValue();
/* 107 */       msgContext.setMessageAbstraction(resMessage);
/*     */ 
/* 109 */       return resMessage;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 113 */       handleException(e);
/* 114 */     }return null;
/*     */   }
/*     */ 
/*     */   public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction resMessage, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/* 122 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindFaultMessage(Exception ex)
/*     */   {
/* 127 */     SOAPMessageImpl faultMessage = SOAPFaultHelperJAXWS.exceptionToFaultMessage(ex);
/* 128 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 129 */     if (msgContext != null)
/*     */     {
/* 131 */       msgContext.setSOAPMessage(faultMessage);
/*     */     }
/*     */     else
/*     */     {
/* 135 */       log.warn("Cannot set fault message in message context");
/*     */     }
/* 137 */     return faultMessage;
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain()
/*     */   {
/* 142 */     return this.delegate.getHandlerChain();
/*     */   }
/*     */ 
/*     */   public List<Handler> getHandlerChain(UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 147 */     return this.delegate.getHandlerChain(handlerType);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain)
/*     */   {
/* 152 */     this.delegate.setHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public void setHandlerChain(List<Handler> handlerChain, UnifiedHandlerMetaData.HandlerType handlerType)
/*     */   {
/* 157 */     this.delegate.setHandlerChain(handlerChain, handlerType);
/*     */   }
/*     */ 
/*     */   public String getBindingID()
/*     */   {
/* 162 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setHeaderSource(HeaderSource source)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex)
/*     */     throws BindingException
/*     */   {
/* 172 */     if ((ex instanceof RuntimeException)) {
/* 173 */       throw ((RuntimeException)ex);
/*     */     }
/* 175 */     if ((ex instanceof BindingException)) {
/* 176 */       throw ((BindingException)ex);
/*     */     }
/* 178 */     throw new BindingException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.MessageBinding
 * JD-Core Version:    0.6.0
 */