/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.HTTPMessageImpl;
/*     */ 
/*     */ public class HTTPMessageUnMarshaller
/*     */   implements UnMarshaller
/*     */ {
/*  49 */   private static Logger log = Logger.getLogger(HTTPMessageUnMarshaller.class);
/*     */ 
/*  51 */   private static List validResponseCodes = new ArrayList();
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  61 */     if (log.isTraceEnabled())
/*     */     {
/*  63 */       log.trace("Read input stream with metadata=" + metadata);
/*     */     }
/*     */ 
/*  66 */     Integer resCode = (Integer)metadata.get("ResponseCode");
/*  67 */     String resMessage = (String)metadata.get("ResponseCodeMessage");
/*  68 */     if ((resCode != null) && (!validResponseCodes.contains(resCode))) {
/*  69 */       throw new WSException("Invalid HTTP server response [" + resCode + "] - " + resMessage);
/*     */     }
/*  71 */     MimeHeaders mimeHeaders = getMimeHeaders(metadata);
/*  72 */     HTTPMessageImpl soapMsg = new HTTPMessageImpl(mimeHeaders, inputStream);
/*  73 */     return soapMsg;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classloader)
/*     */   {
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/*  91 */     return new HTTPMessageUnMarshaller();
/*     */   }
/*     */ 
/*     */   private MimeHeaders getMimeHeaders(Map metadata)
/*     */   {
/*  96 */     log.debug("getMimeHeaders from: " + metadata);
/*     */ 
/*  98 */     MimeHeaders headers = new MimeHeaders();
/*  99 */     Iterator i = metadata.keySet().iterator();
/*     */     String key;
/*     */     Iterator i$;
/* 100 */     while (i.hasNext())
/*     */     {
/* 102 */       key = (String)i.next();
/* 103 */       Object value = metadata.get(key);
/* 104 */       if ((key != null) && ((value instanceof List)))
/*     */       {
/* 106 */         for (i$ = ((List)value).iterator(); i$.hasNext(); ) { Object listValue = i$.next();
/*     */ 
/* 108 */           headers.addHeader(key, listValue.toString());
/*     */         }
/*     */       }
/*     */     }
/* 112 */     return headers;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  54 */     validResponseCodes.add(Integer.valueOf(200));
/*  55 */     validResponseCodes.add(Integer.valueOf(202));
/*  56 */     validResponseCodes.add(Integer.valueOf(500));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.HTTPMessageUnMarshaller
 * JD-Core Version:    0.6.0
 */