/*    */ package org.jboss.ws.core.jaxws.binding;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.OutputStream;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.invocation.OnewayInvocation;
/*    */ import org.jboss.remoting.marshal.Marshaller;
/*    */ import org.jboss.ws.core.HTTPMessageImpl;
/*    */ import org.jboss.ws.core.soap.XMLFragment;
/*    */ import org.jboss.wsf.common.DOMWriter;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class HTTPMessageMarshaller
/*    */   implements Marshaller
/*    */ {
/* 42 */   private static Logger log = Logger.getLogger(HTTPMessageMarshaller.class);
/*    */ 
/*    */   public void write(Object dataObject, OutputStream output)
/*    */     throws IOException
/*    */   {
/* 55 */     if ((dataObject instanceof InvocationRequest)) {
/* 56 */       dataObject = ((InvocationRequest)dataObject).getParameter();
/*    */     }
/* 58 */     if ((dataObject instanceof OnewayInvocation)) {
/* 59 */       dataObject = ((OnewayInvocation)dataObject).getParameters()[0];
/*    */     }
/* 61 */     if (!(dataObject instanceof HTTPMessageImpl)) {
/* 62 */       throw new IllegalArgumentException("Not a HTTPMessage: " + dataObject);
/*    */     }
/* 64 */     HTTPMessageImpl httpMessage = (HTTPMessageImpl)dataObject;
/* 65 */     Element root = httpMessage.getXmlFragment().toElement();
/*    */ 
/* 68 */     if (log.isTraceEnabled())
/*    */     {
/* 70 */       log.trace("Outgoing Message\n" + DOMWriter.printNode(root, true));
/*    */     }
/*    */ 
/* 73 */     new DOMWriter(output).print(root);
/*    */   }
/*    */ 
/*    */   public Marshaller cloneMarshaller() throws CloneNotSupportedException
/*    */   {
/* 78 */     return new HTTPMessageMarshaller();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.HTTPMessageMarshaller
 * JD-Core Version:    0.6.0
 */