/*     */ package org.jboss.ws.core.jaxws.binding;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.ws.Binding;
/*     */ import javax.xml.ws.EndpointReference;
/*     */ import javax.xml.ws.Service.Mode;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import javax.xml.ws.wsaddressing.BindingProvider21;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ 
/*     */ public class BindingProviderImpl extends CommonBindingProvider
/*     */   implements BindingProvider21
/*     */ {
/*  51 */   private Map<String, Object> requestContext = new HashMap();
/*  52 */   private Map<String, Object> responseContext = new HashMap();
/*     */ 
/*     */   public BindingProviderImpl(EndpointMetaData epMetaData)
/*     */   {
/*  56 */     super(epMetaData);
/*     */   }
/*     */ 
/*     */   public BindingProviderImpl(String bindingId)
/*     */   {
/*  61 */     super(bindingId, EndpointMetaData.Type.JAXWS);
/*     */   }
/*     */ 
/*     */   protected void initBinding(String bindingId, EndpointMetaData.Type type)
/*     */   {
/*  67 */     super.initBinding(bindingId, type);
/*     */ 
/*  69 */     if (!"http://www.w3.org/2004/08/wsdl/http".equals(bindingId))
/*     */     {
/*  71 */       Service.Mode serviceMode = this.epMetaData != null ? this.epMetaData.getServiceMode() : null;
/*  72 */       if (serviceMode == Service.Mode.MESSAGE)
/*     */       {
/*  74 */         this.binding = new MessageBinding();
/*     */       }
/*  76 */       else if (serviceMode == Service.Mode.PAYLOAD)
/*     */       {
/*  78 */         this.binding = new PayloadBinding();
/*     */       }
/*     */     }
/*     */ 
/*  82 */     if (this.binding == null)
/*  83 */       throw new WebServiceException("Unsupported binding: " + bindingId);
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getRequestContext()
/*     */   {
/*  88 */     return this.requestContext;
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getResponseContext()
/*     */   {
/*  93 */     return this.responseContext;
/*     */   }
/*     */ 
/*     */   public Binding getBinding()
/*     */   {
/*  98 */     return (Binding)this.binding;
/*     */   }
/*     */ 
/*     */   public EndpointReference getEndpointReference()
/*     */   {
/* 103 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public <T extends EndpointReference> T getEndpointReference(Class<T> clazz)
/*     */   {
/* 108 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.binding.BindingProviderImpl
 * JD-Core Version:    0.6.0
 */