/*     */ package org.jboss.ws.core.jaxws;
/*     */ 
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.Marshaller;
/*     */ import javax.xml.datatype.XMLGregorianCalendar;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*     */ import org.jboss.ws.core.binding.ComplexTypeSerializer;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.extensions.xop.jaxws.AttachmentMarshallerImpl;
/*     */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ 
/*     */ public class JAXBSerializer extends ComplexTypeSerializer
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(JAXBSerializer.class);
/*     */ 
/*     */   public JAXBSerializer()
/*     */     throws BindingException
/*     */   {
/*     */   }
/*     */ 
/*     */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*     */   {
/*  61 */     if (log.isDebugEnabled()) log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*     */ 
/*  63 */     Result result = null;
/*     */     try
/*     */     {
/*  68 */       Class expectedType = serContext.getJavaType();
/*  69 */       Class actualType = value.getClass();
/*  70 */       Class[] types = { expectedType, shouldFilter(actualType) ? new Class[] { expectedType } : actualType };
/*  71 */       JAXBContext jaxbContext = getJAXBContext(types);
/*     */ 
/*  73 */       Marshaller marshaller = jaxbContext.createMarshaller();
/*     */ 
/*  75 */       marshaller.setProperty("jaxb.fragment", Boolean.valueOf(true));
/*  76 */       marshaller.setAttachmentMarshaller(new AttachmentMarshallerImpl());
/*     */ 
/*  80 */       result = new BufferedStreamResult();
/*  81 */       marshaller.marshal(new JAXBElement(xmlName, expectedType, value), result);
/*     */ 
/*  83 */       if (log.isDebugEnabled()) log.debug("serialized: " + result);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  87 */       handleMarshallException(ex);
/*     */     }
/*     */ 
/*  90 */     return result;
/*     */   }
/*     */ 
/*     */   private JAXBContext getJAXBContext(Class[] types)
/*     */   {
/*  99 */     JAXBContextCache cache = JAXBContextCache.getContextCache();
/* 100 */     JAXBContext context = cache.get(types);
/* 101 */     if (null == context)
/*     */     {
/* 103 */       BindingCustomization bindingCustomization = getBindingCustomization();
/* 104 */       context = JAXBContextFactory.newInstance().createContext(types, bindingCustomization);
/* 105 */       cache.add(types, context);
/*     */     }
/* 107 */     return context;
/*     */   }
/*     */ 
/*     */   private boolean shouldFilter(Class<?> actualType)
/*     */   {
/* 113 */     return XMLGregorianCalendar.class.isAssignableFrom(actualType);
/*     */   }
/*     */ 
/*     */   private void handleMarshallException(Exception ex)
/*     */   {
/* 121 */     if ((ex instanceof WebServiceException)) {
/* 122 */       throw ((WebServiceException)ex);
/*     */     }
/* 124 */     throw new WebServiceException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.JAXBSerializer
 * JD-Core Version:    0.6.0
 */